/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taZ_StarControl.c  Display switching module 
 Processes display output from taStarControl.c
*/


#include "taGlobal.h"
#include "taConfig.h"
#include <math.h>
#include "taDebug.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taCharLCD.h"
#include "taProgmem.h"
#include "taFT245R.h"
#include "taGraphicsControl.h"
#include "taDDS.h"
#include "taZ_DDS.h"
#include "TrxAVR.h"
#include "taZ_StarControl.h"
#include "taSmeter.h"
#include "taKeys.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsEA320.h"
#include "taEATFT.h"
#include "taEATFTcommands.h"
#include "taEATFTmenus.h"
#include "taKS0108Driver.h"
#include "taKS0108.h"
#include "taKS0108Menus.h"
#include "taRTC.h"



#define clWhite 1
#define clBlack 0

#define EA320SwitchesX 3
#define EA320SwitchesY 72
#define EA320SwitchSpacing 10

#define FreqInfoX 3
#define FreqInfoY 44

#define LayerTR 1   // all layer graphic , all text uses graphics
#define LayerRx 2
#define LayerTx 3

#define SwOnColour 8
#define SwOffColour 11
#define SwDataOnColour 15
#define SwDataOffColour 2

#define SwitchesX 56 // TFT colour
#define SwitchesY 90 // TFT colour

#define G128ColourX  0
#define G128IP3X  21
#define G128SwitchesX 35
#define G128AttenX 72
#define G128ModeX 89
#define G128FilterX 109

uint8_t zscSwitchColour(uint8_t on);
uint8_t zscSwitchDataColour(uint8_t on);

////////////////////////////////////////////////////////////////

//  *********    keypad frequency input  ********************

uint32_t zscKeyInFreq() __attribute__((section(".highmem")));
uint32_t zscKeyInFreq()
{
	uint8_t digits[8];
	uint32_t f, freq = 0;
	uint8_t k;
	uint8_t i,j;
	uint8_t xpos = 0;
	uint8_t LeadingZero;
	
	i = 0;
	if (zc) { 	
		if (VFO == 0) xpos = 22; else xpos = 32;
		if ((XIT == 1) || (RIT == 1)) xpos = 21;
		cdSetPos(1, xpos);
		cdDisplayString(pmdSpaces(8));
		cdShowCursor(1);
	}
	if (zg) {
		gedSwitchLayer(LayerTR);
		gedClearFrequencyDisplay(VFO, 0); // 0 = no decimal points
	}
	if(zs) ksClearFrequencyDisplay(VFO);
	if (zt) etClearFrequencyDisplay(VFO);	
	do
	{
		if (zc) cdSetPos(1, xpos+i);
		_delay_ms(10);		
		do {k = kyGetKeyChar(); _delay_ms(10);} while ((k != 'E') && (k != '#') && ((k < '0') || (k > '9'))); // wait for another	
		if ((k == 'E') || (k == '#')) {
			if (zc) cdShowCursor(0);
			if (zg) gedClearFrequencyDisplay(VFO, 1); // 1 = restore decimal points
			if (zt) etClearFrequencyDisplay(VFO);
			return 0;
		}
		digits[i] = k-0x30;
		if (zc) cdPutByte(1, k);
		if (zg) gedWriteDigit(digits[i], i, VFO, VFO);
		if (zt)
		{
			f = digits[0];
			if (i > 0) {for (j = 1; j <= i; j++) {f = f*10 + digits[j];}}
			if (digits[0] == 0) LeadingZero = 1; else LeadingZero = 0;
			etDisplayFrequencyNoDP(f, VFO, LeadingZero);  // no decimal point during freq entry
		}
		if (zs)
		{
			f = digits[0];
			if (i > 0) {for (j = 1; j <= i; j++) {f = f*10 + digits[j];}}
			if (digits[0] == 0) LeadingZero = 1; else LeadingZero = 0;
			ksDisplayFrequencyNoDP(f, VFO, LeadingZero);  // no decimal point during freq entry
		}

		i += 1;
	} while(i < 7);  
	_delay_ms(200);
	if (zc) cdShowCursor(0);
	if (zg) gedClearFrequencyDisplay(VFO, 1); // 1 = restore decimal points		  
	if (zs) ksClearFrequencyDisplay(VFO);
	if (zt) {etClearFrequencyDisplay(VFO); zddsShowBothVfoFreqs();}
	freq = digits[0];
	for (i = 1; i < 7; i++) {freq = freq*10 + digits[i];} 
	return freq*10;
}


void zscGraphicsTR() __attribute__((section(".highmem")));
void zscGraphicsTR()
{
	if (zg)   // graphics
	{
		if	(Transmit == 1) {gedShowLayer(2, 0); gedShowLayer(3, 1);}
		else {gedShowLayer(2, 1); gedShowLayer(3, 0);}
		gedSwitchLayer(LayerTR);
	}
}


void zscDisplayMemStack() __attribute__((section(".highmem")));
void zscDisplayMemStack()
{	
  if((zc)&&(XRIT()==0))   // charlcd
	{ 	
		cdSetPos(1,20);
		cdDisplayString(pmdSpaces(20));  // clear normal VFO info
	  cdSetPos(1,20);
		cdDisplayString(PMS(s_MemStack));
	}
	if(zs)
	{
		ksWriteFreqInfoHeader(PMS(s_MemStk));	
		ksWriteFreqInfoData(PMS(s_tune_));	
	}
	if(zt)
	{
		etTuneBox();
		strcpy(StrA,PMS(s_Mem_stack));
		strcat(StrA,PMS(s_pipe));
		strcat(StrA,PMS(s_tuning_));
		etTuneText(StrA);
	}
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		geClearParamBox();
		gedF8WriteString(PMS(s_Memory_stack),FreqInfoX,FreqInfoY);
		gedF8WriteString(PMS(s_tuning_mode_),FreqInfoX,FreqInfoY+12);
    	gedF8WriteString(PMS(s_mem_),7,2);
	}  
}


void zscMemSlotSavedMessage() __attribute__((section(".highmem")));
void zscMemSlotSavedMessage()
{
	if(zc)   // charlcd
	{ 	
		cdSetPos(2,0);
		cdDisplayString(pmdSpaces(20));
		cdSetPos(2,0);
		strcpy(StrA,PMS(s_Saved_stack6x_sloty));
		uint8_t b = (MemStackNo + 7) % 10;
		StrA[12] = b + 0x30;
		StrA[18] = MemSlotNo + 1 + 0x30; 
 		cdDisplayString(StrA);
		_delay_ms(2500);
	}		  
	if (zg)   // graphics
	{
	}  
}



void zscShowMemStackSlotNo() __attribute__((section(".highmem")));
void zscShowMemStackSlotNo()
{
  uint8_t stack;
	stack = MemStackNo + 7;
	if (stack == 10) stack = 0;  //   67, 68, 69 ,60  in Stacks 0,1,2,3
	if (zc)   // charlcd
	{ 	
		ltoa(60+stack, StrA, 10);
		if (MemSlotNo == 255) strcat(StrA, PMS(s_3hyphens));
		else
		{
			ltoa(61+MemSlotNo, &StrA[3], 10);
			memcpy(&StrA[2], ":", 1);
		}
		cdSetPos(1, 15);
		cdDisplayString(StrA);  
	}
	if (zt) etStackSlot(MemStackNo, MemSlotNo);
	
	if (zs)
	{
		strcpy(StrA,PMS(s_M));
		ltoa(60+stack, StrB, 10);
		strcat(StrA,StrB);
		strcat(StrA,":");		
		if (MemSlotNo == 255) strcpy(StrB, PMS(s_2hyphens));
		else
		{
			ltoa(61+MemSlotNo, StrB, 10);
			strcat(StrB, pmdSpaces(1));
		}
		strcat(StrA,StrB);
		ksdF8WriteString(StrA,0,1,0);
	}
	
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		gedF8WriteString(PMS(s_mem_), 7, 2);
		ltoa(60+stack, StrA, 10);
		gedF16WriteString(StrA, 10, 10);
		if (MemSlotNo == 255) strcpy(StrA, PMS(s_3hyphens));
		else
		{
			ltoa(61+MemSlotNo, StrA, 10);
			strcat(StrA, pmdSpaces(1));
		}
   		gedF16WriteString(StrA, 10, 23);
	}
}


/////////////////////////////////////////////////////////////////////////////////////////////
/// TUNE, STACK, RITXIT and PARAM BOXES are all same on 320x240 graphics
/// - but different on colour TFT


void zscClearStackBox() __attribute__((section(".highmem")));
void zscClearStackBox()
{
	if (zt) etStackSlot(MemStackNo,255);  // 255 means stack only displayed
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
    	Brush.Color = clBlack;
		gedFillRect(1,1,33,38);
    	Brush.Color = clWhite;;
	}
}



void zscClearTuneBox() __attribute__((section(".highmem")));
void zscClearTuneBox()
{
	if (zt) etDeleteTuneBox();
	if (zs) ksClearFreqInfo(); ksmDrawDateTime();
}



void zscClearRITXITBox() __attribute__((section(".highmem")));
void zscClearRITXITBox()
{
	if (zc)
	{
		cdSetPos(2,20);
		cdDisplayString(pmdSpaces(6));
	}
	if (zt) etClearRITXIT();
	if (zs) ksClearRITXIT();
	if (zg) geClearParamBox();
}





//////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

void zscClearScanInfoDisplay() __attribute__((section(".highmem")));
void zscClearScanInfoDisplay()
{
  if(zc)   // charlcd
	{ 	
	  if((SigGenMode==1)||(ClockCalMode==1)||(XRIT()!=0)){return;};
		cdSetPos(2,20);
		cdDisplayString(pmdSpaces(6));
	}
}



void zscShowStickyVolatile(char sv, uint8_t slotno) __attribute__((section(".highmem")));
void zscShowStickyVolatile(char sv, uint8_t slotno)
{
  if (zc)   // charlcd or 128x64
	{ 	
		if (sv == 'V') strcpy(StrA, PMS(s_Vo_));
		else strcpy(StrA, PMS(s_St_));
		ltoa(slotno, StrB, 10);
		strcat(StrA, StrB);
		cdSetPos(1, 15);
		cdDisplayString(pmdSpaces(5));
		cdSetPos(1, 15);
		cdDisplayString(StrA);
	}

	if (zs)
	{
		if (sv == 'V') strcpy(StrA, PMS(s_Vola_));
		else strcpy(StrA, PMS(s_Stky_));
		ltoa(slotno, StrB, 10);
		strcat(StrA, StrB);
		ksWriteFreqInfoData(StrA);
	}
	if (zt) etShowSlickyVolatile(sv, slotno);
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		if (sv == 'V') strcpy(StrA, PMS(s_Volatile_slot_no_));
		else strcpy(StrA, PMS(s_Sticky_slot_no_));
		ltoa(slotno, StrB, 10);
		strcat(StrA, StrB);
		geClearParamBoxLower();
		gedF8WriteString(StrA, FreqInfoX, FreqInfoY+12);     
	}  
}


void zscRestoreLeftDisplay() __attribute__((section(".highmem")));
void zscRestoreLeftDisplay()
{
	if (zc)   // charlcd
	{ 	
		cdSetPos(1,0);
		cdDisplayString(pmdSpaces(20));
		cdSetPos(2,0);
		cdDisplayString(pmdSpaces(20));
		zscShowMemStackSlotNo();
		zscShowSwitches();
		if ((Transmit == 0) || (MenuExit == 1)) smStartSmeter();
		MenuExit = 0;
		dspSetLed(ParamColour);	  // calls zscDisplayParamColour()
		zscDisplayIP3NF();
	}
	// ? no graphics eqivalent
}



void zscClearDSPKeys(uint8_t opt) __attribute__((section(".highmem")));
void zscClearDSPKeys(uint8_t opt)
{
	if ((zt) && ((opt == 0) || (opt == 2)))
	{
		MenuW = MenuWstandard;
		emeDeleteMenu();
		ztDSPDisplay = 0;
	}
	
	if ((zg) && ((opt == 0) || (opt == 1)))
	{
		gedSwitchLayer(LayerRx);
		Brush.Color = 0;
		gedFillRect(RxTxMsgX, RxMsgY, RxTxMsgX+RxTxMsgWidth, RxMsgY+RxMsgHeight);
		Brush.Color = 1;
		gedSwitchLayer(LayerTR);
		zgDSPDisplay = 0;
	}
}


void zscDrawDDSKeysFrame(uint8_t opt) __attribute__((section(".highmem")));
void zscDrawDDSKeysFrame(uint8_t opt)
{
	if (opt) {zgDSPDisplay = 0; ztDSPDisplay = 0;}
	if (zt && !ztDSPDisplay)
	{
		MenuW = MenuWstandard;
		emeMenuFrame();
		ztDSPDisplay = 0;
	}
	
	if (zg && !zgDSPDisplay)
	{
		gedSwitchLayer(LayerRx);
		Brush.Color = 0;
		gedFillRect(RxTxMsgX+1, RxMsgY+1, RxTxMsgX+RxTxMsgWidth-1, RxMsgY+RxMsgHeight-1);
		Brush.Color = 1;
		gedHorizLine(RxTxMsgX, RxTxMsgX+RxTxMsgWidth, RxMsgY, 1);
		gedHorizLine(RxTxMsgX, RxTxMsgX+RxTxMsgWidth, RxMsgY+RxMsgHeight, 1);
		gedVertLine(RxMsgY, RxMsgY+RxMsgHeight, RxTxMsgX, 1);
		gedVertLine(RxMsgY, RxMsgY+RxMsgHeight, RxTxMsgX+RxTxMsgWidth, 1);
		gedSwitchLayer(LayerTR);
		zgDSPDisplay = 0;
	}
}


void zscShowDSPKeys() __attribute__((section(".highmem")));
void zscShowDSPKeys()
{
	if ((DisplayingMenu) || (DisplaySwitch == 2)) return;
	if ((DDSparams.dpDSPDDSKeysDisplay == 0) || (DDSparams.dpDSPDDSKeysDisplay == 1)) return;
	if((TuningMode=='S') && (ScanMode!='W')) return;
	// dont update DSP keys during scanning 	

	if ((zt) || (zg)) zscDrawDDSKeysFrame(0);
	
	if (zt && !ztDSPDisplay)
	{
		etcTextColour(10, 1);
		etcFont(Arial12);
		strcpy(StrA, PMS(s_DSPKey_1));
		emeMenuString(2, 2, 'L', StrA);
		strcpy(StrA, PMS(s_DSPKey_2));
		emeMenuString(2, 15, 'L', StrA);
		strcpy(StrA, PMS(s_DSPKey_3));
		emeMenuString(2, 28, 'L', StrA);
		if (Mode < 2) strcpy(StrA, PMS(s_DSPKey_4_SSB));
		else strcpy(StrA, PMS(s_DSPKey_4_CW));
		emeMenuString(2, 41, 'L', StrA);
		strcpy(StrA, PMS(s_DSPKey_5));
		emeMenuString(2, 54, 'L', StrA);
		if (Mode < 2) strcpy(StrA, PMS(s_DSPKey_6_SSB));
		else strcpy(StrA, PMS(s_DSPKey_6_CW));
		emeMenuString(2, 67, 'L', StrA);
		if (Mode < 2) strcpy(StrA, PMS(s_DSPKey_7_SSB));
		else strcpy(StrA, PMS(s_DSPKey_7_CW));
		emeMenuString(2, 80, 'L', StrA);
		strcpy(StrA, PMS(s_DSPKey_8));
		emeMenuString(2, 93, 'L', StrA);
		if (Mode < 2) strcpy(StrA, PMS(s_DSPKey_9_SSB));
		else strcpy(StrA, PMS(s_DSPKey_9_CW));
		emeMenuString(2, 106, 'L', StrA);
		strcpy(StrA, PMS(s_DDSKey_0));
		emeMenuString(2, 119, 'L', StrA);
		strcpy(StrA, PMS(s_DDSKey_asterix));
		emeMenuString(2, 132, 'L', StrA);
		strcpy(StrA, PMS(s_DDSKey_hash_TFT));
		emeMenuString(2, 145, 'L', StrA);
		ztDSPDisplay = 1;
	}
	
	if (zg && !zgDSPDisplay)
	{
		gedSwitchLayer(LayerRx);
		gedF8WriteString(PMS(s_DSPKey_1), RxTxMsgX+2, RxMsgY+2);
		gedF8WriteString(PMS(s_DSPKey_2), RxTxMsgX+2, RxMsgY+11);
		gedF8WriteString(PMS(s_DSPKey_3), RxTxMsgX+2, RxMsgY+20);
		if (Mode < 2) gedF8WriteString(PMS(s_DSPKey_4_SSB), RxTxMsgX+2, RxMsgY+29);
		else gedF8WriteString(PMS(s_DSPKey_4_CW), RxTxMsgX+2, RxMsgY+29);
		gedF8WriteString(PMS(s_DSPKey_5), RxTxMsgX+2, RxMsgY+38);
		if (Mode < 2) gedF8WriteString(PMS(s_DSPKey_6_SSB), RxTxMsgX+2, RxMsgY+47);
		else gedF8WriteString(PMS(s_DSPKey_6_CW), RxTxMsgX+2, RxMsgY+47);
		if (Mode < 2) gedF8WriteString(PMS(s_DSPKey_7_SSB), RxTxMsgX+2, RxMsgY+56);
		else gedF8WriteString(PMS(s_DSPKey_7_CW), RxTxMsgX+2, RxMsgY+56);
		gedF8WriteString(PMS(s_DSPKey_8), RxTxMsgX+2, RxMsgY+65);
		if (Mode < 2) gedF8WriteString(PMS(s_DSPKey_9_SSB), RxTxMsgX+2, RxMsgY+74);
		else gedF8WriteString(PMS(s_DSPKey_9_CW), RxTxMsgX+2, RxMsgY+74);
		gedF8WriteString(PMS(s_DDSKey_0), RxTxMsgX+2, RxMsgY+83);
		gedF8WriteString(PMS(s_DDSKey_asterix), RxTxMsgX+2, RxMsgY+92);
		gedF8WriteString(PMS(s_DDSKey_hash), RxTxMsgX+2, RxMsgY+101);
		gedSwitchLayer(LayerTR);
		zgDSPDisplay = 1;
	}
}


void zscShowMode() __attribute__((section(".highmem")));
void zscShowMode()
{
	if (zc)   // charlcd
	{ 	
		cdSetPos(2,37);   
		cdDisplayString(pmModeName(Mode));
	}

  if (zs) ksdF8WriteString(pmModeName(Mode),G128ModeX,56,0);

	if (zt) {ztDSPDisplay = 0; etShowMode();}

	if (zg)   // graphics
	{
   		if (DisplaySwitch != 2)
   		{
			gedSwitchLayer(LayerTR);
			strcpy(StrA, pmModeName(Mode));
			strcat(StrA, " ");
			gedF16WriteString(StrA, 7, 188);
			zgDSPDisplay = 0;
		}
	}
	zscShowDSPKeys();
}


void zscShowVfoCopy() __attribute__((section(".highmem")));
void zscShowVfoCopy()
{
  if(zc)   // charlcd
	{ 	
		if(VFO==0){strcpy(StrA,PMS(s_B_A));}else{strcpy(StrA,PMS(s_A_B));};
	  cdSetPos(2,20); 
		cdDisplayString(StrA);
 		_delay_ms(1000);
		cdSetPos(2,20);
		cdDisplayString(pmdSpaces(3));
	}
	if(zt)
	{
		etTuneBox();
		if(VFO==0){strcpy(StrA,PMS(s_VFO_Bp__VFO_A));}else{strcpy(StrA,PMS(s_VFO_Ap__VFO_B));};
	 	etTuneText(StrA);
		_delay_ms(1500);
		etDeleteTuneBox();
	}
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		if(VFO==0){strcpy(StrA,PMS(s_VFO_B___VFO_A));}else{strcpy(StrA,PMS(s_VFO_A___VFO_B));};
	    gedF16WriteString(StrA,FreqInfoX+2, FreqInfoY+2);
	 	_delay_ms(1000);
		zscClearTuneBox();
	}  
}


void zscShowShiftState() __attribute__((section(".highmem")));
void zscShowShiftState()
{
	if (ShowSwitchValueFlag) return;
	zscShowSwitchValue('S');
	ShowSwitchValueTimer = 0;
	ShowSwitchValueFlag = 2;
}


void zscClearShiftState() __attribute__((section(".highmem")));
void zscClearShiftState()
{
	if (ShowSwitchValueFlag == 2) zscClearSwitchValue();
}


void zscShowSwitchCommon(char kv) __attribute__((section(".highmem")));
void zscShowSwitchCommon(char kv)
{
	char val[3] = "  ";
	
	if (zc) {
		cdSetPos(1, 13);
		cdPutByte(1, kv);
	}
	if (zs && !DisplayingMenu) {
		ksdClearRect(G128AttenX, 56, G128ModeX-1, 63);
		val[1] = kv;
		ksdF8WriteString(val, G128AttenX, 56, 0);
	}
	if (zg) geShowState(kv);
	if (zt) etShowState(kv);
}


void zscShowSwitchValue(char kv) __attribute__((section(".highmem")));
void zscShowSwitchValue(char kv)
{
	zscShowSwitchCommon(kv);
	ShowSwitchValueTimer = 2;
	ShowSwitchValueFlag = 1;
}


void zscShowSwitchRawValue(uint16_t keycode) __attribute__((section(".highmem")));
void zscShowSwitchRawValue(uint16_t keycode)
{
	char kv;

	RawKeycode = keycode;
	kv = (char)((RawKeycode & 0x00f0) >> 4) + 0x30;
	zscShowSwitchCommon(kv);
	ShowSwitchValueTimer = 2;
	ShowSwitchValueFlag = 11;
}


void zscBlankSwitchValue() __attribute__((section(".highmem")));
void zscBlankSwitchValue()
{
	if (!ShowSwitchValueFlag) return;
	if (zc) {
		cdSetPos(1, 13);
		cdPutByte(1, ' ');
	}
	if (zs && !DisplayingMenu) {
		ksdClearRect(G128AttenX, 56, G128ModeX-1, 63);
	}
	if (zg) geBlankState();
	if (zt) etBlankState();
}


void zscClearSwitchValue() __attribute__((section(".highmem")));
void zscClearSwitchValue()
{
	if (!ShowSwitchValueFlag) return;
	ShowSwitchValueFlag = 0;
	if (zc) {
		cdSetPos(1, 13);
		cdPutByte(1, ' ');
	}
	if (zs && !DisplayingMenu) {
		ksdClearRect(G128AttenX, 56, G128ModeX-1, 63);
	}
	if (zc || zs) zscShowSwitches();
	if (zg) geClearState();
	if (zt) etClearState();
}


uint8_t zscSwitchColour(uint8_t on) __attribute__((section(".highmem")));
uint8_t zscSwitchColour(uint8_t on)
{
  uint8_t c;
	if(on==1){c=SwOnColour;}else{c=SwOffColour;};
	return c;
}


uint8_t zscSwitchDataColour(uint8_t on) __attribute__((section(".highmem")));
uint8_t zscSwitchDataColour(uint8_t on)
{
  uint8_t c;
	if(on==1){c=SwDataOnColour;}else{c=SwDataOffColour;};
	return c;
}


void zscClearSwitches(uint8_t ShowValues) __attribute__((section(".highmem")));
void zscClearSwitches(uint8_t ShowValues)
{
	uint16_t w;
	if(ShowValues==1){w=156;}else{w=100;};
	etcDeleteRect(SwitchesX,SwitchesY,SwitchesX+w,SwitchesY+7*16);
}



void zscShowSwitches() __attribute__((section(".highmem")));
void zscShowSwitches()
{
	char sv[7];
	uint8_t ShowValues = 1;
	if (DisplaySwitch == 2) ShowValues = 0;
	if ((zc) || (zs))   // charlcd or G128
	{ 	
		strcpy(sv, PMS(s_nbamvc));
		if (SWdenoise == 1)		sv[0] = 'N';
		if (SWnoiseblank == 1)	sv[1] = 'B';
		if (SWmanualnotch == 1)	sv[3] = 'M';
		if (Mode < 2) {
			if (SWautonotch == 1)	sv[2] = 'A';
			if (SWvox == 1)			sv[4] = 'V';
			if (SWspeechcomp == 1)	sv[5] = 'C';
		} else {
			if (SWqro == 1)		sv[2] = 'O';
			if (SWqsk == 1)		sv[4] = 'K';
			if (SWspot == 1)	sv[5] = 'S';
		}
 	}

	if (zc)
	{	
		cdSetPos(2, 26); 
		cdDisplayString(sv);
		if (!ShowSwitchValueFlag) {
			cdSetPos(1, 13);
			if (RFatten) cdPutByte(1, 'A'); else cdPutByte(1, ' ');
		}
	}

	if ((zs) && (DisplayingMenu == 0))
	{	
		ksdF8WriteString(sv, G128SwitchesX, 56, 0);
		if (!ShowSwitchValueFlag) {
			if (RFatten) strcpy(sv, PMS(s_att)); else strcpy(sv, pmdSpaces(3));
			ksdF8WriteString(sv, G128AttenX, 56, 0);
		}
	}
	
	if (zt) etShowSwitches();

	if (zg)   // graphics switches (but not filter width switch here)
	{
		uint16_t X = EA320SwitchesX;
		uint8_t  Y = EA320SwitchesY;

		gedSwitchLayer(LayerTR);
		Brush.Color = 0;
		if(ShowValues==1){gedFillRect(X+50,Y,X+105,Y+EA320SwitchSpacing);};
		geCheckBox(X,Y,SWdenoise);
		strcpy(StrA,PMS(s_Denoiser));
		if(ShowValues==1)
		{
			strcat(StrA,PMS(s_spacebracket));
			strcat(StrA,dspParamValString(11,0));
			strcat(StrA,PMS(s_RightSquareBracket));
		}
		gedF8WriteString(StrA,X+10,Y);
		Y += EA320SwitchSpacing;
		Brush.Color = 0;
		if(ShowValues==1){gedFillRect(X+50,Y,X+105,Y+EA320SwitchSpacing);};
		geCheckBox(X,Y,SWnoiseblank);
		strcpy(StrA,PMS(s_Noise_blank));
		if(ShowValues==1)
		{
			strcat(StrA,PMS(s_spacebracket));
			strcat(StrA,dspParamValString(32,0));
			strcat(StrA,PMS(s_dB_));
		}
		gedF8WriteString(StrA,X+10,Y);
		Y += EA320SwitchSpacing;
		Brush.Color = 0;
		if(ShowValues==1){gedFillRect(X,Y,X+105,Y+EA320SwitchSpacing);};
		if (Mode < 2) {
			geCheckBox(X, Y, SWautonotch);
			gedF8WriteString(PMS(s_Auto_notch),X+10,Y);
		} else {
			geCheckBox(X, Y, SWqro);
			gedF8WriteString(PMS(s_QRO),X+10,Y);
		}
		Y += EA320SwitchSpacing;
		Brush.Color = 0;
		if(ShowValues==1){gedFillRect(X+50,Y,X+105,Y+EA320SwitchSpacing);};
		geCheckBox(X,Y,SWmanualnotch);
		strcpy(StrA,PMS(s_Man_notch));
		if(ShowValues==1)
		{
			strcat(StrA,PMS(s_spacebracket));
			strcat(StrA,dspParamValString(51,0));
			strcat(StrA,PMS(s_kHzbr));
		}
		gedF8WriteString(StrA,X+10,Y);
		Y += EA320SwitchSpacing;
		Brush.Color = 0;
		if(ShowValues==1){gedFillRect(X,Y,X+105,Y+EA320SwitchSpacing);};
		if (Mode < 2) {
			geCheckBox(X, Y, SWvox);
			gedF8WriteString(PMS(s_Vox),X+10,Y);
		} else {
			geCheckBox(X, Y, SWqsk);
			strcpy(StrA,PMS(s_QSK));
			if (ShowValues == 1)
			{
				strcat(StrA, PMS(s_spacebracket));
				strcat(StrA, dspParamValString(43, 0));
				strcat(StrA, PMS(s_RightSquareBracket));
			}
			gedF8WriteString(StrA, X+10, Y);
		}
		Y += EA320SwitchSpacing;
		Brush.Color = 0;
		if(ShowValues==1){gedFillRect(X+50,Y,X+105,Y+EA320SwitchSpacing);};
		if (Mode < 2) {
			geCheckBox(X, Y, SWspeechcomp);
			strcpy(StrA, PMS(s_RF_clip));
			if (ShowValues == 1) {
				strcat(StrA, PMS(s_spacebracket));
				strcat(StrA, dspParamValString(91, 0));
			}
		} else {
			geCheckBox(X, Y, SWspot);
			strcpy(StrA, PMS(s_CW_spot));
			if (ShowValues == 1) {
				strcat(StrA, PMS(s_spacebracket));
				strcat(StrA, dspParamValString(93, 0));
			}
		}
		if (ShowValues == 1) strcat(StrA,PMS(s_dB_));
		gedF8WriteString(StrA, X+10, Y);
		if (DisplaySwitch != 2) {
			Y += EA320SwitchSpacing;
			Brush.Color = 0;
			if (ShowValues == 1) gedFillRect(X+50, Y, X+105, Y+EA320SwitchSpacing);
			geCheckBox(X, Y, RFatten);
			gedF8WriteString(PMS(s_RF_attenuator), X+10, Y);
		}
		Brush.Color = 1;
	}
}


void zscShowFilter() __attribute__((section(".highmem")));
void zscShowFilter()
{
	char sv[4];
	uint8_t d, starno, CentreParam;

	if (zc || zs) {   // charlcd or G128
		if (Transmit == 1) {
			strcpy(sv, pmdSpaces(3));
		} else {
			if (Mode < 2) {  // SSB
				if (SWfilter == 1) strcpy(sv, PMS(s_NNN)); else strcpy(sv,PMS(s_WWW));
			} else {   // CW
				if (SWfilter == 1) strcpy(sv, PMS(s_DEP)); else strcpy(sv,PMS(s_CTX));
			}
 		}
	}
	if (zs) {
		ksdClearRect(G128FilterX, 56, 127, 63);
		ksdF8WriteString(sv, G128FilterX, 56, 0);
	}
	if (zc) {
		cdSetPos(2, 33);
		cdDisplayString(sv);
	}
	if (zg || zt || zs) {
		gedSwitchLayer(LayerTR);
		if (Mode < 2) 
		{   // SSB Modes
			if (SWfilter == 1) starno = 62; else starno = 63;		// change display mode to show and hear param
			strcpy(StrA, dspParamValString(starno, 1)); // this routine also sets ParamVal
			strcat(StrA, PMS(s_kHz));
			CentreParam = dspGetParamValue(65);
			if (zg) {if (DisplaySwitch != 2) geFilterSSB(StrA, ParamVal, CentreParam, SWfilter);}
			if (zt) etFilterSSB(StrA, ParamVal, CentreParam, SWfilter);
			if (zs) ksFilterSSB(StrA, ParamVal, CentreParam, SWfilter);
		}
		else 
		{   //   CW Modes
			SWfilter = 1;  // /IJS Star6a9 added
			if (SWfilter == 1) starno = 61; else starno = 64;		// change display mode to show and hear param
			d = dspGetParamValue(61);    // depth 0 - 10
			CentreParam = dspGetParamValue(66);
			strcpy(StrA, dspParamValString(64, 1));   // sets variable: ParamVal to raw parameter
			strcat(StrA, PMS(s_kHz));
			if (zg) {if (DisplaySwitch != 2) geFilterCW(StrA, ParamVal, CentreParam, d, SWfilter);}
			if (zt) etFilterCW(StrA, ParamVal, CentreParam, d, SWfilter);
			if (zs) ksFilterCW(StrA, ParamVal, CentreParam, d, SWfilter);
		}
	}
}


void zscShowStartUpscreen() __attribute__((section(".highmem")));
void zscShowStartUpscreen()
{
	if (zc)   // charlcd
	{ 	
		memcpy(StrA,HardwareSettings.hsCallsign,11);
		StrA[10] = 0;  // limit length;
		memcpy(StrB,HardwareSettings.hsWelcomeText1,29);
		StrB[18] = 0;  // limit length;
		cdClear();
		cdHome();   
 		cdSetPos(1,0);
		cdDisplayString(StrA);
 		cdSetPos(2,0);
		cdDisplayString(StrB);		
		cdSetPos(1,20);   
		strcpy(StrA,PMS(s_TrxAVR_PicaStar_));
		strcat(StrA,TrxAVR_version);
		cdDisplayString(StrA);
	 	cdSetPos(2,20);   
		cdDisplayString(PMS(s_Loading_DSP));
	}
	if (zt)
	{
    if (etcDeleteDisplay() == 0)   
		{zt = 0;}    // prevent locking up if TftA disconnected or I2C address mismatch
		else
		{
			etcTextColour(10,0);
			etcFont(11);
			etcString(240,10,'C',(char*)HardwareSettings.hsCallsign);
			etcTextColour(4,0);
			etcFont(12);
			etcString(240,35,'C',(char*)HardwareSettings.hsWelcomeText1);
			etcString(240,55,'C',(char*)HardwareSettings.hsWelcomeText2);
			etcTextColour(7,0);
			strcpy(StrA,PMS(s_TrxAVR_PicaStar_));
			etcFont(11);
			etcString(240,130,'C',StrA);
    	etcTextColour(10,0);
			strcpy(StrA,PMS(s_version_));
			strcat(StrA,TrxAVR_version);
			etcFont(12);
			etcString(240,160,'C',StrA);
    	strcpy(StrA,PMS(s_Loading_DSP));
			etcTextColour(5,0);
			etcString(220,190,'R',StrA);
			etcDisplayColour(10, 0);  // for loading bar
		etcBorderColour(2, 1, 1);  // for loading bar border //HFR
			etcBorderBox(225, 194, 353, 204);  // loading bar border 
	  }
	}
		
	if (zg)   // graphics
	{
		uint16_t w;
		gedSwitchLayer(1);
		gedCls(0);
		w = gedF16StringWidth((char*)HardwareSettings.hsCallsign);
		gedF16WriteString((char*)HardwareSettings.hsCallsign,(320 - w)/2,10);
		w = gedF8StringWidth((char*)HardwareSettings.hsWelcomeText1);
		gedF8WriteString((char*)HardwareSettings.hsWelcomeText1,(320 - w)/2,35);
		w = gedF8StringWidth((char*)HardwareSettings.hsWelcomeText2);
		gedF8WriteString((char*)HardwareSettings.hsWelcomeText2,(320 - w)/2,48);
		w = gedF16StringWidth(PMS(s_TrxAVR_PicaStar_));
		gedF16WriteString(PMS(s_TrxAVR_PicaStar_),(320 - w)/2,100);
		strcpy(StrA,PMS(s_version_));
		strcat(StrA,TrxAVR_version);
		w = gedF8StringWidth(StrA);
		gedF8WriteString(StrA,(320 - w)/2,120);
		gedF16WriteString(PMS(s_Loading_DSP),80,150);
		gedHorizLine(162, 242, 154, 1);
		gedHorizLine(162, 242, 160, 1);
		gedVertLine(154, 160, 162, 1);
		gedVertLine(154, 160, 242, 1);
	}  
		
	if (zs)   // G128 graphics
	{
		//uint16_t w;
		
		ksdClearScreen();
		ksdF16WriteString((char*)HardwareSettings.hsCallsign,0,0);
		ksdF8WriteString((char*)HardwareSettings.hsWelcomeText1,0,16,0);
		ksdF8WriteString((char*)HardwareSettings.hsWelcomeText2,0,25,0);
		ksdF8WriteString(PMS(s_TrxAVR_PicaStar_),0,35,0);
		strcpy(StrA,PMS(s_version_));
		strcat(StrA,TrxAVR_version);
		ksdF8WriteString(StrA,0,44,0);
		ksdF8WriteString(PMS(s_Loading_DSP),0,55,0);
		ksdLine(61, 55, 125, 55);
		ksdLine(61, 61, 125, 61);
		ksdLine(61, 55, 61, 61);
		ksdLine(125,55, 125,61);
	}  
}



void zscDisplayIP3NF() __attribute__((section(".highmem")));
void zscDisplayIP3NF()
{
	if((zc)||(zs))
	{ 	
	  if(IP3==0)
	{strcpy(StrA,PMS(s_NF));}
		else
		{strcpy(StrA,PMS(s_IP));};
	}

  if(zs)
	{
		 ksdClearRect(G128IP3X,56,G128SwitchesX-2,63);
		 ksdF8WriteString(StrA,G128IP3X,56,0);
	}

	if ((zc) && (DisplayingMenu == 0))   // charlcd
	{	
		cdSetPos(2,18);
		cdDisplayString(StrA);
	}

	if(zt){etShowIP3();};

	if (zg)   // graphics
	{
		if (DisplaySwitch != 2)
		{
			gedSwitchLayer(LayerTR);
			if (IP3 == 0) strcpy(StrA,PMS(s_NF_));
			else strcpy(StrA,PMS(s_IP3));
			gedF16WriteString(StrA,5,166);
		}
	}  
}


void zscDisplayParamColour(uint8_t col) __attribute__((section(".highmem")));
void zscDisplayParamColour(uint8_t col)
{
	if (zs || zc) {
		switch (col) {
			case 1: strcpy(StrA,PMS(s_grn)); break;
			case 2: strcpy(StrA,PMS(s_yel)); break;
			case 3: strcpy(StrA,PMS(s_red)); break;
		}
	}

	if ((zc) && (DisplayingMenu == 0)) {   // charlcd
		cdSetPos(2, 14);
		cdDisplayString(StrA);
	}

	if (zs && (DisplayingMenu == 0)) {
		 ksdClearRect(G128ColourX, 56, G128IP3X-1, 63);
		 ksdF8WriteString(StrA, G128ColourX, 56, 0);
	}

	if (zt) etShowParamColour(col);

	if (zg) {   // graphics
		if (DisplaySwitch != 2) {
			gedSwitchLayer(LayerTR);
			switch (col) {
				case 1: strcpy(StrA,PMS(s_Green_)); break;
		  		case 2: strcpy(StrA,PMS(s_Yellow)); break;
		  		case 3: strcpy(StrA,PMS(s_Red___)); break;
			}
			gedF16WriteString(StrA, 5, 145);
		}
	}
}


void zscShowWobbActive() __attribute__((section(".highmem")));
void zscShowWobbActive()
{
	if (zc) {  // charlcd
		cdSetPos(1, 20);
		cdDisplayString(pmdSpaces(20));  // clear normal VFO info
		cdSetPos(1, 20);
		cdDisplayString(PMS(s_wobb_));
	}
}


void zscShowWobbulatorRate() __attribute__((section(".highmem")));
void zscShowWobbulatorRate()
{
	uint16_t df;
	char dec;

	if ((zc) || (zs)) {   // charlcd
		dec = 'k';
		if (SweepStep == 20)  strcpy(StrA, PMS(s_0p8kps));
		else {
			df = SweepStep / 25;
			if (df >= 1000) {
				df /= 1000;
				dec = 'M';
			}
			ltoa(df, StrA, 10);
			if (dec == 'k') strcat(StrA, PMS(s_kps)); else strcat(StrA, PMS(s_Mps));
 		}
	}
	if (zc) {
		cdSetPos(1, 25);
		cdDisplayString(pmdSpaces(6));
		cdSetPos(1, 25);
		cdDisplayString(StrA);
	}

	if (zs) ksWriteFreqInfoData(StrA);

	if ((zt) || (zg)) {
		dec = 'k';
		if (SweepStep == 20) strcpy(StrA, PMS(s_0p8kHzps));
		else {
			df = SweepStep / 25;
			if (df >= 1000) {
				df /= 1000;
				dec = 'M';
			}
			ltoa(df, StrA, 10);
			if (dec == 'k') strcat(StrA, PMS(s_kHzps)); else strcat(StrA, PMS(s_MHzps));
		}
	}
	if (zt) etTuneTextLower(StrA);

	if (zg) {   // graphics
		gedSwitchLayer(LayerTR);
		geClearParamBoxLower();
		gedF8WriteString(StrA, FreqInfoX, FreqInfoY+12);
	}
}


void zscShowRateTuningRate() __attribute__((section(".highmem")));
void zscShowRateTuningRate()
{
	if ((zc) || (zs)) {  // charlcd
		StrA[0] = 0; // null string
		if (RateTuningIndex == 0) strcpy(StrA, PMS(s__rate_));
		else {
			if (RateTuningIndex > 0) strcpy(StrA, "+");
			else strcpy(StrA, "-");
			if (SweepStep == 10) strcpy(StrB, PMS(s_p4kps));
			else {
				if (SweepStep == 20) strcpy(StrB, PMS(s_p8kps));
				else {
					ltoa(SweepStep/25, StrB, 10);
					strcat(StrB, PMS(s_kps));
				}
			}
			strcat(StrA, StrB);
		}
		if (zc) {
			cdSetPos(2, 20);
			cdDisplayString(gbTrailingSpaces(StrA, 6)); 
		}
		if (zs) ksWriteFreqInfoData(StrA);
	}
	if ((zt) || (zg)) {
		StrA[0] = 0;
		if (RateTuningIndex > 0) strcpy(StrA, "+");
		else strcpy(StrA, "-");
		if (SweepStep == 10) strcat(StrA, PMS(s_0p4kHzps));
		else {
			if (SweepStep == 20) strcat(StrA, PMS(s_0p8kHzps));
			else {
				ltoa(SweepStep/25, StrB, 10);
				strcat(StrA, StrB);
				strcat(StrA, PMS(s_kHzps));
			}
		}
		if (zt) etTuneTextLower(StrA);
		if (zg) {  // graphics
			gedSwitchLayer(LayerTR);
			geClearParamBoxLower();
			gedF8WriteString(StrA, FreqInfoX, FreqInfoY+12);
		}
	}
}


void zscShowScanDelay() __attribute__((section(".highmem")));
void zscShowScanDelay()
{
	ltoa(ScanDelay,StrB,10);
	if ((zc)||(zs))   // charlcd or 128x64
	{ 	
  	strcpy(StrA,PMS(s__te));
		strcat(StrA,StrB);
		strcat(StrA,"s");
	}	
	if (zc)
	{
		cdSetPos(2,20);
		cdDisplayString(gbTrailingSpaces(StrA,6)); 
	}
	
	if (zs) ksWriteFreqInfoData(StrA);
	if (zt)
	{
		strcpy(StrA,PMS(s_delay_));
		strcat(StrA,StrB);
		strcat(StrA,PMS(s_s));
		etTuneTextLower(StrA);		
	}
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		strcpy(StrA,PMS(s_Scan_delay___));
		strcat(StrA,StrB);
		strcat(StrA,PMS(s_s__));
		geClearParamBoxLower();
		gedF8WriteString(StrA,FreqInfoX,FreqInfoY+12);
	}  
}


void zscShowABscan() __attribute__((section(".highmem")));
void zscShowABscan()
{
	if (zt) etShowABscan();
	if (zs) ksShowABscan();
	if (zg)   // graphics
	{
    gedSwitchLayer(LayerTR);
		geClearParamBox();
		gedF8WriteString(PMS(s_Scan_VFOs_A_and_B),FreqInfoX,FreqInfoY);
	}
}


void	zscShowMemStackScan() __attribute__((section(".highmem")));
void	zscShowMemStackScan()
{
	if (zt) etShowMemStackScan();
	if (zs) ksShowMemStackScan();
	if (zg)   // graphics
	{
    gedSwitchLayer(LayerTR);
		geClearParamBox();
		gedF8WriteString(PMS(s_Scan_memory_stack_),FreqInfoX,FreqInfoY);
	}

}


void	zscShowRateTuning() __attribute__((section(".highmem")));
void	zscShowRateTuning()
{
	if (zt) etShowRateTuningMode();
	if (zs) ksShowRateTuningMode();
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
    geClearParamBox();
		gedF8WriteString(PMS(s_Rate_tuning_mode),FreqInfoX,FreqInfoY);
	}
}


void	zscShowWobbulatorMode() __attribute__((section(".highmem")));
void	zscShowWobbulatorMode()
{
	if (zt) etShowWobbulatorMode();
	if (zs) ksShowWobbulatorMode();

	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
    geClearParamBox();
		gedF8WriteString(PMS(s_Wobbulator_mode),FreqInfoX,FreqInfoY);
	}
}


void	zscShowVfoStackMode() __attribute__((section(".highmem")));
void	zscShowVfoStackMode()
{
	if (zt) etShowVfoStackMode();
	if (zs) ksShowVfoStackMode();
	if (zg)   // graphics
	{
		gedSwitchLayer(LayerTR);
		geClearParamBox();
    gedF8WriteString(PMS(s_VFO_Stack_mode),FreqInfoX,FreqInfoY);
	}
}


void zscDeleteMsgFrame(uint8_t DrawRTC) __attribute__((section(".highmem")));
void zscDeleteMsgFrame(uint8_t DrawRTC)
{
	if (zt) emeDeleteInfo();;
	if (zg)   // graphics
	{
    	geDeleteMsgFrame();
			if(DrawRTC) geDrawDateTime();
	}
}




void zscClearMsgFrame() __attribute__((section(".highmem")));
void zscClearMsgFrame()
{
	if (zg)   // graphics
	{
    	geClearMsgFrame();
	}
}



void zscDrawMsgFrame() __attribute__((section(".highmem")));
void zscDrawMsgFrame()
{
	if (zg)   // graphics
	{
		geDrawMsgFrame();
	}
}
