/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taZ_Smeter.c  Display switching module 
 Processes display output from taSmeter.c
*/


#include "taGlobal.h"
#include "taConfig.h"
#include <math.h>
#include "taDDS.h"
#include "taDebug.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taCharLCD.h"
#include "taProgmem.h"
#include "taFT245R.h"
#include "taGraphicsControl.h"
#include "taIntEeprom.h"
#include "taZ_Smeter.h"
#include "taSmeter.h"
#include "taGraphicsDriverEA320.h"
#include "taEATFT.h"
#include "taKS0108.h"

#define EA320SmeterX 109
#define EA320SmeterY 71

static const char SmeterLabels[14] PROGMEM = {'1', ' ', '3', ' ', '5', ' ', '7', ' ', '9', 3, 4, 5, 6, 0};

static uint16_t BarX;
static uint8_t  BarTop;
static uint8_t  BarBottom;
static uint8_t  BarWidth;

void zsmSmeterBarSet(uint8_t w);


void zsmSmeterBarSet(uint8_t w)
{ 
	uint8_t pw = BarWidth;
	BarWidth = w; 
	if (w != pw)
	{
		if (w > pw)
		{
			Brush.Color = 1;
			gedFillRect(BarX + pw + 1, BarTop, BarX + w, BarBottom);
		}
		else
		{
			Brush.Color = 0;
			gedFillRect(BarX + w + 1, BarTop, BarX + pw, BarBottom);
		}
	}
	Brush.Color = 1;
}
 


void zsmSmeterInitialise()
{
	if (zc)   // charlcd
	{ 	
		cdSetPos(1, 0);    // start of line 1
		cdDisplayString("             ");
  		cdSetPos(2, 0);    // start of line 2
		strcpy_P(StrA, (PGM_P)&SmeterLabels[0]);
		cdDisplayString(StrA);
	}
	if (zt)
	{
		etSmeterInit();
	}
	if (zs) ksSmeterInit();
	if (zg)   // graphics
	{
   	gedSwitchLayer(2); // Rx layer
		uint16_t x, yn;
		uint8_t y, i;
		Brush.Color = 0;
		BarX = EA320SmeterX + 15;
		BarTop = EA320SmeterY + 4;
		BarBottom = BarTop + 4;
		BarWidth = 0;
		gedFillRect(BarX, BarTop, BarX+144, BarBottom); // clear bar of previous Smeter
		Brush.Color = 1;
		gedHorizLine(EA320SmeterX, EA320SmeterX + 166, EA320SmeterY, 2);
		gedHorizLine(EA320SmeterX, EA320SmeterX + 166, EA320SmeterY + 25, 2);
		gedVertLine(EA320SmeterY, EA320SmeterY + 26, EA320SmeterX, 2);
		gedVertLine(EA320SmeterY, EA320SmeterY + 26, EA320SmeterX + 166, 2);
		gedF16WriteString("S", EA320SmeterX+4, EA320SmeterY + 8);
		y = EA320SmeterY + 2;
		yn = EA320SmeterY + 16;
		for (i = 0; i <= 9; i++)
		{
			x = EA320SmeterX + 15 + i * 9;
			gedVertLine(y + 10 - 2 * (i % 2), y + 11, x, 1);
			x -= 2;
			if ((i % 2) == 1) gedF8WriteChar(i + 0x30, &x, &yn);
		}
		for (i = 1; i <= 6; i++)
		{
			x = EA320SmeterX + 15 + 81 + i * 10;
			gedVertLine(y + 10 - 2 * ((i + 1) %2 ), y + 11, x, 1);
			switch(i)
			{
			  case 2: gedF8WriteString("20", x-5, yn); break;
			  case 4: gedF8WriteString("40", x-5, yn); break;
			  case 6: gedF8WriteString("60", x-5, yn); break;
			}
		}
		gedSwitchLayer(1); // back to TRX layer
	}
}



void zsmSmeterShowBars()
{
  uint16_t ds = 0;
	uint16_t dplus = 0;
	if (SmeterdB == SmeterDigPrev) {return;}
	uint16_t db = SmeterdB;
	if (db > 117) {db = 117;}  // max = S9 + 63dB
 	SmeterDigPrev = db;
	if ((zc) && (DisplayingMenu == 0))   // charlcd
	{ 	
		uint16_t n = db;
		char sy[16];
		uint8_t bars;
		uint8_t nmod;
		uint8_t i;
		strcpy(sy, pmdSpaces(13));
 	 	nmod = n % 6;
		bars = n / 6;
		if (bars > 9) {bars = 9; nmod=0;}
		if (bars > 0) {for (i = 0; i < bars; i++) {sy[i] = 1;} }	// character code 1 = full bar
		if ( (bars < 9) && (nmod >= 3) ) {sy[bars] = 2;}			// character code 2 = left half bar
		if (n >= 59)   // S9 + 5dB
		{	
  			n -= 54;
  			bars = n / 10;
			nmod = n % 10;
  			if (bars > 4) {bars = 4; nmod=0;}
  			if (bars > 0) {for (i = 0; i < bars; i++) {sy[9 + i] = 1;} }	// character code 1 = full bar
	 		if ( (bars < 4) && (nmod >= 5) ) {sy[9 + bars] = 2;}			// character code 2 = left half bar
  		}
		cdSetPos(1, 0);   
		cdDisplayString(sy);
	}
	if ((zt)||(zs)||(zg))
	{
    ds = db;
		dplus = 0;
		if (db > 54) {ds = 54; dplus = db - 54;}
	}
	if (zt) etSmeterBarSet((ds * 240) / 120 + (dplus * 240) / 200); // pixels
	if (zs) ksMeterBarSet((ds * 100) / 120 + (dplus * 120) / 200);  // pixels
	if (zg)   // graphics
	{
		gedSwitchLayer(2); // Rx layer
		zsmSmeterBarSet((ds * 150) / 100 + dplus); // pixels
		gedSwitchLayer(1); // back to Trx Layer 
	}
}  
