/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taZ_SWR.c  Display switching module 
 Processes display output from taSWR.c
*/


#include "taGlobal.h"
#include "taConfig.h"
#include <math.h>
#include "taDDS.h"
#include "taDebug.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taCharLCD.h"
#include "taProgmem.h"
#include "taFT245R.h"
#include "taGraphicsControl.h"
#include "taIntEeprom.h"
#include "taZ_SWR.h"
#include "taSWR.h"
#include "taSWR.h"
#include "taGraphicsDriverEA320.h"
#include "taEATFT.h"
#include "taKS0108.h"


#define EA320SWRmeterX 108
#define EA320SWRmeterY 71


static const uint16_t pmdDivEA320240[5] PROGMEM = {62,125,250,625,1250};				
static const uint16_t pmdDivEAeDIPTFT43[5] PROGMEM = {50,100,200,500,1000};				
static const uint16_t pmdDivKS0108[5] PROGMEM = {100,200,400,1000,2000};				
static const uint16_t pmdPowerFsdDeciwatts[5] PROGMEM = {75,150,300,750,1500};  // ijs 22.07.2010

static const char pmdPowerLabels[5][4][4]PROGMEM = {
		{"0", "2.5", "5.0", "7.5"},
		{"0", "5",   "10",  "15"},
		{"0", "10",  "20",  "30"},
		{"0", "25",  "50",  "75"},
		{"0", "50",  "100", "150"},
};

static uint16_t SwrBarX;
static uint8_t BarFwdWidth;
static uint8_t BarRefWidth;
static uint8_t BarSwrWidth;
static uint8_t BarFwdTop;
static uint8_t BarRefTop;
static uint8_t BarSwrTop;
static uint8_t FwdRange;
static uint8_t RefRange;
static uint16_t FwdDivEA320240;
static uint16_t RefDivEA320240;
static uint16_t FwdDivKS0108;
static uint16_t RefDivKS0108;
static uint16_t FwdDivEAeDIPTFT43;
static uint16_t RefDivEAeDIPTFT43;
static char PowerLabel[5];


void zswSetFsdDeciwatts()   // added IJS 22.07.2010
{
	FwdFsdDeciwatts = pgm_read_word(&pmdPowerFsdDeciwatts[FwdRange]);
	RefFsdDeciwatts = pgm_read_word(&pmdPowerFsdDeciwatts[RefRange]);
}


void zswSWRmeterBarSet(uint8_t w, uint8_t BarY, uint8_t* pBarWidth);
uint8_t zswSetPowerRange(uint16_t fscal);


char* zswPowerLabel(char fr, uint8_t n)
{
  uint8_t Range;
	if(fr=='F'){Range=FwdRange;}else{Range=RefRange;};
	strcpy_P(PowerLabel,(PGM_P)&pmdPowerLabels[Range][n]);
	return PowerLabel;
}


void zswDisplaySwrText(char* s)
{
	if (zc)   // charlcd
	{ 	
		cdSetPos(2,0);   
		cdDisplayString(s);
	}
	if (zg)   // graphics
	{
	} 
}


void zswDisplayCharLcdSwrBars(uint8_t bars)
{
  if(zc)   // charlcd
	{ 	
	  if(bars>26){bars=26;};
		char sy[16];
 	  uint16_t fs; 
		uint8_t b;
		uint8_t bmod;
		uint8_t i;  
		strcpy(sy,pmdSpaces(13));
		if((SWRmode=='F')||(SWRmode=='R'))
		{
			if(SWRmode=='F'){fs = CalDataStruct.cdsFwdFsWatts;};
			if(SWRmode=='R'){fs = CalDataStruct.cdsRefFsWatts;};
		  if(fs==130){sy[12]=8; sy[4]='"'; sy[9]='"';};    // only have scale labels
		  if(fs==25) {sy[12]=7; sy[4]='"'; sy[9]='"';};    // for full scale = 25w and 130w
		};
		if(SWRmode=='S'){sy[3] = '2'; sy[7]='3'; sy[11]='4';};
 		bmod = bars % 2;
		b = bars / 2;
		if(b>0){for(i=0;i<b;i++){sy[i] = 1;};}; // character code = full bar
		if((b<13)&&(bmod==1)){sy[b] = 2;};      // character code 2 = left half bar
		cdSetPos(1,0);   
		cdDisplayString(sy);
	}
}  


// this routine oprates in deciwatts
uint8_t zswSetPowerRange(uint16_t fscaldw)
{
  uint8_t pr = 4;      
	if(fscaldw<=750){pr=3;};
	if(fscaldw<=300){pr=2;};
	if(fscaldw<=150){pr=1;};
	if(fscaldw<=75){pr=0;};
  return pr;
}


// Initialising SWR graphics

// note that the EA320x240 disply has separate transmit and receive layers
// so the transmit framework can be drawn at startup and will not show until swithced to transmit
// The Colour TFT Init doesnot not draw the framework (occurs on switch to transmit)

void zswGraphicsSWRmeterInitialise(uint8_t doswr)
{
	uint8_t yb;
	FwdRange = zswSetPowerRange(10*CalDataStruct.cdsFwdFsWatts);
	RefRange = zswSetPowerRange(10*CalDataStruct.cdsRefFsWatts);
	FwdDivEA320240=pgm_read_word(&pmdDivEA320240[FwdRange]);
	RefDivEA320240=pgm_read_word(&pmdDivEA320240[RefRange]);
	FwdDivEAeDIPTFT43=pgm_read_word(&pmdDivEAeDIPTFT43[FwdRange]);
	RefDivEAeDIPTFT43=pgm_read_word(&pmdDivEAeDIPTFT43[RefRange]);
	FwdDivKS0108=pgm_read_word(&pmdDivKS0108[FwdRange]);
	RefDivKS0108=pgm_read_word(&pmdDivKS0108[RefRange]);

//	if(zt)   // no action here - because we dont draw colout TFT until transmitting
//	{        //   the EA320240 is in layers adn so has seprate transmit and recieve layers
//	}	

	if (zg)   // graphics
	{
		if (doswr == 1) yb = 75; else yb = 50;
		////   Calibration: Fwd and Refl  - full scales 7.5,15,30,75 and 150w allowed 
		///////////
		gedSwitchLayer(3); // Tx layer
		uint16_t x,yn;
		uint8_t y,i,e;
		Brush.Color = 0;
		gedFillRect(EA320SWRmeterX, EA320SWRmeterY,EA320SWRmeterX+167, EA320SWRmeterY+yb+2); 
		SwrBarX = EA320SWRmeterX + 34;
		BarFwdTop = EA320SWRmeterY + 6;
		BarRefTop = EA320SWRmeterY + 30;
		BarSwrTop = EA320SWRmeterY + 54;
		BarFwdWidth = 0;
		BarRefWidth = 0;
		BarSwrWidth = 0;
		gedFillRect(SwrBarX,BarFwdTop,SwrBarX+144,BarFwdTop+4); // clear bar of previous Smeter
		gedFillRect(SwrBarX,BarRefTop,SwrBarX+144,BarRefTop+4); // clear bar of previous Smeter
		if (doswr) gedFillRect(SwrBarX,BarSwrTop,SwrBarX+144,BarSwrTop+4); // clear bar of previous Smeter
		Brush.Color = 1;
		gedHorizLine(EA320SWRmeterX, EA320SWRmeterX+166, EA320SWRmeterY,2);
		gedHorizLine(EA320SWRmeterX, EA320SWRmeterX+166, EA320SWRmeterY+yb,2);
		gedVertLine(EA320SWRmeterY, EA320SWRmeterY+yb+1,EA320SWRmeterX,2);
		gedVertLine(EA320SWRmeterY, EA320SWRmeterY+yb+1,EA320SWRmeterX+166,2);
		///
		y = BarFwdTop-2;
		yn = BarFwdTop+11;		
		for (i = 0; i <= 15; i++)
		{
			x = EA320SWRmeterX + 35 + i*8;
			if ((i%5) == 0) e = 2; else e = 0;
			gedVertLine(y+10-e,y+11,x,1);
			if ((i%5) == 0)
			{
				strcpy(StrA,zswPowerLabel('F',i/5));
				gedF8CentreWriteString(StrA,x-15,yn,30); //box of +/-16 pix to centre in
			}
		}
		gedF8WriteString(PMS(s_Fwd),EA320SWRmeterX+6,BarFwdTop+4);
		///
		y = BarRefTop-2;
		yn = BarRefTop+11;
		for (i = 0; i <= 15; i++)
		{
			x = EA320SWRmeterX + 35 + i*8;
			if ((i%5) == 0) e = 2; else e = 0;
			gedVertLine(y+10-e,y+11,x,1);
			if ((i%5) == 0)
			{
				strcpy(StrA,zswPowerLabel('R',i/5));
				gedF8CentreWriteString(StrA,x-15,yn,30); //box of +/-16 pix to centre in
			}
		}
		gedF8WriteString(PMS(s_Ref),EA320SWRmeterX+6,BarRefTop+4);
		///
		if (doswr == 1)
		{
			y = BarSwrTop-2;
			yn = BarSwrTop+11;
			for (i = 0; i <= 15; i++)
			{
				x = EA320SWRmeterX + 35 + i*8;
				if ((i%5) == 0) e = 2; else e = 0;
				gedVertLine(y+10-e,y+11,x,1);
				x-=2;
				if ((i%5) == 0)gedF8WriteChar((i/5)+0x31, &x, &yn);
			}
	     		gedF8WriteString(PMS(s_SWR),EA320SWRmeterX+6,BarSwrTop+4);
		}
		////////
		gedSwitchLayer(1); // back to TRX layer
	}
}


void zswSWRmeterBarSet(uint8_t w, uint8_t BarY, uint8_t* pBarWidth)
{ 
  if(w>124){w=124;};
	uint8_t pw = *pBarWidth;
	*pBarWidth = w; 
	if(w!=pw)
	{
	  if(w>pw)
		{
			Brush.Color = 1;
			gedFillRect(SwrBarX+pw+1,BarY, SwrBarX+w,BarY+4);
    }
		else
		{
		  Brush.Color = 0;
			gedFillRect(SwrBarX+w+1,BarY,SwrBarX+pw,BarY+4);
    }
  }
	Brush.Color = 1;
}

	  	
void zswDisplayGraphicsSwr(uint8_t doswr)
{
	uint16_t swrpix;
	if(zt)
	{
			swrpix = (SWRx100-100)/2;
			if(swrpix<2){swrpix=2;}; // need to see something for swr =1
			etSWRmeterBarSet((FwdCentiWatts*10)/FwdDivEAeDIPTFT43,'F'); 
			etSWRmeterBarSet((RefCentiWatts*10)/RefDivEAeDIPTFT43,'R'); 	
			if(doswr==1){etSWRmeterBarSet(swrpix,'S');};
	}

	if (zg)   // graphics
	{
		gedSwitchLayer(3); // Tx layer
		swrpix = (SWRx100-100)/4;
		if(swrpix<2){swrpix=2;}; // need to see something for swr =1
		zswSWRmeterBarSet((FwdCentiWatts*10)/FwdDivEA320240,BarFwdTop,&BarFwdWidth); 
		zswSWRmeterBarSet((RefCentiWatts*10)/RefDivEA320240,BarRefTop,&BarRefWidth); 	
		if(doswr==1){zswSWRmeterBarSet(swrpix,BarSwrTop,&BarSwrWidth);};
		gedSwitchLayer(1); // back to Trx Layer 
	}
	if (zs)   // 128x64graphics
	{
		swrpix = (SWRx100-100)/4;
		if(swrpix<2){swrpix=2;}; // need to see something for swr =1
		switch(SWRmode)
		{
			case 'F': ksMeterBarSet((FwdCentiWatts*10)/FwdDivKS0108); break; 
			case 'R': ksMeterBarSet((RefCentiWatts*10)/RefDivKS0108); break;	
			case 'S': ksMeterBarSet(swrpix); break;
		} 
	}
}
