/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taZ_DDS.c  Display switching module for taDDS.c

*/


#include "taGlobal.h"
#include "taConfig.h"
#include <math.h>
#include "taDDS.h"
#include "taDebug.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taCharLCD.h"
#include "taProgmem.h"
#include "taFT245R.h"
#include "taGraphicsControl.h"
#include "taIntEeprom.h"
#include "taZ_DDS.h"
#include "taGraphicsDriverEA320.h"
#include "taEATFT.h"
#include "taEATFTcommands.h"
#include "taKS0108.h"
#include "taKS0108Driver.h"


void zddsWriteVfoTag(char tag, uint8_t vfo);


// Diplsay freq  - pos for charlcd, vfo for graphics
void zddsDisplayCharLcdFreq(uint32_t f, uint8_t pos) __attribute__((section(".highmem")));
void zddsDisplayCharLcdFreq(uint32_t f, uint8_t pos)
{
	if (zc) {   // charlcd
		char su[2] = " ";//pmdSpaces(1);
    	char sv[10];
    	if (f > 9999999) su[0] = 0;
    	if (f < 1000000) {
	    	cdSetPos(1, pos);
			cdDisplayString(pmdSpaces(8));
		}
    	ltoa(f, sv, 10);
		strcat(su, sv);
		cdSetPos(1, pos);    
		cdDisplayString(su);
	}
}


void zddsShowFreq() __attribute__((section(".highmem")));
void zddsShowFreq()   // ddsDisplayFreq
{
	uint8_t pos;

	if (zc) {  // charlcd
		if (HowToShowFreq == 'S') { // stacks (or Wobbulator)
	  		if ((ScanMode == 'W') && (TuningMode == 'S')) pos = 32; else pos = 29;
		} else {
	  		if (VFO == 0) {
				if (Split == 0) pos = 22; else pos = 21;
			} else pos = 32;
		}
		if ((TuningMode != 'S') || (ScanMode != 'V')) {
	  		zddsDisplayCharLcdFreq(Freq, pos);
		}
	}

	if (zt) {
		if ((TuningMode != 'S') || (ScanMode != 'V')) {
    		etDisplayFrequency(Freq, VFO, VFO);  // active VFO display here
		}
	}

	if (zg) {  // graphics
		if ((TuningMode != 'S') || (ScanMode != 'V')) {
	        gedDisplayFrequency(Freq, VFO, VFO);  // active VFO display here
	  	}
	}

	if (zs) {  // 128x64 graphics
		if ((TuningMode != 'S') || (ScanMode != 'V')) {
	        ksDisplayFrequency(Freq, VFO, VFO);  // active VFO display here
	  	}
	}
}


void zddsShowBothVfoFreqs() __attribute__((section(".highmem")));
void zddsShowBothVfoFreqs()
{
	uint8_t x;
	char VfoTagA, VfoTagB;

	x = 0;
	if (zc) {  // charlcd
		strcpy(StrA, pmdSpaces(20));
		if (Split != 0) {
			if (VFO == 0) {StrA[0] = 'r'; StrA[11] = 't';} else {StrA[0] = 't'; StrA[11] = 'r';}
		} else {
	 		if (VFO == 0) {
				if ((Guarding == 1) && (GuardChannel == 0)) StrA[0] = 'G'; else StrA[0] = 'A';
			} else {
				if ((Guarding == 1) && (GuardChannel == 1)) StrA[10] = 'G'; else StrA[10] = 'B';
			}
		}
		cdSetPos(1, 20);
		cdDisplayString(StrA);
		if (Split == 0) {
	  		if (VFO == 0) x = 22; else x = 20;
		} else x = 21;
		zddsDisplayCharLcdFreq(VfoSlot[0].stFreq,x);
		zddsDisplayCharLcdFreq(VfoSlot[1].stFreq,32);
	}
	if (zg || zt || zs) {
		if (Split != 0) {
			if (VFO == 0) {VfoTagA = 'R'; VfoTagB = 'T';} else {VfoTagA = 'T'; VfoTagB = 'R';}
		} else {
		 	VfoTagA = 'A';
			VfoTagB = 'B';
			if (Guarding == 1) {
				if (GuardChannel == 0) VfoTagA = 'G';
				if (GuardChannel == 1) VfoTagB = 'G';
 			}
	  	}
		zddsWriteVfoTag(VfoTagA, 0);   // 0 = VFO A
		zddsWriteVfoTag(VfoTagB, 1);   // 1 = VFO B
		zddsDisplayGraphicsFreqs(VFO);
	}
}


void zddsShowInactiveVfoFreq() __attribute__((section(".highmem")));
void zddsShowInactiveVfoFreq()
{
	uint8_t x, IVFO;
	if(VFO==1) IVFO = 0; else IVFO = 1;
	x = 0;
	if (zc) {  // charlcd
		if (Split == 0) {
	  		if (VFO == 0) x = 22; else x = 20;
		} else x = 21;
		if (VFO == 1) zddsDisplayCharLcdFreq(VfoSlot[0].stFreq,x);
		else zddsDisplayCharLcdFreq(VfoSlot[1].stFreq, 32);
	}
	if (zg) gedDisplayFrequency(VfoSlot[IVFO].stFreq, IVFO, VFO);
	if (zt) etDisplayFrequency(VfoSlot[IVFO].stFreq, IVFO, VFO);
}


void zddsDisplayGraphicsFreqs(uint8_t ActiveVfo) __attribute__((section(".highmem")));
void zddsDisplayGraphicsFreqs(uint8_t ActiveVfo)
{
	if (zt) {
		etDisplayFrequency(VfoSlot[0].stFreq, 0, ActiveVfo);  // VFO A freq   (VFO determines colour ? white or yellow)
		etDisplayFrequency(VfoSlot[1].stFreq, 1, ActiveVfo);  // VFO B freq   (VFO determines colour ? white or yellow)
	}	
	if (zg) {  // graphics
		gedDisplayFrequency(VfoSlot[0].stFreq, 0, ActiveVfo);  // VFO A freq   (VFO determines bold or greyed)
		gedDisplayFrequency(VfoSlot[1].stFreq, 1, ActiveVfo);  // VFO B freq   (VFO determines bold or greyed)
	}
	if (zs) {  // graphics
		ksDisplayFrequency(VfoSlot[0].stFreq, 0, ActiveVfo);  // VFO A freq   (VFO determines bold or normal)
		ksDisplayFrequency(VfoSlot[1].stFreq, 1, ActiveVfo);  // VFO B freq   (VFO determines bold or normal)
  }
}


void zddsWriteVfoTag(char tag, uint8_t vfo) __attribute__((section(".highmem")));
void zddsWriteVfoTag(char tag, uint8_t vfo)
{
	if (zt) {
		if (tag == 'P') tag = '+';
		if (tag == 'M') tag = '-';
		etWriteVfoTag(tag, vfo, VFO);
	}
	if (zs) {
		if (tag == 'P') tag = '+';
		if (tag == 'M') tag = '-';
		ksWriteVfoTag(tag, vfo, VFO);
	}
	if (zg) {  // graphics
		uint8_t v = 17;
		switch (tag) {
			case 'P': v = 10;  break;
			case 'M': v = 11;  break;
			case 'R': v = 12;  break;
			case 'T': v = 13;  break;
			case 'A': v = 14;  break;
			case 'B': v = 15;  break;
			case 'G': v = 16;  break;
  		}
		gedWriteDigit(v, 0, vfo, VFO);     // 0 unused here because v.10, VFO is active VFO
	}
}


void zddsShowABdifference() __attribute__((section(".highmem")));
void zddsShowABdifference()
{
 	uint8_t x;

	if (zc) {
		strcpy(StrA, pmdSpaces(20));
		if (Split != 0) {
	 		if (VFO == 0) StrA[0] = 'r'; else StrA[11] = 'r';
			x = 21;
		} else {
	 		if (VFO == 0) {StrA[0] = 'A'; x=22;} else {StrA[10]='B'; x=20;}
		}
  		cdSetPos(1, 20);
		cdDisplayString(StrA);
		if (VFO == 0) zddsDisplayCharLcdFreq(VfoSlot[0].stFreq,x);
		else zddsDisplayCharLcdFreq(VfoSlot[1].stFreq,32);
	}
	if (zg || zt) {
		if (Split != 0) {
			if (VFO == 0) {
				zddsWriteVfoTag('R', 0);
				zddsWriteVfoTag('T', 1);
			} else {
				zddsWriteVfoTag('T', 0);
				zddsWriteVfoTag('R', 1);
			}
		} else {
			zddsWriteVfoTag('A', 0);
			zddsWriteVfoTag('B', 1);
		}
	}	
	if (zt) {
		if (VFO == 0) etDisplayFrequency(VfoSlot[0].stFreq, 0, 0);
		else etDisplayFrequency(VfoSlot[1].stFreq, 1, 1);
	}
	if (zg) {   // graphics
		if (VFO == 0) gedDisplayFrequency(VfoSlot[0].stFreq, 0, 0);
		else gedDisplayFrequency(VfoSlot[1].stFreq, 1, 1);
	}
	if (zs) {   // 128x64 graphics
		if (VFO == 0) ksDisplayFrequency(VfoSlot[0].stFreq, 0, 0);
		else ksDisplayFrequency(VfoSlot[1].stFreq, 1, 1);
	}
	zddsDisplayABdiff(VFO);                 
}


void zddsDisplayABdiff(uint8_t vfo) __attribute__((section(".highmem")));
void zddsDisplayABdiff(uint8_t vfo)
{
	uint8_t pos;
	uint8_t spcs;
	uint8_t Vy;
	int32_t diff;
	int32_t fx;
	int32_t fy;

	if (vfo == 0) pos = 31; else pos = 20;
	if (VFO == 1) Vy = 0; else Vy = 1;
	fx = VfoSlot[VFO].stFreq;
	fy = VfoSlot[Vy].stFreq;
	diff = fy - fx;
	if (zc) {
		StrA[0] = 0; // null string
  		if (diff == 0) strcpy(StrA,PMS(s_r_e_t));
		else {
	 		if (diff > 0) strcpy(StrA, "+");
    		else strcpy(StrA, "-");
    		ltoa(labs(diff), StrB, 10);  // must use labs  (abs does 16 bits only !!!)
	  		strcat(StrA, StrB);
		}
		spcs = 9 - strlen(StrA);
		if (spcs > 0) strcpy(StrB, pmdSpaces(spcs));
  		strcat(StrB, StrA);
		cdSetPos(1, pos);
  		cdDisplayString(StrB);
	}
	if (zt) {
		etDisplayDifference(diff, Vy, VFO);
	}
	if (zg) {  // graphics
		gedDisplayDifference(diff, Vy, VFO);
	} 
	if (zs) {  // 128x64 graphics
		ksDisplayDifference(diff, Vy, VFO);
	} 

}
