/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taSWR.c    program file
 
Forward and reflected power, SWR  
*/

#include "taGlobal.h"
#include <math.h>
#include "taCharLCD.h"
#include "taConfig.h"
#include "taStarControl.h"
#include "taSmeter.h"
#include "taProgmem.h"
#include "taDDS.h"
#include "taSWR.h"
#include "taADC.h"
#include "taFT245R.h"
#include "ta24LC512.h"
#include "taEncoder.h"
#include "taZ_SWR.h"

#define FullScaleSWR 4; // for meter - give range 1 to 4 (not 0 to 4)  


static uint16_t FwdMaxList[10];
static uint16_t RefMaxList[10];
static uint16_t SwrMaxList[10];
static uint8_t MaxPointer;
static uint16_t FwdADC;
static uint16_t RefADC;
static uint16_t FwdMax;
static uint16_t RefMax;
static uint16_t SwrMax;

uint8_t SWRflag;
char SWRmode;
uint32_t FwdCentiWatts;
uint32_t RefCentiWatts;
uint32_t SWRx100; 
uint16_t Mismatch;  
uint16_t FwdFsdDeciwatts;    // IJS 22.07.2010
uint16_t RefFsdDeciwatts;    // IJS 22.07.2010

uint16_t swGetCalFromUSB();
uint8_t swReceiveCalData();
void swSendSwrDataToPC();    // IJS 22.07.2010
void swSendSwrFsdToPC();    // IJS 22.07.2010
void swSendAdcData();


void swInitSWR() __attribute__((section(".highmem")));
void swInitSWR()
{
	uint8_t i;

	Mismatch = 0;
	SWRflag = 0;
	xeLoadSwrCalData();
	MaxPointer = 0;
	for (i = 0; i <= 9; i++) FwdMaxList[i] = 0;
	for (i = 0; i <= 9; i++) RefMaxList[i] = 0;
	for (i = 0; i <= 9; i++) SwrMaxList[i] = 0;
	zswSetFsdDeciwatts();   // added IJS 22.07.2010
	SWRmode = 'F';
	if (DisplaySwitch == 2) zswGraphicsSWRmeterInitialise(0);
	else zswGraphicsSWRmeterInitialise(1);
}


void swUsbRequest(char cmd) __attribute__((section(".highmem")));
void swUsbRequest(char cmd)
{
	switch (cmd) {
		case 'A': swSendAdcData(); break;
		case 'C': swReceiveCalData(); break;
		case 'S': swSendSwrDataToPC(); break;  // IJS 22.07.2010
		case 'F': swSendSwrFsdToPC(); break;   // IJS 22.07.2010
	}
}


void swSendSwrDataToPC() __attribute__((section(".highmem")));
void swSendSwrDataToPC()    // IJS 22.07.2010
{
	uint8_t SWRbuf[6];
	uint16_t swrdata;

	swrdata = FwdCentiWatts / 10;
	memcpy(&SWRbuf[0], &swrdata, 2);
	swrdata = RefCentiWatts / 10;
	memcpy(&SWRbuf[2], &swrdata, 2);
	swrdata = SWRx100;
	memcpy(&SWRbuf[4], &swrdata, 2);
	usbSendBlock(SWRbuf, 6, 1000);
}


void swSendSwrFsdToPC() __attribute__((section(".highmem")));
void swSendSwrFsdToPC()     // IJS 22.07.2010
{
	uint8_t Calbuf[4];

	memcpy(&Calbuf[0], &FwdFsdDeciwatts, 2);
	memcpy(&Calbuf[2], &RefFsdDeciwatts, 2);
	usbSendBlock(Calbuf, 4, 1000);
}


void swStepSwrMode() __attribute__((section(".highmem")));
void swStepSwrMode()
{
	uint8_t i;
	for(i=0;i<=9;i++){FwdMaxList[i]=0;};
	for(i=0;i<=9;i++){RefMaxList[i]=0;};
	for(i=0;i<=9;i++){SwrMaxList[i]=0;};
  switch(SWRmode)
	{
	  case('F'): {SWRmode='R'; break;};
		case('R'): {SWRmode='S'; break;};
		case('S'): {SWRmode='F'; break;};
  }
}


void swSetSwrMode(char mode) __attribute__((section(".highmem")));
void swSetSwrMode(char mode)
{
  SWRmode = mode;
}



void swDoSWR() __attribute__((section(".highmem")));
void swDoSWR()
{
  if(DisplayEnc==255){swDisplaySWR();};
}



void swDisplaySWR() __attribute__((section(".highmem")));
void swDisplaySWR()
{
	if(SWRflag==0){return;};
	SWRflag = 0;
	uint16_t Max = 0;;
	uint8_t CharLcdBars = 0;
	uint8_t i;
	uint16_t pwm = 0;
	uint8_t doswr;

  if(Transmit == 0)
	{
  	for(i=0;i<=9;i++){FwdMaxList[i]=0;};
  	for(i=0;i<=9;i++){RefMaxList[i]=0;};
  	for(i=0;i<=9;i++){SwrMaxList[i]=0;};
  }
	else
	{ 
	  char sx[8];
	  char sy[18];
    uint32_t a;
		uint8_t fsswr;
	  swReadSWR();
	  swCalcSWR();

    // The max lists are for text display - to make a more stable display
		MaxPointer += 1;
		if(MaxPointer > 9){MaxPointer = 0;};
		FwdMaxList[MaxPointer] = FwdCentiWatts;
    RefMaxList[MaxPointer] = RefCentiWatts;
		SwrMaxList[MaxPointer] = SWRx100;


		switch(SWRmode) // for CharLcd adn Pwd (graphics does all 3)
		{
		  case('F'):
			{    
	      a = FwdCentiWatts;
				pwm = ((a*256)/100)/CalDataStruct.cdsFwdFsWatts;
	      CharLcdBars = ((a*26)/100)/CalDataStruct.cdsFwdFsWatts; 	
				break;
      }
		  case('R'):
			{    
	      a = RefCentiWatts;
				pwm  = ((a*256)/100)/CalDataStruct.cdsRefFsWatts;
	      CharLcdBars = ((a*26)/100)/CalDataStruct.cdsRefFsWatts;
				break;
      }
		  case('S'):
			{    
      	fsswr = FullScaleSWR;
    		if(SWRx100>100*fsswr){SWRx100 = 100*fsswr;};
				if(SWRx100<100){SWRx100 = 100;};
				a = SWRx100-100;  //  a = 0 for SWR = 1
	      pwm  = ((a*256)/100)/(fsswr- 1);  // eg: FUll scale SWR of 4 gives range 1 - 4 on meter
	      CharLcdBars = ((a*26)/100)/(fsswr- 1);
				break;
      }
		}
    if(pwm>255){pwm=255;};
	  zswDisplayCharLcdSwrBars(CharLcdBars); // only acts if char display present
	  if((HardwareSettings.hsHardwareOptionsA & 0x01)!=0){scSetMeterPWM(pwm);};
		if(DisplaySwitch==2){doswr=0;}else{doswr=1;};
		zswDisplayGraphicsSwr(doswr);
		
     // code removed - crashes on trasnmit ? wny	
		if ((DisplayEnc == 255) && (zc))
		{
		  if(MaxPointer==0)
		  {
 			  FwdMax = 0; 
  	  	for(i=0;i<=9;i++){if(FwdMaxList[i]>FwdMax){FwdMax=FwdMaxList[i];};};
  		  RefMax = 0; 
  	  	for(i=0;i<=9;i++){if(RefMaxList[i]>RefMax){RefMax=RefMaxList[i];};};
  		  SwrMax = 0; 
  	  	for(i=0;i<=9;i++){if(SwrMaxList[i]>SwrMax){SwrMax=SwrMaxList[i];};};


    	  switch(SWRmode)
		  	{
			    case 'F': {Max=FwdMax; strcpy(sy,"Fwd="); break;};
  			  case 'R': {Max=RefMax; strcpy(sy,"Refl=");break;};
	  		  case 'S': {Max=SwrMax; strcpy(sy,"SWR=");break;};
        }

	      if(SWRmode=='S')
			  {
				  ltoa(Max,sx,10);  // Max will be in the range 100-700 - so sx is three chars
				  sx[2] = sx[1];
				  sx[1] = '.';
	  		}
		  	else
			  {
	        ltoa( Max/100,sx,10);
        }
        strcat(sy,sx);
			  if(SWRmode!='S'){strcat(sy,"w");};
				strcat(sy,pmdSpaces(4)); 
	      zswDisplaySwrText(sy);
      }
    }

  	swProtectPA();
	}
}





void swCalcSWR() __attribute__((section(".highmem")));
void swCalcSWR()
{
	double pf;
	double pr;
	double rc;
	double sw; 
	uint16_t p1;
	uint16_t p2;
	uint8_t r;
	uint8_t n;
  // Forward power
	n = FwdADC / 32 ;
	r = FwdADC % 32;
	if(n>31){n=31;};
	p1 = CalDataStruct.cdsFwdCalLevel[n];
	if(n > 30){n=30;};
	p2 = CalDataStruct.cdsFwdCalLevel[n+1];
  FwdCentiWatts = p1 + ((p2-p1)*r)/32;   // power level in CentiWatts
  // Reflected power
	n = RefADC / 32 ;
	r = RefADC % 32;
	if(n>31){n=31;};
	p1 = CalDataStruct.cdsRefCalLevel[n];
	if(n > 30){n=30;};
	p2 = CalDataStruct.cdsRefCalLevel[n+1];
  RefCentiWatts = p1 + ((p2-p1)*r)/32;   // power level in CentiWatts
  // calculate SWR  
  pf = FwdCentiWatts;
	pr = RefCentiWatts;
	rc = sqrt(pr/pf);
	if(rc < 1){ sw = 100*(1+rc)/(1-rc);}else{sw = 10000;};
	SWRx100 = trunc(sw);
	if(pf<50){SWRx100=100;};
}  



void swZeroSWR() __attribute__((section(".highmem")));
void swZeroSWR()
{
  FwdCentiWatts = 0;
	RefCentiWatts = 0;
	SWRx100 = 0;
}


void swReadSWR() __attribute__((section(".highmem")));
void swReadSWR()
{
  if(Transmit==0)
	{
	  FwdADC = 0;
		RefADC = 0;
	}
	else
	{
	  FwdADC = adReadADC(1);
	  RefADC = adReadADC(0);
  }
}


void swSendAdcData() __attribute__((section(".highmem")));
void swSendAdcData()
{
	uint8_t buf[4];

	if (Transmit == 0) {FwdADC = 0; RefADC = 0;}
	buf[0] = FwdADC & 0x00ff;
	buf[1] = FwdADC >> 8;
	buf[2] = RefADC & 0x00ff;
	buf[3] = RefADC >> 8;
	usbSendBlock(buf, 4, 1000);
/*
	strcpy(StrUsbA,PMS(s_SWRADC));
	ltoa(FwdADC,StrUsbB,10);
	strcat(StrUsbA,StrUsbB);
	strcat(StrUsbA,",");
	ltoa(RefADC,StrUsbB,10);
	strcat(StrUsbA,StrUsbB);
	usbSendString(StrUsbA,500,13);
*/
}


uint8_t swReceiveCalData() __attribute__((section(".highmem")));
uint8_t swReceiveCalData()
{
	uint16_t chksum = swGetCalFromUSB();
  if(chksum == 0){return 0;};
  usbPutByte(chksum / 256);
	usbPutByte(chksum % 256);
	swInitSWR();
  return 1;
}


uint16_t swGetCalFromUSB() __attribute__((section(".highmem")));
uint16_t swGetCalFromUSB()
{
  struct CalTransferStruct_type CalTransferStruct;
	uint8_t calbuf[2];
	//uint32_t addr;  // DSP code starts at EEPROM address 0
  uint8_t fails = 0;
	uint16_t i;
  uint8_t b;
  //uint16_t f;
	uint16_t ByteCount;
  uint32_t avrchecksum = 0;
	uint8_t* pt;
  // receive byte count  
	if(usbReceiveBlock(&calbuf[0],2,5000)==0){return 0;};
  ByteCount = 256*calbuf[0] + calbuf[1];
	_delay_ms(20);
	//f = 0;
	fails = 0;
	//addr = 0; 
	for(i=0;i<ByteCount;i++)
	{
 		do
		{	
			if (usbGetByte(&b) == 0)
	    { 
				fails += 1;
	       _delay_ms(200);
	    }
			else
	    {
				fails = 0;
		  }
      if(fails > 10){return 0;};
	  }	
		while(fails>0);		 
    pt = (uint8_t*)(&CalTransferStruct) + i;
		*pt = b;
		avrchecksum = (avrchecksum + b) % 0x10000;
  }
	avrchecksum = (avrchecksum + ByteCount) % 0x10000;
  xeLoadSwrCalData();
  if(CalTransferStruct.ctsFwdRef == 'F')
	{
	  for(i=0;i<32;i++){CalDataStruct.cdsFwdCalLevel[i] = CalTransferStruct.ctsCalLevel[i];}; 
    CalDataStruct.cdsFwdFsWatts = CalTransferStruct.ctsFsWatts;
  }
	else
	{
	  for(i=0;i<32;i++){CalDataStruct.cdsRefCalLevel[i] = CalTransferStruct.ctsCalLevel[i];}; 
    CalDataStruct.cdsRefFsWatts = CalTransferStruct.ctsFsWatts;
  }
  CalDataStruct.cdsMismatchDeciWatts = CalTransferStruct.ctsMismatchDeciWatts;
  CalDataStruct.cdsMismatchSeconds = CalTransferStruct.ctsMismatchSeconds;

  xeSaveSwrCalData();
	return avrchecksum;
}


// called by timer4 ISR every 100ms = 10 /second
// increments Mismatch by 5 (or more)   =   50 / second
void swProtectPA() __attribute__((section(".highmem")));
void swProtectPA()
{	
	uint16_t mdw = 10*CalDataStruct.cdsMismatchDeciWatts;   // Actually in CentiWatts to achieve 1 decimal place	
	if(RefCentiWatts >= mdw)
	{
	  Mismatch += 5 +	((RefCentiWatts - mdw)*15)/mdw; // charge 4 x faster at reflected = 2 x MismatchWatts 
  }
	else
	{
	  if(Mismatch >= 5){Mismatch -=  (5 - (4*RefCentiWatts)/mdw);}; // reduce discharge if reflected non zero
  }
	if(Mismatch >= 50*CalDataStruct.cdsMismatchSeconds){scPaBias(0);};
	if(Mismatch <  10*CalDataStruct.cdsMismatchSeconds){scPaBias(1);};   // hysteresis
}
