/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taKS0108.c    128x64 mono graphics control

*/


#include "taGlobal.h"
#include "taKS0108Driver.h"
#include "taKS0108.h"
#include "taFT245R.h"
#include "taFont8.h"
#include "taFont16.h"
#include "taStarControl.h"
#include "taSWR.h"
#include "taZ_SWR.h"

#define ksFreqInfoX1 0
#define ksFreqInfoY1 10
#define ksFreqInfoX2 37
#define ksFreqInfoY2 26
#define ksFreqInfoYmid 19

#define ksFilterX 102
#define ksFilterY 28

#define ksSmeterX 0
#define ksSmeterY 28
#define ksSmeterHeight 18
#define ksSmeterWidth 98

#define ksSWRmeterX 0
#define ksSWRmeterY 28
#define ksSWRmeterHeight 18
#define ksSWRmeterWidth 98


static uint8_t ksBarX;
static uint8_t ksBarTop;
static uint8_t ksBarBottom;
static uint8_t ksBarWidth;

uint8_t ksMsgShowing;
uint8_t ksFreqInfoShowing;
char ksFreqInfoText[10];

void ksWriteVfoTag(char tag, uint8_t Vfo, uint8_t ActiveVfo) __attribute__((section(".highmem")));
void ksWriteVfoTag(char tag, uint8_t Vfo, uint8_t ActiveVfo)
{
  uint16_t y;
  uint16_t x;
	StrA[0] = tag;
	StrA[1] = ' ';
	StrA[2] = ' ';
	StrA[3] = 0;
	if(Vfo==0)
	{
		x = 38;
	  if(Vfo==ActiveVfo)
		{
			y = 0;
			ksdWriteFreqAString(StrA,x,y);
		}
		else
		{
			ksdClearRect(38,0,60,12);
			y = 4;
			ksdF8WriteString(StrA,x,y,0);
		};
	}
	else
	{
	  x = 63;
		if(Vfo==ActiveVfo)
		{
			y = 16;   // was 16
			ksdWriteFreqBString(StrA,x,y);
		}
		else
		{
			y = 17;  // was 17
			ksdClearRect(x,y-1,127,y+6);
			ksdF8WriteString(StrA,x,y,0);
		};
  }
}


void ksDisplayFrequencyNoDP(uint32_t f, uint8_t Vfo, uint8_t LeadingZero) __attribute__((section(".highmem")));
void ksDisplayFrequencyNoDP(uint32_t f, uint8_t Vfo, uint8_t LeadingZero)
{
	uint8_t x,y;
	StrA[0]=0; // null string
	if((LeadingZero==1)&(f>0)){strcat(StrA,"0");};
	ltoa(f,StrB,10);
	strcat(StrA,StrB);
	if(Vfo==0)
	{
		x = 49;
		y = 0;
		ksdWriteFreqAString(StrA,x,y);
	}
	else
	{
	  x = 75;
		y = 16;   // was 16
		ksdWriteFreqBString(StrA,x,y);
	}
}



void ksDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo) __attribute__((section(".highmem")));
void ksDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo)
{
  uint16_t y;
  uint8_t x;
	uint16_t xb;

	if(f>9999999){strcpy(StrA,pmdSpaces(2));}else{strcpy(StrA,pmdSpaces(3));};
	ltoa(f,StrB,10);
	strcat(StrA,StrB);

	StrA[0]=StrA[2];
	StrA[1]=StrA[3];
	StrA[2] = '.';
	StrA[3] = StrA[4];
	StrA[4] = StrA[5];
	StrA[5] = StrA[6];
	StrA[6] = '.';

	if(Vfo==0)
	{
		x = 49;
		y = 0;
	  if(Vfo==ActiveVfo)
		{
			ksdWriteFreqAString(StrA,x,y);
		}
		else
		{
			xb = 120;
			ksdF16WriteChar(148,&xb,&y);
			if(StrA[0]==' '){StrA[0]=148;};
			ksdF16WriteString(StrA,x,y);
		};
	}
	else
	{
	  x = 74;  /////////
		if(Vfo==ActiveVfo)
		{
			y = 16;   // was 16
			ksdWriteFreqBString(StrA,x,y);
		}
		else
		{
			y = 17;  // was 17
			xb = 123;
			ksdF8WriteChar(154,&xb,&y,0);
			if(StrA[0]==' '){StrA[0]=154;};
			ksdF8WriteString(StrA,x,y,0);
		};
  }
}

void ksDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo) __attribute__((section(".highmem")));
void ksDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo)
{
	int pa,pb,nb;
	ksClearFrequencyDisplay(Vfo);	
	if(df==0)
	{strcpy(StrA,"0");}
	else
	{
		if(df>0){StrA[0]='+';}else{StrA[0]='-';}; 
		int32_t dfa = labs(df);
		ltoa(dfa,StrB,10);
		nb = strlen(StrB);
		pa = 1;           // StrA pointer
		for(pb=0;pb<nb;pb++)
		{
			if(((nb-pb)%3)==0){StrA[pa++] = '.';};
			StrA[pa++] = StrB[pb];
		}
		StrA[pa]=0;
	}
	if(Vfo==0)
	{
		ksdWriteFreqAString(StrA,38,0);
	}
	else
	{
		ksdWriteFreqBString(StrA,63,16); 
	}
}


void ksClearFrequencyDisplay(uint8_t Vfo) __attribute__((section(".highmem")));
void ksClearFrequencyDisplay(uint8_t Vfo)
{
	ksColour = 0;
	if(Vfo==0)
	{
		ksdClearRect(38,0,127,15);
  }
	else
	{
		ksdClearRect(63,15,127,23);   // was 16... 23
  }
	ksColour = 1;
}


void ksShowWobbulatorMode() __attribute__((section(".highmem")));
void ksShowWobbulatorMode()
{
	ksWriteFreqInfoHeader(PMS(s_Wobltr));
}

void ksShowVfoStackMode() __attribute__((section(".highmem")));
void ksShowVfoStackMode()
{
	ksWriteFreqInfoHeader(PMS(s_VFOstk));
}

void ksShowABscan() __attribute__((section(".highmem")));
void ksShowABscan()
{
	ksWriteFreqInfoHeader(PMS(s_ABscan));
}


void ksShowRateTuningMode() __attribute__((section(".highmem")));
void ksShowRateTuningMode()
{
	ksWriteFreqInfoHeader(PMS(s_RteTun));
}


void ksShowMemStackScan() __attribute__((section(".highmem")));
void ksShowMemStackScan()
{
	ksWriteFreqInfoHeader(PMS(s_Mscan));
}


void ksClearRITXIT() __attribute__((section(".highmem")));
void ksClearRITXIT()
{
	ksdClearRect(37,16,60,23);
}


void ksClearFreqInfo() __attribute__((section(".highmem")));
void ksClearFreqInfo()
{
	ksFreqInfoShowing = 0;
	ksdClearRect(ksFreqInfoX1,ksFreqInfoY1, ksFreqInfoX2,ksFreqInfoY2);
}


void ksClearFreqInfoUpper() __attribute__((section(".highmem")));
void ksClearFreqInfoUpper()
{
	ksdClearRect(ksFreqInfoX1,ksFreqInfoY1, ksFreqInfoX2,ksFreqInfoYmid-1);
}


void ksClearFreqInfoLower() __attribute__((section(".highmem")));
void ksClearFreqInfoLower()
{
	ksdClearRect(ksFreqInfoX1,ksFreqInfoYmid, ksFreqInfoX2,ksFreqInfoY2);
}


void ksWriteFreqInfoData(char* s) __attribute__((section(".highmem")));
void ksWriteFreqInfoData(char* s)
{
	ksClearFreqInfoLower();
	ksdF8WriteString(s,ksFreqInfoX1,ksFreqInfoYmid,0);
	ksFreqInfoShowing = 1;
	strcpy(ksFreqInfoText,s);
}

void ksWriteFreqInfoHeader(char* s) __attribute__((section(".highmem")));
void ksWriteFreqInfoHeader(char* s)
{
	ksClearFreqInfoUpper();
	ksdF8WriteString(s,ksFreqInfoX1,ksFreqInfoY1,0);
}



//////////////////////////////////////////////////////////////////////

void ksFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw) __attribute__((section(".highmem")));
void ksFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw)
{
	uint8_t w = (widthparam+5)/10;
	uint8_t c  = (centreparam+10)/20;
	if(c > 11){c=11;};
	if(w>24){w=24;};
	uint8_t sk = (24-w)/2;
	uint8_t sj = (25-w)/2;
	uint8_t X = ksFilterX;
	uint8_t Y = ksFilterY;
	ksdClearRect(X-2,Y,X+25,Y+24);
	if(Mode==1)
	{
	  ksdLine(X+12-c,Y+22,X+12-c,Y+24);
	}
	else
	{
		ksdLine(X+12+c,Y+22,X+12+c,Y+24);
	};
	ksdLine(X,Y+20,X+sk,Y+20);
  ksdLine(X+24-sj,Y+20,X+24,Y+20);
	ksdLine(X+sk,Y,X+24-sj,Y);
	ksdLine(X+sk,Y,X+sk,Y+20);
	ksdLine(X+24-sj,Y,X+24-sj,Y+20);
	
	if(ksMsgShowing==0)
	{
		ksdClearRect(75,48,98,52);
		ksdWrite5x3String(swid,75,48);
	}
}



void ksFilterCW(char * swid, uint8_t widthparam, 
           uint8_t centreparam, uint8_t depthparam, uint8_t sw) __attribute__((section(".highmem")));
void ksFilterCW(char * swid, uint8_t widthparam, 
           uint8_t centreparam, uint8_t depthparam, uint8_t sw)
{
	uint8_t w = (widthparam+5)/10;
	uint8_t c  = (centreparam+10)/20;

	if(c > 11){c=11;};
	if(w>24){w=24;};
	if(w<2){w=2;};
	uint8_t d;
	if(sw==1){d=depthparam*2;}else{d=0;}; 
	uint8_t sk = (24-w)/2;
	uint8_t sj = (25-w)/2;
	uint16_t X = ksFilterX;
	uint16_t Y = ksFilterY;
	ksdClearRect(X-2,Y-1,X+25,Y+24);
	if(Mode==1)
	{
	  ksdLine(X+12-c,Y+22,X+12-c,Y+24);
	}
	else
	{
		ksdLine(X+12+c,Y+22,X+12+c,Y+24);
	};
	ksdLine(X,Y+20,X+sk,Y+20);
  ksdLine(X+24-sj,Y+20,X+24,Y+20);
  ksdLine(X+sk,Y+d,X+11,Y+d);	// L shoulder
  ksdLine(X+13,Y+d,X+24-sj,Y+d);	//R shoulder
	ksdLine(X+11,Y,X+13,Y);      // top
	ksdLine(X+11,Y,X+11,Y+d);
	ksdLine(X+13,Y,X+13,Y+d);
	ksdLine(X+sk,Y+d,X+sk,Y+20);
	ksdLine(X+24-sj,Y+d,X+24-sj,Y+20);
 	
	if(ksMsgShowing==0)
	{
		ksdClearRect(75,48,98,52);
		ksdWrite5x3String(swid,75,48);
	}
}

///////////////////////////////////////////////////////////////////////////

void ksSmeterInit() __attribute__((section(".highmem")));
void ksSmeterInit()
{
	uint8_t x, yn;
	uint8_t y, i;
	ksBarX = ksSmeterX + 11;
	ksBarTop = ksSmeterY + 2;
	ksBarBottom = ksBarTop + 3;
	ksBarWidth = 0;
	ksdClearRect(ksBarX, ksBarTop, ksBarX+85, ksBarBottom); // clear bar of previous Smeter
	ksdLine(ksSmeterX, ksSmeterY, ksSmeterX + ksSmeterWidth-1, ksSmeterY);
 	ksdLine(ksSmeterX, ksSmeterY, ksSmeterX, ksSmeterY + ksSmeterHeight-1);
	ksdLine(ksSmeterX + ksSmeterWidth-1, ksSmeterY, ksSmeterX + ksSmeterWidth-1,ksSmeterY + ksSmeterHeight-1);
	ksdF8WriteString("S", ksSmeterX+3, ksSmeterY + 4,0);
	y = ksSmeterY + 2;
	yn = ksSmeterY + 11;
	for (i = 0; i <= 9; i++)
	{
		x = ksSmeterX + 11 + i * 5;
		ksdLine(x,y + 6 - 1 * (i % 2), x, y + 7);
		x -= 1;
		StrA[0] = i+0x30;
		StrA[1] = 0;
		if ((i % 2) == 1) ksdWrite5x3String(StrA, x, yn);
	}	
	for (i = 1; i <= 6; i++)
	{
		x = ksSmeterX + 11 + 45 + i * 6;
		ksdLine(x, y + 6 - 1 * ((i + 1) %2 ), x, y + 7);
		switch(i)
		{
			case 2: ksdWrite5x3String("20", x-3, yn); break;
			case 4: ksdWrite5x3String("40", x-3, yn); break;
			case 6: ksdWrite5x3String("60", x-3, yn); break;
		}
	}
 	ksdLine(ksSmeterX, ksSmeterY+ksSmeterHeight-1, ksSmeterX + ksSmeterWidth-1, ksSmeterY + ksSmeterHeight-1);
}

void ksMeterBarSet(uint8_t w) __attribute__((section(".highmem")));
void ksMeterBarSet(uint8_t w)
{ 
	if(ksMsgShowing) return;
	uint8_t pw = ksBarWidth;
	ksBarWidth = w; 
	if (w != pw)
	{
		if (w > pw)
		{
			ksdFillRect(ksBarX + pw + 1, ksBarTop, ksBarX + w, ksBarBottom);
		}
		else
		{
			ksdClearRect(ksBarX + w + 1, ksBarTop, ksBarX + pw, ksBarBottom);
		}
	}
}


void ksClearSwrMeter() __attribute__((section(".highmem")));
void ksClearSwrMeter()
{
	ksdClearRect(ksSmeterX, ksSmeterY, ksSmeterX+ksSmeterWidth, ksSmeterY+ksSmeterHeight);
}


void ksClearSmeter() __attribute__((section(".highmem")));
void ksClearSmeter()
{
	ksdClearRect(ksSmeterX, ksSmeterY, ksSmeterX+ksSmeterWidth, ksSmeterY+ksSmeterHeight);
}

void ksSwrInit() __attribute__((section(".highmem")));
void ksSwrInit()
{
	uint8_t x,yn,q;
	uint8_t y,i,e;
	ksBarX = ksSWRmeterX + 15;
	ksBarTop = ksSWRmeterY + 2;
	ksBarBottom = ksBarTop + 3;
	ksBarWidth = 0;
	ksdClearRect(ksBarX, ksBarTop, ksBarX+85, ksBarBottom); // clear bar of previous SWRmeter
	ksdLine(ksSWRmeterX, ksSWRmeterY, ksSWRmeterX + ksSWRmeterWidth-1, ksSWRmeterY);
 	ksdLine(ksSWRmeterX, ksSWRmeterY, ksSWRmeterX, ksSWRmeterY + ksSWRmeterHeight-1);
	ksdLine(ksSWRmeterX + ksSWRmeterWidth-1, ksSWRmeterY, 
										ksSWRmeterX + ksSWRmeterWidth-1,ksSWRmeterY + ksSWRmeterHeight-1);
	StrA[0] = SWRmode;
	StrA[1] = 0;
	ksdF8WriteString(StrA, ksSmeterX+3, ksSmeterY + 4,0);
	y = ksSWRmeterY+2;
	yn = ksSWRmeterY+11;		
	for (i = 0; i <= 15; i++)
	{
		x = ksSWRmeterX + ksBarX + i*5;
		if ((i%5) == 0) e = 1; else e = 0;
		ksdLine(x,y+6-e,x,y+7);
		if ((i%5) == 0)
		{
			if (SWRmode == 'S')
			{
				StrA[0] = (i/5)+0x31; 
				StrA[1]=0;
			}
			else strcpy(StrA,zswPowerLabel(SWRmode,i/5));
			q = 2*strlen(StrA);
			ksdWrite5x3String(StrA,x-q,yn); 
		}
	}
 	ksdLine(ksSWRmeterX, ksSWRmeterY+ksSWRmeterHeight-1, 
						ksSWRmeterX + ksSWRmeterWidth-1, ksSWRmeterY + ksSWRmeterHeight-1);
}		


