/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEATFTmenus.c    program file
 
 EA eDIPTFT43-ATP  intelligent 480 x 272 intelligent TFT colour display
 
 menus module of display
   
*/


#include "taGlobal.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taStarControl.h"
#include "taEncoder.h"
#include "taMenus.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "taUsart.h"
#include "taADC.h"
#include "taButtons.h"
#include "taZ_StarControl.h"
#include "taGraphicsEA320.h"
#include "taEA320TouchPanel.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsEA320.h"
#include "taZ_StarControl.h"
#include "taFT245R.h"
#include "taCAT.h"
#include "taEATFTcommands.h"  
#include "taEATFTmenus.h"
#include "taEATFT.h"
#include "taRTC.h"
#include "taEEPRoM.h"
#include "taIntEeprom.h"

#define InfoX 226
#define InfoY 184
#define InfoW 197
#define InfoH 88

#define ScrollSpacing 17

#define clMenuText 10
#define clMenuHighlightText 7
#define clMenuBackground 1
#define clMenuHighlightBackground 17
#define clMenuFrame 16
#define clInfoFrame 16
#define clInfoBackground 1


static int PrevIndex;
static uint8_t refresh;
static uint8_t keypress;
static uint8_t adjusting;
static uint8_t Column1Chars; // if zero all text same colour
static uint8_t Column2X;
static uint8_t Column1Colour;

uint8_t emeGotoSlot(uint8_t slotkind, uint8_t m);
char* emeSlotInfo();
char* emeSlotMenuString(uint8_t i);
char* emeMemSlotMenuString(uint8_t Index);
char* emeVfoSlotMenuString(uint8_t i);
char* emeBandSlotMenuString(uint8_t i);
char emeSlotListMenu(uint8_t slotkind);
char* emeTaskString(uint8_t task);
char* emeMainMenuString(uint8_t Index);
char* emeEncoderAssignString(uint8_t index);
char* emeButtonAssignString(uint8_t b);
char* emeTouchpadAssignString(uint8_t b);
void emeButtonAssign(char rt);
void emeTouchpadAssign(char rt);
void emeAdjustDisplayBrightness(uint32_t v);
void emeEditDisplayBright();
void emeEditDisplayDimmed();
void emeAdjustNothing(uint32_t v);
void emeEditAutodimSeconds();
void emeEditMenuTimeout();
void emeEditMoxTimeout();
void emeEditLocalTimeOffset();
void emeAdjustDDSclock(uint32_t f);
void emeEditDDSclock();
void emeTouchpadCal();
void emeAdjustLSBoffset(uint32_t f);
void emeEditLSBoffset();
void emeAdjustUSBoffset(uint32_t f);
void emeEditUSBoffset();
void emeEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max, 
                           uint8_t step, char msg, void (*pAdjust)(uint32_t n));
void emeEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
                           int8_t step, uint8_t inc, char msg, void (*pAdjust)(uint32_t n));
void emeEditNumeric(uint32_t* val);
void emeDisplayParamNameAndVal(uint8_t ParamNo, uint8_t adjusting, uint8_t colour, uint8_t keypress);
uint8_t emeCheckForEncodersPots();
void emeWriteEditNumberDirections(char wot);
char* (*pGetItemString)(uint8_t n);
void emeInitScrollMenu(uint8_t HeaderLines);
void emeInitScroll();
void emeDrawListItem(char* u, uint8_t Highlighted, uint16_t y);
void emeDrawList(int Index);
void emeDrawHighlightedItem(int Index);
void emeUnHighlight(int Index);
uint16_t emeLineY(uint8_t n);


uint16_t emeLineY(uint8_t n)
{
  return Y1scroll + n*ScrollSpacing;
}


void emeDrawListItem(char* u, uint8_t Highlighted, uint16_t y) __attribute__((section(".highmem")));
void emeDrawListItem(char* u, uint8_t Highlighted, uint16_t y)
{
	char v[20];  // must be big enough for column 1 if dual column
	uint8_t j;
	if (Column1Chars>0)
	{
		for(j=0;j<Column1Chars;j++){v[j] = u[j];};
		v[Column1Chars] = 0;
		for(j=0;j<=strlen(u);j++){u[j]=u[j+Column1Chars];};
	}
	etcColourRect(X1scroll,y-1,X1scroll+XXscroll,y+ScrollSpacing-2,1);
	if (Highlighted)
	{			
		if (Column1Chars==0)
		{
			etcTextColour(clMenuHighlightText,clMenuHighlightBackground);
			etcString(X1scroll,y,'L',u);
		}
		else
		{
			etcTextColour(Column1Colour,clMenuHighlightBackground);
			etcString(X1scroll,y,'L',v);
			etcTextColour(clMenuHighlightText,clMenuHighlightBackground);
			etcString(X1scroll+Column2X,y,'L',u);
		}
	}
	else
	{
		if (Column1Chars==0)
		{
			etcTextColour(clMenuText,clMenuBackground);
			etcString(X1scroll,y,'L',u);
		}
		else
		{
			etcTextColour(Column1Colour,clMenuBackground);
			etcString(X1scroll,y,'L',v);
			etcTextColour(clMenuText,clMenuBackground);
			etcString(X1scroll+Column2X,y,'L',u);
		}
  }
}


void emeDrawList(int Index) __attribute__((section(".highmem")));
void emeDrawList(int Index)
{
	uint16_t y;
	char u[60];
	int pos,i;
	uint8_t h;
	etcFont(Arial16);
	for(pos=0;pos<VisibleCount;pos++)
	{  
		y = Y1scroll+pos*ScrollSpacing;
		
		i = pos + Index - HighlightedPos;
		if (i<0){i+=ScrollItemCount;};
		if (i>=ScrollItemCount){i-=ScrollItemCount;}
		strcpy(u,pGetItemString(i));
		if (pos==HighlightedPos){h=1;}else{h=0;};
		emeDrawListItem(u,h,y);		
	}
	PrevIndex = Index;
}




void emeUpdateList(int Index) __attribute__((section(".highmem")));
void emeUpdateList(int Index)
{
	if (Index==PrevIndex){emeDrawList(Index); return;}
	uint8_t y;
	char u[60];
	int pos,i;
	etcFont(Arial16);
	emeUnHighlight(PrevIndex);

	uint8_t down = 0;
	uint8_t up = 0;
	if ((Index==0)&&(PrevIndex==ScrollItemCount-1)){up=1;}
	if ((PrevIndex==0)&&(Index==ScrollItemCount-1)){down=1;}
	if ((up==0)&&(down==0))
	{
		if ((abs(Index - PrevIndex)) != 1) {emeDrawList(Index); return;}
		if (Index>PrevIndex){up=1;}
	}	
	if (up)
	{
		etcCopyRect(X1scroll, Y1scroll+ScrollSpacing, X1scroll+XXscroll, 
		      Y1scroll+(VisibleCount)*ScrollSpacing,X1scroll,Y1scroll);
		pos = VisibleCount - 1;
	}
	else
	{
		etcCopyRect(X1scroll, Y1scroll, X1scroll+XXscroll, 
		      Y1scroll+(VisibleCount-1)*ScrollSpacing,X1scroll,Y1scroll+ScrollSpacing);

		pos = 0;
	}
	i = pos + Index - HighlightedPos;
	if (i<0){i+=ScrollItemCount;};
	if (i>=ScrollItemCount){i-=ScrollItemCount;}
	y = Y1scroll+pos*ScrollSpacing;
	etcColourRect(X1scroll,y-1,X1scroll+XXscroll,y+ScrollSpacing-2,1);
	strcpy(u,pGetItemString(i));
	emeDrawListItem(u,0,y);
	emeDrawHighlightedItem(Index);	
	PrevIndex = Index;
  return;
}



// this is used when the highlighted item has been edited
void emeDrawHighlightedItem(int Index) __attribute__((section(".highmem")));
void emeDrawHighlightedItem(int Index)
{
	uint8_t y;
	char u[60];		
	y = Y1scroll+HighlightedPos*ScrollSpacing;
	etcColourRect(X1scroll,y-1,X1scroll+XXscroll,y+ScrollSpacing-2,1);
	strcpy(u,pGetItemString(Index));
	etcFont(Arial16);
	emeDrawListItem(u,1,y);
}



void emeUnHighlight(int Index) __attribute__((section(".highmem")));
void emeUnHighlight(int Index)
{
	uint8_t y;
	char u[60];		
	y = Y1scroll+HighlightedPos*ScrollSpacing;
	etcColourRect(X1scroll,y-1,X1scroll+XXscroll,y+ScrollSpacing-2,1);
	strcpy(u,pGetItemString(Index));	
	etcFont(Arial16);
	emeDrawListItem(u,0,y);
}



void emeInitScrollMenu(uint8_t HeaderLines) __attribute__((section(".highmem")));
void emeInitScrollMenu(uint8_t HeaderLines)
{
	emeMenuFrame(); 
	X1scroll = MenuX + 4;
	Y1scroll = MenuY + 3 + HeaderLines*ScrollSpacing;
	XXscroll = MenuW - 6;
	YYscroll = MenuH - 4 - HeaderLines*ScrollSpacing;
	PrevIndex = 255;
	VisibleCount = YYscroll/ScrollSpacing;
	if (VisibleCount>ScrollItemCount){VisibleCount=ScrollItemCount;};
	HighlightedPos = VisibleCount/2;
	etcColourRect(X1scroll,Y1scroll+1,X1scroll+XXscroll-2,Y1scroll+YYscroll-2,clMenuBackground);
}


////////   END or scroll module //////////
///////////////////////////////////////////////////////////



// get menu name for graphics
char* emeMainMenuString(uint8_t Index)  // FUNCTION POINTER TARGET - must be < 128k
{
	strcpy_P(pmStrBuf, (PGM_P)&pmdMainMenuList[Index]);
	return &pmStrBuf[0];
} 

/////////    MenuWindow  ////////////////////




void emeDeleteMenu() __attribute__((section(".highmem")));
void emeDeleteMenu()
{
	etcColourRect(MenuX, MenuY, MenuX+MenuW-1, MenuY+MenuH-1, 1);
	ztDSPDisplay = 0;
}


void emeMenuFrame() __attribute__((section(".highmem")));
void emeMenuFrame()
{
	etcColourRect(MenuX, MenuY, MenuX+MenuW-1, MenuY+MenuH-1, clMenuBackground);
	etcLineColour(clMenuFrame, 1);
	etcRect(MenuX, MenuY, MenuX+MenuW-1, MenuY+MenuH-1);
	ztDSPDisplay = 0;
}


void emeClearMenu() __attribute__((section(".highmem")));
void emeClearMenu()
{
	etcColourRect(MenuX+1,MenuY+1,MenuX+MenuW-2,MenuY+MenuH-2,clMenuBackground);
	ztDSPDisplay = 0;
}

void emeMenuString(uint8_t X, uint8_t Y, char pos, char* s) __attribute__((section(".highmem")));
void emeMenuString(uint8_t X, uint8_t Y, char pos, char* s)
{
	etcString(MenuX+X,MenuY+Y,pos,s);
}


void emeClearMenuRect(uint8_t X1, uint8_t Y1, uint8_t X2, uint8_t Y2) __attribute__((section(".highmem")));
void emeClearMenuRect(uint8_t X1, uint8_t Y1, uint8_t X2, uint8_t Y2)
{
	etcColourRect(MenuX+X1, MenuY+Y1, MenuX+X2, MenuY+Y2,1);
	ztDSPDisplay = 0;
}



///////////////////   RTC   /////////////////////////

void emeDrawTime() __attribute__((section(".highmem")));
void emeDrawTime()
{
  if ((RtcActive==0) || NoClockDraw || (DisplaySwitch ==2)) return;
	rtcPrepareTime();
	etcFont(Arial16);
	etcTextColour(6, 1);
	etcString(InfoX+8, InfoY+InfoH-40+3, 'L', StrA);
	etcTextColour(11, 1);
	etcString(InfoX+9, InfoY+InfoH-20+3, 'L', StrB);
}


void emeDrawDateTime() __attribute__((section(".highmem")));
void emeDrawDateTime()
{
  if ((RtcActive==0) || NoClockDraw || (DisplaySwitch ==2)) return;
	rtcPrepareTime();
	etcFont(Arial16);
	etcColourRect(InfoX,InfoY+InfoH-40,InfoX+InfoW-1,InfoY+InfoH-21,1);
	strcat(StrA,StrDateU);
	etcTextColour(6, 1);
	etcString(InfoX+8, InfoY+InfoH-40+3, 'L', StrA);
	etcColourRect(InfoX,InfoY+InfoH-20,InfoX+InfoW-1,InfoY+InfoH-1,1);
	strcat(StrB,StrDateL);
	etcTextColour(11, 1);
	etcString(InfoX+9, InfoY+InfoH-20+3, 'L', StrB);
}

/////////    InfoWindow  ////////////////////


void emeDeleteInfo() __attribute__((section(".highmem")));
void emeDeleteInfo()
{
  NoClockDraw = 0;
	etcColourRect(InfoX,InfoY,InfoX+InfoW-1,InfoY+InfoH-1,1);
}



void emeInfoFrame() __attribute__((section(".highmem")));
void emeInfoFrame()
{
  etcColourRect(InfoX,InfoY,InfoX+InfoW-1,InfoY+InfoH-1,1);
	etcLineColour(clInfoFrame,1);
	etcRect(InfoX,InfoY,InfoX+InfoW-1,InfoY+InfoH-1);
}


void emeClearInfo() __attribute__((section(".highmem")));
void emeClearInfo()
{
  etcColourRect(InfoX+1,InfoY+1,InfoX+InfoW-2,InfoY+InfoH-2,clInfoBackground);
}


void emeClearInfoRect(uint8_t X1, uint8_t Y1, uint8_t X2, uint8_t Y2) __attribute__((section(".highmem")));
void emeClearInfoRect(uint8_t X1, uint8_t Y1, uint8_t X2, uint8_t Y2)
{
	if (X2>(InfoW-2)){X2=InfoW-2;};
	etcColourRect(InfoX+X1, InfoY+Y1, InfoX+X2, InfoY+Y2,1);
}


void emeClearInfoLower() __attribute__((section(".highmem")));
void emeClearInfoLower()
{
  etcColourRect(InfoX+1,InfoY+40,InfoX+InfoW-2,InfoY+InfoH-2,clInfoBackground);
}


void emeInfoString(uint8_t X, uint8_t Y, char pos, char* s) __attribute__((section(".highmem")));
void emeInfoString(uint8_t X, uint8_t Y, char pos, char* s)
{
	etcString(InfoX+X,InfoY+Y,pos,s);
}


// 'E' key is abort/ESC   (used as copy in main-loop mode)

void emeDoMenus() __attribute__((section(".highmem")));
void emeDoMenus()
{
	int encCount7;
	int m = 0;
	char kc; 
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 0;
	uint8_t restart = 1;

	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	MenuW = MenuWstandard;
	do {
		ScrollItemCount = 15;   // was 14  IJS 09.1.2011
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1) {
			etcFont(Arial16);
			Column1Chars = 0;
			pGetItemString = emeMainMenuString;
			emeInitScrollMenu(0);
			emeDrawList(m);
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1) {
			etcFont(Arial16);
			emeUpdateList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0) {
			MenuTimer = 0;
			m += encCount7;
			if (m < 0) m = (m%ScrollItemCount) ? (m%ScrollItemCount)+ScrollItemCount : 0;
			if (m >= ScrollItemCount) m = m%ScrollItemCount;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M') {  // M is menu key
			emeClearMenu();
			switch (m) {
				case 0: emeEncoderAssign(0);		break;
				case 1: emeButtonAssign('R');		break;
				case 2: emeButtonAssign('T');		break;
				case 3: emeEditDisplayBright();		break;
				case 4: emeEditDisplayDimmed();		break;
				case 5: emeEditAutodimSeconds();	break;
				case 6: emeEditMenuTimeout();		break;
				case 7: emeEditMoxTimeout(); 		break;
				case 8: emeEditDDSclock();			break;
				case 9: emeEditUSBoffset();			break;
				case 10: emeEditLSBoffset();		break;
				case 11: emeEditLocalTimeOffset(); break;
				case 12: emeTouchpadAssign('R');	break;
				case 13: emeTouchpadAssign('T'); 	break;
				case 14: emeTouchpadCal();		 	break;
			}
			kc = 'X';
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));  // 'E' is ESC key
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	emeDeleteMenu();
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2) dspStartDSPdisplayEATFT();
	else zscShowDSPKeys();
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}



/////////////////////////////////////////////


char* emeTaskString(uint8_t task)     // FUNCTION POINTER TARGET - must be < 128k
{
  return buTaskName(task);
}


char* emeButtonAssignString(uint8_t button)
{
	uint8_t task;
	if (ButtonRT == 'R')
	{
		task = RxButtonAssignments[button];
	}
	else
	{
		task = TxButtonAssignments[button];
	};
	StrA[0] = 0x41 + button;
	StrA[1] = 0x20;
	StrA[2] = 0x20;
	StrA[3] = 0;
	strcat(StrA, buTaskName(task));
	return StrA;
}


void emeButtonAssign(char rt) __attribute__((section(".highmem")));
void emeButtonAssign(char rt)
{	
	int encCount7;
	int button = 0;  //  0 to 25  (= 'a' to 'z')
	int task = 0;
	char kc;
	uint8_t refresh = 0;
	uint8_t restart = 1;
	uint8_t nt = buGetNoofTasks();

	ButtonRT = rt;
	if (rt == 'R') ButtonMode = 0;
	else ButtonMode = 1;
	/////  Graphics menu initialise ///////////
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			etcFont(Arial16);   // IJS 15.11.2009
			Column1Chars = 3;
			Column1Colour = 12;
			Column2X = 16;
			emeInitScrollMenu(1);
			if (rt == 'R') strcpy(StrA, PMS(se__Select_Rx_));
			else strcpy(StrA, PMS(se__Select_Tx_));
			strcat(StrA, PMS(se_task_button));
			etcColourRect(MenuX+1, MenuY+1, MenuX+MenuW-2, MenuY+ScrollSpacing+1, 2);
			etcTextColour(7, 2);
			etcString(MenuX+3, MenuY+1, 'L', StrA);
			pGetItemString = emeButtonAssignString;
			ScrollItemCount = noofButtons;
			emeDrawList(button);
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			etcFont(Arial16);   // IJS 15.11.2009
			if (rt == 'R') task = RxButtonAssignments[button];
			else task = TxButtonAssignments[button];
			emeUpdateList(button);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			button += encCount7;
			if (button < 0) button = (button%noofButtons) ? (button%noofButtons)+noofButtons : 0;
			if (button >= noofButtons) button = button%noofButtons;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M')
		{
			Column1Chars = 0;
			emeClearMenu();
			etcFont(Arial16);   /// IJS 17.11.2009
			pGetItemString = emeTaskString;
			ScrollItemCount = nt;
			emeInitScrollMenu(1);
			if (rt == 'R') strcpy(StrA, PMS(se__Select_Rx_));
			else strcpy(StrA, PMS(se__Select_Tx_));
			strcat(StrA, PMS(se_button___task));
			StrA[19] = button + 0x41;
			etcColourRect(MenuX+1, MenuY+1, MenuX+MenuW-2, MenuY+ScrollSpacing+1, 2);
			etcTextColour(7, 2);
			etcString(MenuX+3, MenuY+1, 'L', StrA);
			emeDrawList(task);
			enGetEncoder7delta();
			refresh = 0;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
				scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					etcFont(Arial16);   /// IJS 17.11.2009
					emeUpdateList(task);
					refresh = 0;
				}
				encCount7 = enGetEncoder7delta();
				if (encCount7 != 0)
				{
					MenuTimer = 0;
					task += encCount7;
					if (task < 0) task = (task%nt) ? (task%nt)+nt : 0;
					if (task >= nt) task = task%nt;
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if (kc != 'E') kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if (kc == 'M')
			{
				if (rt == 'R')
				{
					if (buGetTaskAllowed(task, ButtonMode)) RxButtonAssignments[button] = task;
					else RxButtonAssignments[button] = 0;
					scEEwriteRxButtonAssignments();
					if (zg)
					{
						if (button >= 18) geButtonLabelsZtoSRx(0,0);
						else if (button >= 11) geButtonLabelsLtoRRx(0,0);
					}
				}
				else
				{
					if (buGetTaskAllowed(task, ButtonMode)) TxButtonAssignments[button] = task;
					else TxButtonAssignments[button] = 0;
					scEEwriteTxButtonAssignments();
					if (zg)
					{
						if (button >= 18) geButtonLabelsZtoSTx(0,0);
						else if (button >= 11) geButtonLabelsLtoRTx(0,0);
					}
				}
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
}


char* emeTouchpadAssignString(uint8_t button)
{
	uint8_t task;
	if (ButtonRT == 'R') task = RxTouchpadAssignments[button];
	else task = TxTouchpadAssignments[button];
	if (button < 9) {
		StrA[0] = 0x31 + button;
		StrA[1] = 0x20;
	} else {
		StrA[0] = '1';
		StrA[1] = 0x30 + button - 9;
	}
	StrA[2] = 0x20;
	StrA[3] = 0;
	strcat(StrA, buTaskName(task));
	return StrA;
}


void emeTouchpadAssign(char rt) __attribute__((section(".highmem")));
void emeTouchpadAssign(char rt)
{	
	int encCount7;
	int button = 0;  //  0 to 14  (= '1' to '15')
	int task = 0;
	char kc;
	uint8_t refresh = 0;
	uint8_t restart = 1;
	uint8_t nt = buGetNoofTasks();

	ButtonRT = rt;
	if (rt == 'R') ButtonMode = 0;
	else ButtonMode = 1;
	/////  Graphics menu initialise ///////////
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			etcFont(Arial16);   // IJS 15.11.2009
			Column1Chars = 3;
			Column1Colour = 12;
			Column2X = 16;
			emeInitScrollMenu(1);
			if (rt == 'R') strcpy(StrA, &(PMS(se__Select_Rx_))[2]);
			else strcpy(StrA, &(PMS(se__Select_Tx_))[2]);
			strcat(StrA, PMS(se_task_touchpad));
			etcColourRect(MenuX+1, MenuY+1, MenuX+MenuW-2, MenuY+ScrollSpacing+1, 2);
			etcTextColour(7, 2);
			etcString(MenuX+3, MenuY+1, 'L', StrA);
			pGetItemString = emeTouchpadAssignString;
			ScrollItemCount = noofTPButtons;
			emeDrawList(button);
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			etcFont(Arial16);   // IJS 15.11.2009
			if (rt == 'R') task = RxTouchpadAssignments[button];
			else task = TxTouchpadAssignments[button];
			emeUpdateList(button);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			button += encCount7;
			if (button < 0) button = (button%noofTPButtons) ? (button%noofTPButtons)+noofTPButtons : 0;
			if (button >= noofTPButtons) button = button%noofTPButtons;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M')
		{
			Column1Chars = 0;
			emeClearMenu();
			etcFont(Arial16);   // IJS 17.11.2009
			pGetItemString = emeTaskString;
			ScrollItemCount = nt;
			emeInitScrollMenu(1);
			if (rt == 'R') strcpy(StrA, &(PMS(se__Select_Rx_))[2]);
			else strcpy(StrA, &(PMS(se__Select_Tx_))[2]);
			strcat(StrA, PMS(se_touchpad____task));
			if (button < 9) {
				StrA[19] = 0x31 + button;
			} else {
				StrA[19] = '1';
				StrA[20] = 0x30 + button - 9;
			}
			etcColourRect(MenuX+1, MenuY+1, MenuX+MenuW-2, MenuY+ScrollSpacing+1, 2);
			etcTextColour(7, 2);
			etcString(MenuX+3, MenuY+1, 'L', StrA);
			emeDrawList(task);
			enGetEncoder7delta();
			refresh = 0;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
				scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					etcFont(Arial16);   // IJS 17.11.2009
					emeUpdateList(task);
					refresh = 0;
				}
				encCount7 = enGetEncoder7delta();
				if (encCount7 != 0)
				{
					MenuTimer = 0;
					task += encCount7;
					if (task < 0) task = (task%nt) ? (task%nt)+nt : 0;
					if (task >= nt) task = task%nt;
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if (kc != 'E') kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if (kc == 'M')
			{
				if (rt == 'R')
				{
					if (buGetTaskAllowed(task, ButtonMode)) RxTouchpadAssignments[button] = task;
					else RxTouchpadAssignments[button] = 0;
					scEEwriteRxTouchpadAssignments();
					if (zg)
					{
						if (button <= 7) geButtonLabelsZtoSRx(0,0);
						else geButtonLabelsLtoRRx(0,0);
					}
				}
				else
				{
					if (buGetTaskAllowed(task, ButtonMode)) TxTouchpadAssignments[button] = task;
					else TxTouchpadAssignments[button] = 0;
					scEEwriteTxTouchpadAssignments();
					if (zg)
					{
						if (button <= 7) geButtonLabelsZtoSTx(0,0);
						else geButtonLabelsLtoRTx(0,0);
					}
				}
			}
			etTouchpadCaptions();
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
}


void emeEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
          uint8_t step, char msg, void (*pAdjust)(uint32_t n)) __attribute__((section(".highmem")));

void emeEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
          uint8_t step, char msg, void (*pAdjust)(uint32_t n))
{
	uint8_t refresh = 1;
	uint8_t k;
	int enc4;
	int encval = 0;
	int32_t v = *val;
	int32_t PreviousVal = *val;
	TuningMode = 'X';
	emeClearMenu();
	etcFont(Arial16);
	etcColourRect(MenuX+1,MenuY+1,MenuX+MenuW-2,MenuY+ScrollSpacing+1,2);
	etcTextColour(7,2);
	etcString(MenuX+MenuW/2,MenuY+2,'C',label);
 	emeWriteEditNumberDirections(msg);

	do {
  		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
		if (refresh == 1) {
			ltoa(v,StrA,10);
			etcFont(Arial20);
			etcTextColour(12,1);
			etcString(MenuX+16,MenuY+94,'L',gbTrailingSpaces(StrA,12));
			refresh = 0;
 			(*pAdjust)(v);
		}				

		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) >= step) {
			v += encval / step;   
			if (v > (int32_t)max) v = max;
			if (v < (int32_t)min) v = min;
	    	encval = 0;
	    	refresh = 1;	  
		}
 		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		k = kyGetKeyChar();
		if (k != 'X') MenuTimer = 0;
	} while ( (k != 'E') && (k != '#') && (k != 'M') );
	if (k == 'M') *val = v; else (*pAdjust)(PreviousVal);  // else put it back !!    
	emeClearMenu();
	TuningMode = 'N';  // Encoder 4 can tune trx again
}


void emeEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
          int8_t step, uint8_t inc, char msg, void (*pAdjust)(uint32_t n)) __attribute__((section(".highmem")));

void emeEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
          int8_t step, uint8_t inc, char msg, void (*pAdjust)(uint32_t n))
{
	uint8_t refresh = 1;
	uint8_t k;
	int enc4;
	int encval = 0;
	int32_t v = *val;
	int32_t prevv = *val;
	int32_t PreviousVal = *val;
	TuningMode = 'X';
	emeClearMenu();
	etcFont(Arial16);
	etcColourRect(MenuX+1,MenuY+1,MenuX+MenuW-2,MenuY+ScrollSpacing+1,2);
	etcTextColour(7,2);
	etcString(MenuX+MenuW/2,MenuY+2,'C',label);
 	emeWriteEditNumberDirections(msg);

	do {
	  	scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
		if (refresh == 1) {
			ltoa(v,StrA,10);
			etcFont(Arial20);
			etcTextColour(12,1);
			etcString(MenuX+16,MenuY+94,'L',gbTrailingSpaces(StrA,12));
			refresh = 0;
 			(*pAdjust)(v);
		}				

		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) >= step) {
			v += inc*(encval / step);
			if ( (prevv == (int32_t)def) && (v > (int32_t)def) && (v < (int32_t)min) ) v = min;
			if (v > (int32_t)max) v = max;
			if (v < (int32_t)min) v = min;
			prevv = v;
			encval = 0;
			refresh = 1;	  
		} 
 		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		k = kyGetKeyChar(); 
		if (k != 'X') MenuTimer = 0;
	} while ( (k != 'E') && (k != '#') && (k != 'M') );
	if (k == 'M') {*val = v;} else {(*pAdjust)(PreviousVal);}  // else put it back !!    
	emeClearMenu();
	TuningMode = 'N';  // Encoder 4 can tune trx again
}


void emeAdjustDisplayBrightness(uint32_t v)  // FUNCTION POINTER TARGET - must be < 128k
{
  scSetDisplayLEDPWM((uint8_t)v);
}	 


void emeTouchpadCal() __attribute__((section(".highmem")));
void emeTouchpadCal()
{
	if (Transmit == 1) {return;}
	etcTouchCal();
}



void emeEditDisplayBright() __attribute__((section(".highmem")));
void emeEditDisplayBright()
{
	if (Transmit == 1) {return;}
	uint32_t v = DDSparams.dpDisplayBright;
	strcpy(StrA, PMS(se_Set_bright_display));
	emeEditNumber(&v, StrA, 0,255, 20, 'B', emeAdjustDisplayBrightness);
	if (v != DDSparams.dpDisplayBright)
	{
		DDSparams.dpDisplayBright = v;
		scEEwriteDDSparams();
	}	      
	scSetDisplayLevel();
}



void emeEditDisplayDimmed() __attribute__((section(".highmem")));
void emeEditDisplayDimmed()
{
	if (Transmit == 1) {return;}
	uint32_t v = DDSparams.dpDisplayDimmed;
	strcpy(StrA, PMS(se_Set_dimmed_display));
	emeEditNumber(&v, StrA, 0,255, 20, 'B', emeAdjustDisplayBrightness);
	if (v != DDSparams.dpDisplayDimmed)
	{
		DDSparams.dpDisplayDimmed = v;
		scEEwriteDDSparams();
	}	    
	scSetDisplayLevel();
}





void emeAdjustNothing(uint32_t v)     // FUNCTION POINTER TARGET - must be < 128k
{
}


void emeEditAutodimSeconds() __attribute__((section(".highmem")));
void emeEditAutodimSeconds()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpAutoDimSeconds;
	strcpy(StrA, PMS(se_Auto_dim_seconds));
	emeEditNumberDef(&v, StrA, 10, 255, 0, 20,1, 'S', emeAdjustNothing);
	if (v != DDSparams.dpAutoDimSeconds)
	{
		DDSparams.dpAutoDimSeconds = v;
	    scEEwriteDDSparams();
		AutoDimmed = 0;
		AutoDimTimer = 254;
	}	    
}


void emeEditMenuTimeout() __attribute__((section(".highmem")));
void emeEditMenuTimeout()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpMenuTimeout;
	strcpy(StrA, PMS(se_Menu_timeout));
	emeEditNumberDef(&v, StrA, 5, 60, 0, 20, 1, 'S', emeAdjustNothing);
	if (v != DDSparams.dpMenuTimeout)
	{
		DDSparams.dpMenuTimeout = v;
	    scEEwriteDDSparams();
		MenuTimer = 0;
	    if (DDSparams.dpMenuTimeout > 4) MenuFlag = 1; else MenuFlag = 0;
	}	    
}


void emeEditMoxTimeout() __attribute__((section(".highmem")));
void emeEditMoxTimeout()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpMoxTimeout;
	strcpy(StrA, PMS(se_MOX_timeout));
	emeEditNumberDef(&v, StrA, 5, 600, 0, 20, 1, 'S', emeAdjustNothing);
	if (v != DDSparams.dpMoxTimeout)
	{
		DDSparams.dpMoxTimeout = v;
	  scEEwriteDDSparams();
		MoxTimer = 0;
	}	    
}

void emeEditLocalTimeOffset() __attribute__((section(".highmem")));
void emeEditLocalTimeOffset()
{
	if (Transmit == 1) {return;}
	int32_t v = 5*(int8_t)LocalTimeOffset;
	strcpy(StrA, PMS(se_Edit_local_time_offset));
	emeEditNumberDef(&v, StrA, -120, +120, 0, 20, 5, 'T', emeAdjustNothing);
	if (v != LocalTimeOffset)
	{
	  LocalTimeOffset = v/5;
		ie_eeprom_write_block(&LocalTimeOffset, &ee.EE_LocalTimeOffset, 1);
		rtcDoDateTime();
	}	    
}



void emeAdjustDDSclock(uint32_t f)    // FUNCTION POINTER TARGET - must be < 128k
{
  fDDSclock = f;
  ddsUpdateDDSclock(0); // 0  = dont save 
}



void emeEditDDSclock() __attribute__((section(".highmem")));
void emeEditDDSclock()
{
	if (Transmit==1){return;};
	uint32_t fDDSclockPrevious = fDDSclock;
	uint32_t fc = fDDSclock;
	strcpy(StrA, PMS(se_Set_DDS_clock_freq_));
  emeEditNumber(&fc, StrA, 1000000,800000000, 1, 'D', emeAdjustDDSclock);
  if (fDDSclockPrevious!=fc)
	{
      fDDSclock = fc;
			ddsUpdateDDSclock(1);   //   1  =  save it
	}	    
}



void emeAdjustLSBoffset(uint32_t f)     // FUNCTION POINTER TARGET - must be < 128k
{
  Freq = f;
  ddsSetFreq(); 
}


void emeEditLSBoffset() __attribute__((section(".highmem")));
void emeEditLSBoffset()
{
	if (Transmit==1){return;};
	Mode = 0;   // LSB
	scChangeMode();
	SigGenMode = 1;
	uint32_t OldFreq = Freq;
	uint32_t LSBoffsetPrevious = LSBoffset;
	uint32_t fof = LSBoffset;
	strcpy(StrA, PMS(se_Set_LSB_offset));
  emeEditNumber(&fof, StrA, 1000000,800000000, 1, 'L', emeAdjustLSBoffset);
  Freq = OldFreq;
	if (LSBoffsetPrevious!=fof)
	{
      LSBoffset = fof;
			ddsUpdateLSBoffset(1);   //   1  =  save it
	}	    
	SigGenMode = 0;
}



void emeAdjustUSBoffset(uint32_t f)     // FUNCTION POINTER TARGET - must be < 128k
{
  Freq = f;
  ddsSetFreq(); // 0  = dont save 
}


void emeEditUSBoffset() __attribute__((section(".highmem")));
void emeEditUSBoffset()
{
	if (Transmit==1){return;};
	Mode = 1;   // USB
	scChangeMode();
	SigGenMode = 1;
	uint32_t OldFreq = Freq;
	uint32_t USBoffsetPrevious = USBoffset;
	uint32_t fof = USBoffset;
	strcpy(StrA, PMS(se_Set_USB_offset));
  emeEditNumber(&fof, StrA, 1000000,800000000, 1, 'U', emeAdjustUSBoffset);
  Freq = OldFreq;
	if (USBoffsetPrevious!=fof)
	{
    USBoffset = fof;
		ddsUpdateUSBoffset(1);   //   1  =  save it
	}	    
  SigGenMode = 0;
}



char* emeEncoderAssignString(uint8_t index)     // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t e = index;

	if (e >= 8)
	{
		e -= 8;
		strcpy(StrA, "Pot");
		StrA[3] = 0x41 + e;
	}
	else
	{
		strcpy(StrA, "Enc");
		StrA[3] = 0x31 + index;
	}
	StrA[4] = 0x20;
	StrA[5] = 0x20;
	StrA[6] = 0x20;
	StrA[7] = 0;
	uint8_t userno = EncodersPotsParams[index];
	uint8_t starno = dspUserToStar(userno);
	if (userno == 99)
	{
		strcpy(StrB, pmdSpaces(6));
	}
	else
	{
	//	ltoa(userno, StrB, 10);
		uint8_t d = userno % 10;
		uint8_t n = userno / 10;
		StrB[0] = 0x20;  //space
		StrB[1] = 0x20;  //space
		StrB[2] = n + 0x30;
		StrB[3] = '.';
		StrB[4] = d + 0x30;
		StrB[5] = 0x20;  // space
		StrB[6] = 0;
	}
	strcat(StrA, StrB);
	strcat(StrA, pmParamNameShortNL(starno));
	return StrA;
}


char* emeEncoderParamString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t userno = pmSeqToUserNo(i);
	if (userno == 99)
	{
		strcpy(StrA, PMS(se____no_param_assigned));
	}
	else
	{
		uint8_t starno = dspUserToStar(userno);
		uint8_t d = userno % 10;
		uint8_t n = userno / 10;
		StrA[0] = n + 0x30;
		StrA[1] = '.';
		StrA[2] = d + 0x30;
		StrA[3] = 0x20;
		StrA[4] = 0x20;
		StrA[5] = 0x20;
		StrA[6] = 0x20;
		StrA[7] = 0;
		strcat(StrA, pmParamNameNL(starno));
	}
	return StrA;
}


void emeEncoderAssign(uint8_t ch) __attribute__((section(".highmem")));
void emeEncoderAssign(uint8_t ch)
{
	int de;
	int e = LastEncoderSetting;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 0;
	uint8_t restart = 1;
	uint8_t EncNo = 0;
	//uint8_t starno = 0;
	uint8_t userno = 0;
	uint8_t noofmenus;

	if (ch != 0) noofmenus = 8; else noofmenus = 10;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			etcFont(Arial16);   // IJS 15.11.2009
			Column1Chars = 7;
			Column1Colour = 12;
			Column2X = 30;
			emeClearMenu();
			pGetItemString = emeEncoderAssignString;
			ScrollItemCount = noofmenus;
			emeInitScrollMenu(1);
			etcColourRect(MenuX+1, MenuY+1, MenuX+MenuW-2, MenuY+ScrollSpacing+1, 2);
			etcTextColour(7, 2);
			if (ch != 0) strcpy(StrA, PMS(se___Select_encoder));
			else strcpy(StrA, PMS(se___Select_encoder_or_pot));
			etcString(MenuX+3, MenuY+1, 'L', StrA);
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			emeDrawList(e);
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			etcFont(Arial16);   // IJS 15.11.2009
			emeUpdateList(e);
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			//starno = dspUserToStar(userno);
			refresh = 0;
		}
		if (uaCheckEncoders8(&nenc, &delta, &updown, 0) != 0)
		{
			encCount7 = enGetEncoder7delta();
			if (encCount7 != 0)
			{
				MenuTimer = 0;
				e += encCount7;
				if (e < 0) e = (e%noofmenus) ? (e%noofmenus)+noofmenus: 0;
				if (e >= noofmenus) e = e%noofmenus;
				refresh = 1;
				if (WakeupDisplay) scWakeupDisplay();
			}
			kc = tpGetTouchChar();
			if ((kc != 'E') && (kc != ch)) kc = scDoMenuKeyPad();
			if (kc != 'X') MenuTimer = 0;
		}
		else
		{
			MenuTimer = 0;
			e = nenc;
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			//starno = dspUserToStar(userno);
			kc = 'M';
		}
		if ((kc == 'M') || (kc == ch))
		{
			emeClearMenu();
			etcFont(Arial16);   // IJS 15.11.2009
			Column1Chars = 6;
			Column1Colour = 12;
			Column2X = 20;
			pGetItemString = emeEncoderParamString;
			ScrollItemCount = 48;
			emeInitScrollMenu(1);
			if (e < 8)
			{
				strcpy(StrA, PMS(se_Encoder___set_parameter));
				StrA[8] = e + 0x31;
			}
			else
			{
				strcpy(StrA, PMS(se_Pot___set_parameter));
				StrA[4] = e + 0x39;
			}
			etcColourRect(MenuX+1, MenuY+1, MenuX+MenuW-2, MenuY+ScrollSpacing+1, 2);
			etcTextColour(7, 2);
			etcString(MenuX+3, MenuY+1, 'L', StrA);
			//starno = dspUserToStar(userno);
			emeDrawList(pmUsernoToSeq(userno));
			enGetEncoder7delta();
			refresh=1;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;
				scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					etcFont(Arial16);   // IJS 15.11.2009
					//starno = dspUserToStar(userno);
					emeUpdateList(pmUsernoToSeq(userno));
					refresh = 0;
				}
				de = 0;
				if (uaCheckEncoders8(&nenc, &delta, &updown, 0) != 0) {
					encCount7 = enGetEncoder7delta();
					if (encCount7 != 0) de = encCount7;
				} else {
					if (e == nenc) {
						if (updown == 1) {
							if (HardwareSettings.hsMenuEncoder == 0) de = -delta; else de = delta;
						} else {
							if (HardwareSettings.hsMenuEncoder == 0) de = delta; else de = -delta;
						}
					}
				}
				if (de != 0) {
					MenuTimer = 0;
					userno = pmUserNoListShift(userno, de, 1);   // 1 = Allow unassigned
					//if (userno == 0) starno = 0;
					//else starno = dspUserToStar(userno);
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if ((kc != 'E') && (kc != ch)) kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if ((kc == 'M') || (kc == ch))
			{
				EncodersPotsParams[EncNo] = userno;
				scEEwriteEncodersPotsParams();
				enSetEncodersMaxMin();
				if (EncNo < 8) LastEncoderSetting = EncNo;
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 0;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
}


void emeLastEncoderAssign() __attribute__((section(".highmem")));
void emeLastEncoderAssign()
{
	int de;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	//uint8_t starno = 0;
	uint8_t userno = 0;
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	MenuW = MenuWstandard;
	etcFont(Arial16);
	emeClearMenu();
	Column1Chars = 6;
	Column1Colour = 12;
	Column2X = 20;
	pGetItemString = emeEncoderParamString;
	ScrollItemCount = 48;
	emeInitScrollMenu(1);
	strcpy(StrA, PMS(se_Encoder___set_parameter));
	StrA[8] = LastEncoderSetting + 0x31;
	etcColourRect(MenuX + 1, MenuY + 1, MenuX + MenuW - 2, MenuY + ScrollSpacing + 1, 2);
	etcTextColour(7, 2);
	etcString(MenuX + 3, MenuY + 1, 'L', StrA);
	userno = EncodersPotsParams[LastEncoderSetting];
	//starno = dspUserToStar(userno);
	emeDrawList(pmUsernoToSeq(userno));
	enGetEncoder7delta();
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2))
		{
			DisplayingMenu = 0;
			MenuFlag = 0;
			MenuTimer = 0;
			MenuExit = 1;
			emeDeleteMenu();
			zscRestoreLeftDisplay();
			if (DisplaySwitch == 2) dspStartDSPdisplayEATFT();
			else zscShowDSPKeys();
			Encoder4count = 0;
			do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
			return;
		}
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (refresh == 1)
		{
			etcFont(Arial16);
			//starno = dspUserToStar(userno);
			emeUpdateList(pmUsernoToSeq(userno));
			refresh = 0;
		}
		de = 0;
		do
		{
			n = uaCheckEncoders8(&nenc, &delta, &updown, 0);
			if ( (n == 0) && (nenc == LastEncoderSetting) ) {
				if (updown == 1) {
					if (HardwareSettings.hsMenuEncoder == 0) de -= delta; else de += delta;
				} else {
					if (HardwareSettings.hsMenuEncoder == 0) de += delta; else de -= delta;
				}
			}
		} while ( (n == 0) || (n == 3) );
		if ( (de == 0) && ((encCount7 = enGetEncoder7delta()) != 0) ) de = encCount7;
		if (de != 0)
		{
			MenuTimer = 0;
			userno = pmUserNoListShift(userno, de, 1);   // 1 = Allow unassigned
			//if (userno == 0) {starno = 0;}
			//else {starno = dspUserToStar(userno);}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') {kc = scDoMenuKeyPad();}
	} while (kc == 'X');
	MenuTimer = 0;
	if (kc == 'M')
	{
		EncodersPotsParams[LastEncoderSetting] = userno;
		scEEwriteEncodersPotsParams();
		enSetEncodersMaxMin(); 
	}
	kc = 'X';
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	emeDeleteMenu();
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2) dspStartDSPdisplayEATFT();
	else zscShowDSPKeys();
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}


void emeParamsRedrawExternal() __attribute__((section(".highmem")));
void emeParamsRedrawExternal()
{
	keypress = 1;  // list redraw rather thean update
	refresh = 1;
	adjusting = 0; // full list and not just highlighted item
}




// called by moving menu encoder oy keying 8 as Picastar
void emeParamSettings() __attribute__((section(".highmem")));  
void emeParamSettings()  
{
	int ec, enc4, encval, paramval;// previousval;
	uint8_t max, min, colour, starno, userno, n;
	char kc;

	//previousval = 0;
	encval = 0;
	paramval = 0;
	starno = 0;
	colour = 0;
	n = 8;  // unnecessary initialisation
	keypress = 1; // always redraw on keypress, update on encoder 
	refresh = 1;
	userno = ParamGroupItem[ParamGroup];

	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	MenuW = MenuWstandard;
	ParamSetting = 1;
/////  Graphics menu initialise ///////////
	if (DisplaySwitch==2){HaltDSPdisplay=1;}
	emeMenuFrame();  // clears a hole in DSP display mode
	emeInfoFrame();
	Column1Chars = 6;
	Column1Colour = 12;
	Column2X = 22;
	ScrollItemCount = 47;
	emeInitScrollMenu(1);
	strcpy(StrA,PMS(se_DSP_parameter_setting));
	etcColourRect(MenuX+1,MenuY+1,MenuX+MenuW-2,MenuY+ScrollSpacing+1,2);
	etcFont(Arial16);
	etcTextColour(7,2);
	etcString(MenuX+6,MenuY+1,'L',StrA);
	pGetItemString = emeParamMenuString;
////////////////////////////////

	starno = dspUserToStar(userno);
	emeDrawList(pmUsernoToSeq(userno));
	TuningMode = 'X'; // stop Encoder4 tuning
	adjusting = 0;
	do {
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		scTrChangeDisplays();
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (refresh == 1) {
			etcFont(Arial16);
			colour = ParamColour;  // current colour - may be changed by dspGetParamValue();
			if (254 == dspGetParam254Value(dspUserToStar(userno))) colour = pgreen;  // set to green if 254
			emeDisplayParamNameAndVal(userno, adjusting, colour, keypress);
			starno = dspUserToStar(userno);
			dspSetLed(colour);
			refresh = 0;
			adjusting = 1;
			keypress = 0;
		}
		if (emeCheckForEncodersPots()) break;  // check if pots or encoders8 twiddled
		ec = enGetEncoder7delta();
		if (WakeupDisplay) scWakeupDisplay();
		if (ec != 0) {
			MenuTimer = 0;
			userno = pmUserNoListShift(userno, ec, 0);  // 0 = do not allow unassigned
			starno = dspUserToStar(userno);
			ParamGroup = userno/10;
			ParamGroupItem[ParamGroup] = userno;
			encval=0;
			refresh = 1;
			adjusting = 0;
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == '*') {
			if (ParamColour != pgreen) {  // green set not involved
				if (colour == pgreen) {   // value taken from green set - so doesn't have a value of its own
					paramval = dspGetGreenParamValue(starno);
					dspSetParam(starno, paramval);  // save the current value to the param set
					dspSetLed(ParamColour);
				} else {
					dspSetParam(starno, 254); // has its own value - overwrite with 254
					dspSetLed(pgreen);        //                   - so will report green value
				}
			}
			if (starno == 21) Muted = 0;
			if ((starno >= 61) && (starno <= 66)) zscShowFilter();
			encval = 0;
			refresh = 1;
		}
		if ((kc >= '0') && (kc <= '9')) {
			if (kc != '0') {
				keypress = 1;
				n = kc-0x30;  /// group number   eg: 2 for 2.1 = AF gain
				userno = ParamGroupItem[n];
				if (n == ParamGroup) {
					userno++;
					starno = dspUserToStar(userno);
					// use list to check for passing top of group
					if (pmListIndexFromParamNo(starno) == 255) userno--;
				}
			} else {
				userno = ParamGroupItem[ParamGroup];
				if ((userno%10) > 1) userno--;
			}
			starno = dspUserToStar(userno);
			ParamGroup = n;
			ParamGroupItem[ParamGroup] = userno;
			encval = 0;
			refresh = 1;
			adjusting = 0;
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) > 29) {
			colour = ParamColour; // current colour - may be changes by dspGetParamValue();
			max = dspGetMax(starno);
			min = dspGetMin(starno);
			paramval = dspGetParamValue(starno);
			dspSetLed(colour);
			//previousval = paramval;
			paramval += encval/30;   // about 7 increments per rev as in Picastar
			if (paramval > max) paramval = max;
			if (paramval < min) paramval = min;
			if (starno == 81) dspStoreTxDrive(paramval); else dspSetParam(starno,paramval);
			if (starno == 21) Muted = 0;
			if ((starno >= 61) && (starno <= 66)) zscShowFilter();
			switch (starno) {
				case 11:
				case 32:
				case 51:
				case 43:
				case 91:
				case 93: zscShowSwitches();
			}
			encval = 0;
			refresh = 1;
		}
	} while ((kc != 'E') && (kc != '#'));  //&&(meCheckForEncodersPots()==0));

	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	TuningMode = 'N';  // Encoder 4 can tune trx again
	emeDeleteInfo();
	emeDeleteMenu();
	dspSetLed(ParamColour);
	zscShowFilter();
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2) 
	dspStartDSPdisplayEATFT();
	else
	{
	  zscShowDSPKeys();
		emeDrawDateTime();
  }
	ParamSetting = 0;
	Encoder4count = 0;
	return;
}


uint8_t emeCheckForEncodersPots() __attribute__((section(".highmem")));
uint8_t emeCheckForEncodersPots()
{
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t enc8, pots;
	
	enc8 = uaCheckEncoders8(&nenc, &delta, &updown, 1);
	if ((pots = adCheckPots(&nenc, &delta, &updown)) == 0) PotsFlag = 1;
	if ((enc8 == 0) || (pots == 0)) return 1; else return 0;
}


void emeDisplayParamNameAndVal(uint8_t userno, 
           uint8_t adjusting, uint8_t colour, uint8_t keypress) __attribute__((section(".highmem")));

void emeDisplayParamNameAndVal(uint8_t userno, 
           uint8_t adjusting, uint8_t colour, uint8_t keypress)
{
	uint8_t d, n, starno, MenuIndex;

	starno = dspUserToStar(userno);
	MenuIndex = pmUsernoToSeq(userno);
	if (adjusting == 0) {
		if (keypress == 1) emeDrawList(MenuIndex);
		else emeUpdateList(MenuIndex);
	} else emeDrawHighlightedItem(MenuIndex);
	etcFont(Arial18);
	if (adjusting == 0) {
		emeClearInfo();
		d = userno % 10;
		n = userno / 10;
		StrA[0] = n + 0x30;
		StrA[1] = '.';
		StrA[2] = d + 0x30;
		StrA[3] = 0x20;
		StrA[4] = 0x20;
		StrA[5] = 0;
		etcTextColour(12, 1);
		etcString(InfoX+6, InfoY+17, 'L', StrA);
		strcpy(StrA, pmParamNameNL(starno));
		etcTextColour(10, 1);
		etcString(InfoX+32, InfoY+17, 'L', StrA);
	} else emeClearInfoLower();
	strcpy(StrA, dspParamValString(starno, 1));
	strcat(StrA, pmdSpaces(1));
	strcat(StrA, pmUnitsFromListIndex(pmParamNameIndexNL(starno)));
	if (colour == pyellow) etcTextColour(7, 1);
	else if (colour == pred) etcTextColour(3, 1);
	else etcTextColour(4, 1);
	etcString(InfoX+20, InfoY+44, 'L', StrA);					
}


char* emeParamMenuString(uint8_t i)   // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t userno = pmSeqToUserNo(i);
	uint8_t starno = dspUserToStar(userno);
	uint8_t d = userno%10;
	uint8_t n = userno/10;
	StrA[0]=n+0x30;
	StrA[1]='.';
	StrA[2]=d+0x30;
	StrA[3]=0x20;
	StrA[4]=0x20;
	StrA[5]=0x20;
	StrA[6]=0;
	strcat(StrA,pmParamNameShortNL(starno));
	strcpy(StrB,dspParamValString(starno,1));
	strcat(StrB,pmUnitsFromListIndex(pmParamNameIndexNL(starno)));
	strcat(StrA,pmdSpaces(1));
  strcat(StrA,StrB);
  return StrA;
}

/////////END params /////////////////////////////////////

void emeWriteEditNumberDirections(char wot) __attribute__((section(".highmem")));
void emeWriteEditNumberDirections(char wot)
{
	etcFont(Arial16);
	etcTextColour(10,1);
	switch(wot)
	{
		case 'L':
		{
			strcpy(StrA,PMS(se_This_operates_as_DDS37_));
			strcat(StrA,PMS(se_in_signal_generator_mode__));
			strcat(StrA,PMS(se_Refer_to_Picastar_manual_));
			break;
		}
		case 'U':
		{
			strcpy(StrA,PMS(se_This_operates_as_DDS31_));
			strcat(StrA,PMS(se_in_signal_generator_mode__));
			strcat(StrA,PMS(se_Refer_to_Picastar_manual_));
			break;
		}
		case 'D':
		{
			strcpy(StrA,PMS(se_Unlike_DDS_33__this_does_));
			strcat(StrA,PMS(se_not_use_sig_gen_mode__));
			strcat(StrA,PMS(se_Calibrate_by_tuning_to_an_));
			strcat(StrA,PMS(se_accurate_known_signal_));
			break;
		}
		case 'B':
		{
			strcpy(StrA,PMS(se_Set_the_brightness_with_));
			strcat(StrA,PMS(se_the_tuning_encoder_));
			break;
		}
		case 'S':
		{
			break;
		}
		case 'T':
		{
			strcpy(StrA,PMS(se_pom_hours_x_10_displayed_));
			strcat(StrA,PMS(se_Set_with_tuning_encoder__));
			strcat(StrA,PMS(se_Range_is__120_to__120_));
			break;
		}
		}
	etcString(MenuX+5,MenuY+26,'L',StrA);
	etcTextColour(4,1);
	strcpy(StrA,PMS(se_Menu_to_accept__ESC_to_abort_));
	etcString(MenuX+16,MenuY+121,'L',StrA);
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////   SLOTS and STACKS ////////////////////




char* emeSlotMenuString(uint8_t Index)   // FUNCTION POINTER TARGET - must be < 128k
{
	strcpy_P(pmStrBuf,(PGM_P)&epmdSlotMenuList[Index]);
  return &pmStrBuf[0];
} 







void emeSlotMenu() __attribute__((section(".highmem")));
void emeSlotMenu()
{
	int m = 0;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t noofslots = 3;

	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	MenuW = 305;   // wide menu for slot data
	do
	{
		ScrollItemCount = noofslots;
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart==1)
		{
		/////  Graphics menu initialise ///////////
			etcFont(Arial16);
			Column1Chars = 0;
			emeClearMenu();
			pGetItemString = emeSlotMenuString;
			emeInitScrollMenu(2);  
			etcColourRect(MenuX+1,MenuY+1,MenuX+MenuW-2,MenuY+ScrollSpacing+1,2);
			etcTextColour(7,2);
			strcpy(StrA,PMS(se_Stacks_and_Slots_menu));
			etcString(MenuX+3,MenuY+1,'L',StrA);
			emeDrawList(2);
			etcTextColour(14,1);
			strcpy(StrA,PMS(se_Press_Stacks_to_select_stack_type__));
			etcString(MenuX+5,MenuY+116,'L',StrA);
			strcpy(StrA,PMS(se_Then_press_Stacks_again_to_go_to_slot_));
			etcString(MenuX+5,MenuY+138,'L',StrA);
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh==1)
		{
			etcFont(Arial16);
			emeDrawList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			m += encCount7;
			if (m<0){m=(m%noofslots)?(m%noofslots)+noofslots:0;}
			if (m>=noofslots){m=m%noofslots;}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = kyGetKeyChar();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'S')   /// S is stacks key
		{
			etcFont(Arial16);
			emeClearMenu();
			kc = emeSlotListMenu(m);  //  0 = mem,  1 = vfo,   2 = ban
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));  // 'E' is ESC key
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	emeDeleteMenu();
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2) 
	dspStartDSPdisplayEATFT();
	else
	{ 
	  zscShowDSPKeys();
		emeDrawDateTime();
  }
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}



char* emeSlotInfo() __attribute__((section(".highmem")));
char* emeSlotInfo()
{
	uint8_t e,i;
	ltoa(RamSlot.stFreq,StrB,10);
	if (strlen(StrB)<8){e=0;}else{e=1;}
	for(i=0;i<=2;i++)
	{
	  StrB[9-i] = StrB[6-i+e];
	}
	StrB[6] = '.';
	for(i=3;i<=5;i++)
	{
	  StrB[8-i] = StrB[6-i+e];
	}
	StrB[2] = '.';
	if (e==0)
	{
		StrB[1]= StrB[0];
		StrB[0] = ' ';
	};
	StrB[10]=' ';
	StrB[11]=0;
	if (e==0)
	{
		for(i=0;i<=11;i++){StrB[12-i]=StrB[11-i];};
		StrB[0]=' ';
	}
	strcat(StrB,pmdSpaces(2));
	strcat(StrB,pmModeName(RamSlot.stMode));
	strcat(StrB,pmdSpaces(2));
	if (RamSlot.stIP3==1){strcat(StrB,PMS(se_IP3));}else{strcat(StrB,PMS(se_NF));};
	strcat(StrB,pmdSpaces(2));
	switch(RamSlot.stParamColour)
	{
		case 1: strcat(StrB,PMS(se_Green_)); Column1Colour=4; break;
		case 2: strcat(StrB,PMS(se_Yellow)); Column1Colour=7; break;
		case 3: strcat(StrB,PMS(se_Red___)); Column1Colour=3; break;
	}
	strcat(StrB,pmdSpaces(2));
	if (RamSlot.stFilterNarrow==1)
	{
		if (RamSlot.stMode < 2){strcat(StrB,PMS(se_narrow));} else {strcat(StrB,PMS(se_6162));};
	}
	else
	{
		if (RamSlot.stMode < 2){strcat(StrB,PMS(se_wide));} else {strcat(StrB,PMS(se_context));};
	};
	
	return StrB;
}



char* emeMemSlotMenuString(uint8_t i)   // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t stack;
	uint8_t slot;
	if (i<24)
	{
		stack = i/6;
		slot =  i%6;
		ddsLoadMemSlotToRamSlot(stack,slot);		
		stack += 7;
		if (stack==10){stack=0;};
		strcpy(StrA,PMS(se_6x_6x__));
		StrA[1] = 0x30+stack;
		StrA[4] = 0x31+slot;
		strcat(StrA,pmdSpaces(5)); 
		strcat(StrA,emeSlotInfo());
	}	
	return StrA;			  
}



char* emeVfoSlotMenuString(uint8_t i)   // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t n = i;
	if (n==0)
	{
		ddsLoadStickyVfoSlotToRamSlot(0);
		strcpy(StrA,PMS(se_Poweron__));
		strcat(StrA,pmdSpaces(5)); 
		strcat(StrA,emeSlotInfo());
	}
	if ((n>=1)&&(n<=7))
	{
		ddsLoadStickyVfoSlotToRamSlot(n);
		strcpy(StrA,PMS(se_Sticky____));
		StrA[7] = 0x30+n;
		strcat(StrA,pmdSpaces(5)); 
		strcat(StrA,emeSlotInfo());
	}
	if ((i>=8)&&(i<=30))
	{
		n -=8;
		if (n<VolatileCount)
		{
			ddsLoadVolatileVfoSlotToRamSlot(n);
		}
		n += 1;  //  slots 0-22 shown as 1-23
		strcpy(StrA,PMS(se_Volat_____));
		StrA[6] = 0x30 + n/10;
		StrA[7] = 0x30 + n%10;
		strcat(StrA,pmdSpaces(5)); 
		if (n<VolatileCount)
		{
			strcat(StrA,emeSlotInfo());
		}
		else
		{
			strcat(StrA,pmdSpaces(5)); 
			strcat(StrA,PMS(se_Slot_not_defined));
			Column1Colour = 11;
		}
	}
	return StrA;
}



char* emeBandSlotMenuString(uint8_t i)   // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t band, t;
	char LSC = 'X';
	band = i%10;
	t = i/10;
	switch(t)
	{
	  case 0: LSC = 'L'; strcpy(StrB,PMS(se__Last_)); break;
		case 1: LSC = 'S'; strcpy(StrB,PMS(se__SSB__)); break;
		case 2: LSC = 'C'; strcpy(StrB,PMS(se__CW___)); break;
	}
	ddsLoadBandSlotToRamSlot(LSC,band);
	strcpy(StrA,pmBandName(band));
	strcat(StrA,StrB);
	strcat(StrA,pmdSpaces(5)); 
	
	if (band==2)
	{
		strcat(StrA,PMS(se_10_hyphens));
		Column1Colour = 11;
	}
	else
	{
		strcat(StrA,emeSlotInfo());
	};		
	return StrA;
}




uint8_t emeGotoSlot(uint8_t slotkind, uint8_t m) __attribute__((section(".highmem")));
uint8_t emeGotoSlot(uint8_t slotkind, uint8_t m)
{
	switch(slotkind)
	{
		case 0:
		{
			MemStackNo = m/6;
			MemSlotNo =  m%6;
			ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);	
			ddsApplyVfo(VFO);
			UpdateDDS = 1;
			Encoder4count = 0;		
			zscShowMemStackSlotNo();
			break;
		}
		case 1:
		{
			return 0;// no volatile access here
			break;
		}
		case 2:
		{
			uint8_t b = m%10;   // band
			if (b==2){return 0; break;};   // no 60m slot data
			uint8_t t = m/10;
			char LSC = 'L';  // dummy value
			switch(t)
			{
	  		case 0: LSC = 'L'; break;
				case 1: LSC = 'S'; break;
				case 2: LSC = 'C'; break;
			}
			ddsLoadBandSlot(VFO,LSC,b); 
			ddsApplyVfo(VFO);
		  UpdateDDS = 1;
//			ddsSaveBandSlot(VFO,'L',Band);
			break;
		}
	}
	return 1;
}


char emeSlotListMenu(uint8_t slotkind) __attribute__((section(".highmem")));
char emeSlotListMenu(uint8_t slotkind)
{
	int m = 0;
	int encCount7;
	char kc;
	uint8_t refresh = 0;
	uint8_t restart = 1;
	
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2))
		{
			Encoder4count = 0;
			return 'E';
		}
		scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart==1)
		{
			emeClearMenu();
			switch(slotkind)
			{
				case 0:
				{
					pGetItemString = emeMemSlotMenuString;
					ScrollItemCount = 24;
					Column1Chars = 11;
					Column1Colour = 11;  //dummy
					Column2X = 44;
					break;
				}
				case 1:
				{
					pGetItemString = emeVfoSlotMenuString;
					ScrollItemCount = 31;
					ScrollItemCount = 24;
					Column1Chars = 15;
					Column1Colour = 11;  //dummy
					Column2X = 60;
					break;
				}
				case 2:
				{
					pGetItemString = emeBandSlotMenuString;
					ScrollItemCount = 30;
					Column1Chars = 13;
					Column1Colour = 11;  // dummy
					Column2X = 60;
					break;
				}
			}
			switch(slotkind)
			{
				case 0:	strcpy(StrA,PMS(se__Memory_slots)); break;
				case 1:	strcpy(StrA,PMS(se__VFO_slots)); break;
				case 2:	strcpy(StrA,PMS(se__Band_slots)); break;
			}
			emeClearMenu();
			emeInitScrollMenu(1);
			etcColourRect(MenuX+1,MenuY+1,MenuX+MenuW-2,MenuY+ScrollSpacing+1,2);
			etcFont(Arial16);
			etcTextColour(7,2);
			etcString(MenuX+3,MenuY+1,'L',StrA);
			emeDrawList(1);
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh==1)
		{
			etcFont(Arial16);
			emeUpdateList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7!=0)
		{
			MenuTimer = 0;
			m += encCount7;
			if (m<0){m=(m%ScrollItemCount)?(m%ScrollItemCount)+ScrollItemCount:0;}
			if (m>=ScrollItemCount){m=m%ScrollItemCount;}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc=scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'S')   /// S is stacks key
		{
			if (slotkind!=1)  // no VFO slot access
			{
				if (emeGotoSlot(slotkind,m)==1){return 'E';}  // cause exit from  parent menu
			}
			kc = 'X';
		}
	} while((kc!='E')&&(kc!='#'));  // 'E' is ESC key
	emeDeleteMenu();
	Encoder4count = 0;
	return 'X';
}
