/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEATFTcommands.c    program file
 
 EA eDIPTFT43-ATP  intelligent 480 x 272 intelligent TFT colour display
 
 C routines executing display ESC sequences
   
*/


#include "taGlobal.h"
#include "taEATFTdriver.h"
#include "taStarControl.h"
#include "taEATFTcommands.h"
#include "taTWI.h"

#define DC1 0x11
#define DC2 0x12
#define ACK 6
#define URMAXTRIES 50


static char dstr[80];
static char ps[10];

static const char s_eFT_[] PROGMEM = "#FT";
static const char s_eTW_[] PROGMEM = "#TW";
static const char s_eTA[]  PROGMEM = "#TA;";
static const char s_eTE[]  PROGMEM = "#TE;";
static const char s_eTC_[] PROGMEM = "#TC";
static const char s_eTP_[] PROGMEM = "#TP";

static const char s_eFD_[] PROGMEM = "#FD";
static const char s_eGR_[] PROGMEM = "#GR";
static const char s_eGD_[] PROGMEM = "#GD";
static const char s_eGW_[] PROGMEM = "#GW";
static const char s_eGP_[] PROGMEM = "#GP";
static const char s_eGZ_[] PROGMEM = "#GZ";
static const char s_eGM_[] PROGMEM = "#GM";
static const char s_eFG_[] PROGMEM = "#FG";
static const char s_eDL[]  PROGMEM = "#DL;";
static const char s_eDS[]  PROGMEM = "#DS;";
static const char s_eDF_[] PROGMEM = "#DF";
static const char s_eFZ_[] PROGMEM = "#FZ";
static const char s_eZF_[] PROGMEM = "#ZF";
static const char s_eZZ_[] PROGMEM = "#ZZ";
static const char s_eZY_[] PROGMEM = "#ZY";
static const char s_eZJ_[] PROGMEM = "#ZJ";
static const char s_eZW_[] PROGMEM = "#ZW";
static const char s_eZ__[] PROGMEM = "#Z ";
static const char s_eZT_[] PROGMEM = "#ZT";

static const char s_eRL_[] PROGMEM = "#RL";
static const char s_eRS_[] PROGMEM = "#RS";
static const char s_eRF_[] PROGMEM = "#RF";
static const char s_eRI_[] PROGMEM = "#RI";
static const char s_eRC_[] PROGMEM = "#RC";
static const char s_eFM_[] PROGMEM = "#FM";
static const char s_eRM_[] PROGMEM = "#RM";
static const char s_eRO_[] PROGMEM = "#RO";
static const char s_eFR_[] PROGMEM = "#FR";
static const char s_eRE_[] PROGMEM = "#RE";
static const char s_eRR_[] PROGMEM = "#RR";

static const char s_eAL_[] PROGMEM = "#AL";
static const char s_eFE_[] PROGMEM = "#FE";
static const char s_eAE_[] PROGMEM = "#AE";
static const char s_eAA_[] PROGMEM = "#AA";
static const char s_eAI_[] PROGMEM = "#AI";
static const char s_eAN_[] PROGMEM = "#AN";
static const char s_eAS_[] PROGMEM = "#AS";
static const char s_eAH_[] PROGMEM = "#AH";
static const char s_eAT_[] PROGMEM = "#AT";
static const char s_eA1[]  PROGMEM = "#A@;";

static const char s_eYH_[] PROGMEM = "#YH";
static const char s_eYL_[] PROGMEM = "#YL";
static const char s_eYS_[] PROGMEM = "#YS";
static const char s_eFP_[] PROGMEM = "#FP";

static const char s_eMN_[] PROGMEM = "#MN";
static const char s_eSB_[] PROGMEM = "#SB";

static const char s_eQW_[] PROGMEM = "#QW";
static const char s_eQR_[] PROGMEM = "#QR";

static const char s_EndText_[] PROGMEM = "\r;";


void etcAppendParam(uint16_t p)
{
  itoa(p,ps,10);
  strcat(dstr,ps);
  strcat(dstr,",");
}


void etcFinalParam(uint16_t p)
{
  itoa(p,ps,10);
  strcat(dstr,ps);
  strcat(dstr,";");
}


/////////////// User Signature RAM commands ///////////

void etcSetTftaI2Caddress(uint8_t I2Caddress)
{
	if ((I2Caddress == 0x50) || (I2Caddress == 0xFF)) return;
  etcSetUserSigByte(0,I2Caddress);
}

void etcSetUserSigByte(uint16_t address, uint8_t data)
{
  strcpy(dstr,PMS(s_eQW_));
	etcAppendParam(address);
	etcFinalParam(data);
	etdSendPackage(dstr);
} 


uint8_t etcGetUserSigByte(uint16_t address, uint8_t* pData)
{
	uint8_t cnt, b, rc;
	char buf[256];	

	if (etdRequestCommand('S') == 0) return 0;  // clear send buffer in tftA
	strcpy(dstr,PMS(s_eQR_));
	etcFinalParam(address);
	etdSendPackage(dstr);
	etdSendPackage(dstr);	// Fix for error in TftA v2.25

	if (etdReceivePackage(buf) == 0) return 0;

	cnt = strlen(buf);
	if (cnt < 4) return 0;
	rc = 0;
	for (b = 0; b < cnt-3;) {
		if (!(memcmp(&buf[b], "USB", 3))) {
			*pData = buf[b+3];
			rc = 1;
			break;
		} else {
			b++;
		}
	}
	return rc;
}


///////////////   Terminal commands ////////////////////

void etcTerminalColour(uint8_t Fgnd, uint8_t Bgnd)
{
  strcpy(dstr,PMS(s_eFT_));
	etcAppendParam(Fgnd);
	etcFinalParam(Bgnd);
	etdSendPackage(dstr);
}  


void etcWindow(uint8_t n1, uint8_t C, uint8_t L, uint8_t W, uint8_t H)
{
  strcpy(dstr,PMS(s_eTW_));
	etcAppendParam(n1);
	etcAppendParam(C);
	etcAppendParam(L);
	etcAppendParam(W);
	etcFinalParam(H);
	etdSendPackage(dstr);
}  



void etcTerminalOff()
{
  strcpy(dstr,PMS(s_eTA));
	etdSendPackage(dstr);
}  


void etcTerminalOn()
{
  strcpy(dstr,PMS(s_eTE));
	etdSendPackage(dstr);
}  



void etcCursorOnOff(uint8_t N1)
{
  strcpy(dstr,PMS(s_eTC_));
	etcFinalParam(N1);
	etdSendPackage(dstr);
}  


void etcPositionCursor(uint8_t C, uint8_t L)
{
  strcpy(dstr,PMS(s_eTP_));
	etcAppendParam(C);
	etcFinalParam(L);
	etdSendPackage(dstr);
}  



//////////////DISPLAY COMMANDS - entire display //////////////////

void etcDisplayColour(uint8_t Fgnd, uint8_t Bgnd)
{
  strcpy(dstr,PMS(s_eFD_));
	etcAppendParam(Fgnd);
	etcFinalParam(Bgnd);
	etdSendPackage(dstr);
}  



// This is the first display control to be called in the 
// opening screen - so returns 0 on timeout so that
// TftA access can be killed if it fails (set zt = 0)
uint8_t etcDeleteDisplay()
{
  uint8_t ok;
	strcpy(dstr,PMS(s_eDL));
	ok = etdSendPackage(dstr);
	ztDSPDisplay = 0;
	return ok;
}  


void etcFillDisplay()
{
  strcpy(dstr,PMS(s_eDS));
	etdSendPackage(dstr);
}  


void etcFillDisplayColour(uint8_t C)
{
  strcpy(dstr,PMS(s_eDF_));
	etcFinalParam(C);
	etdSendPackage(dstr);
}




/////////////////////////// STRING COMMANDS ///////////////////////////////////////////////

void etcTextColour(uint8_t Fgnd, uint8_t Bgnd)
{
  strcpy(dstr,PMS(s_eFZ_));
	etcAppendParam(Fgnd);
	etcFinalParam(Bgnd);
	etdSendPackage(dstr);
}



void etcFont(uint8_t F)
{
  strcpy(dstr,PMS(s_eZF_));
	etcFinalParam(F);
	etdSendPackage(dstr);
}



void etcZoom(uint8_t Xz,uint8_t Yz)
{
  strcpy(dstr,PMS(s_eZZ_));
	etcAppendParam(Xz);
	etcFinalParam(Yz);
	etdSendPackage(dstr);
}



void etcAdditionalWH(uint8_t AW,uint8_t AH)
{
  strcpy(dstr,PMS(s_eZY_));
	etcAppendParam(AW);
	etcFinalParam(AH);
	etdSendPackage(dstr);
}



void etcSpaceWidth(uint8_t W)
{
  strcpy(dstr,PMS(s_eZJ_));
	etcFinalParam(W);
	etdSendPackage(dstr);
}


void etcTextAngle(uint8_t A)
{
  strcpy(dstr,PMS(s_eZW_));
	etcFinalParam(A);
	etdSendPackage(dstr);
}


void etcString(uint16_t X, uint16_t Y, char just, char* ptext)
{
	strcpy(dstr,PMS(s_eZ__));
	dstr[2] = just;
	etcAppendParam(X);
	etcAppendParam(Y);
	strcat(dstr,ptext);
	strcat(dstr,PMS(s_EndText_));
	etdSendPackage(dstr);
}

/*
void etcTerminalString(char* ptext)
{
  strcpy(dstr,s_eZT_);
	strcat(dstr,ptext);
	etdSendPackage(dstr);
}
*/

/////////////  DRAW LINES and POINTS ////////////////////////


void etcLineColour(uint8_t Fgnd, uint8_t Bgnd)
{
  strcpy(dstr,PMS(s_eFG_));
	etcAppendParam(Fgnd);
	etcFinalParam(Bgnd);
	etdSendPackage(dstr);
}

void etcRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eGR_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcFinalParam(Y2);
	etdSendPackage(dstr);
}


void etcLine(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eGD_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcFinalParam(Y2);
	etdSendPackage(dstr);
}


void etcContinueLine(uint16_t X1, uint16_t Y1)
{
  strcpy(dstr,PMS(s_eGW_));
	etcAppendParam(X1);
	etcFinalParam(Y1);
	etdSendPackage(dstr);
}



void etcDrawPoint(uint16_t X1, uint16_t Y1)
{
  strcpy(dstr,PMS(s_eGP_));
	etcAppendParam(X1);
	etcFinalParam(Y1);
	etdSendPackage(dstr);
}

void etcLineThickness(uint8_t N1, uint8_t N2)
{
  strcpy(dstr,PMS(s_eGZ_));
	etcAppendParam(N1);
	etcFinalParam(N2);
	etdSendPackage(dstr);
}

void etcPattern(uint8_t N1)
{
  strcpy(dstr,PMS(s_eGM_));
	etcFinalParam(N1);
	etdSendPackage(dstr);
}


//////////////////////Change/draw rectangular areas  ////////////////////////////////////////

void etcDeleteRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eRL_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcFinalParam(Y2);
	etdSendPackage(dstr);
}


void etcFillRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eRS_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcFinalParam(Y2);
	etdSendPackage(dstr);
}


void etcColourRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t C)
{
  strcpy(dstr,PMS(s_eRF_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcAppendParam(Y2);
	etcFinalParam(C);
	etdSendPackage(dstr);
}



void etcInvertRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eRI_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcFinalParam(Y2);
	etdSendPackage(dstr);
}



void etcCopyRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint16_t X3, uint16_t Y3)
{
  strcpy(dstr,PMS(s_eRC_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcAppendParam(Y2);
	etcAppendParam(X3);
	etcFinalParam(Y3);
	etdSendPackage(dstr);
}


void etcPatternColour(uint8_t Fgnd, uint8_t Bgnd)
{
  strcpy(dstr,PMS(s_eFM_));
	etcAppendParam(Fgnd);
	etcFinalParam(Bgnd);
	etdSendPackage(dstr);
}


void etcPatternFill(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t N1)
{
  strcpy(dstr,PMS(s_eRM_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcAppendParam(Y2);
	etcFinalParam(N1);
	etdSendPackage(dstr);
}


void etcDrawBox(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t N1)
{
  strcpy(dstr,PMS(s_eRO_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcAppendParam(Y2);
	etcFinalParam(N1);
	etdSendPackage(dstr);
}



void etcBorderColour(uint8_t C1, uint8_t C2 , uint8_t C3)
{
  strcpy(dstr,PMS(s_eFR_));
	etcAppendParam(C1);
	etcAppendParam(C1);
	etcFinalParam(C3);
	etdSendPackage(dstr);
}


void etcBorderType(uint8_t N1, uint8_t N2)
{
  strcpy(dstr,PMS(s_eRE_));
	etcAppendParam(N1);
	etcFinalParam(N2);
	etdSendPackage(dstr);
}



void etcBorderBox(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eRR_));
	etcAppendParam(X1);
	etcAppendParam(Y1);
	etcAppendParam(X2);
	etcFinalParam(Y2);
	etdSendPackage(dstr);
}



////////////////////// Touch Panel Commands ////////////////////////////////////////


void etcDeleteTouch(uint8_t C, uint8_t N1)
{
  strcpy(dstr,PMS(s_eAL_));
  etcAppendParam(C);
  etcFinalParam(N1);
  etdSendPackage(dstr);
}


void etcTouchBorderColours(uint8_t N1, uint8_t N2, uint8_t N3, uint8_t S1, uint8_t S2, uint8_t S3)
{
  strcpy(dstr,PMS(s_eFE_));
  etcAppendParam(N1);
  etcAppendParam(N2);
  etcAppendParam(N3);
  etcAppendParam(S1);
  etcAppendParam(S2);
  etcFinalParam(S3);
  etdSendPackage(dstr);
}


void etcTouchBorderForm(uint8_t N1, uint8_t N2)
{
  strcpy(dstr,PMS(s_eAE_));
  etcAppendParam(N1);
  etcFinalParam(N2);
  etdSendPackage(dstr);
}


void etcTouchQueryActive(uint8_t N1)
{
  strcpy(dstr,PMS(s_eAA_));
  etcFinalParam(N1);
  etdSendPackage(dstr);
}


void etcTouchKeyInvert(uint8_t N1)
{
  strcpy(dstr,PMS(s_eAI_));
  etcFinalParam(N1);
  etdSendPackage(dstr);
}


void etcInvertTouchKey(uint8_t N1)
{
  strcpy(dstr,PMS(s_eAN_));
  etcFinalParam(N1);
  etdSendPackage(dstr);
}


void etcTouchKeySound(uint8_t N1)
{
  strcpy(dstr,PMS(s_eAS_));
  etcFinalParam(N1);
  etdSendPackage(dstr);
}


void etcFreeTouch(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2)
{
  strcpy(dstr,PMS(s_eAH_));
  etcAppendParam(X1);
  etcAppendParam(Y1);
  etcAppendParam(X2);
  etcFinalParam(Y2);
  etdSendPackage(dstr);
}


void etcTouchKey(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t DC, uint8_t UC, char* ptext)
{
  strcpy(dstr,PMS(s_eAT_));
  etcAppendParam(X1);
  etcAppendParam(Y1);
  etcAppendParam(X2);
  etcAppendParam(Y2);
  etcAppendParam(DC);
  etcAppendParam(UC);
  strcat(dstr,ptext);
  strcat(dstr,PMS(s_EndText_));
  etdSendPackage(dstr);
}


void etcTouchInit()
{
  etcDeleteTouch(0,1);
  etcTouchBorderColours(0,0,0,0,0,0);
  etcTouchBorderForm(0,0);
  etcTouchQueryActive(1);
  etcTouchKeyInvert(1);
  etcTouchKeySound(1);
}


void etcTouchCal()
{
	strcpy(dstr,PMS(s_eA1));
	etdSendPackage(dstr);
}



////////////////////// Miscellaneous Commands ////////////////////////////////////////


void etcLEDBrightness(uint8_t N1)
{
  strcpy(dstr,PMS(s_eYH_));
	etcFinalParam(N1);
	etdSendPackage(dstr);
}


void etcLEDonoff(uint8_t N1)
{
  strcpy(dstr,PMS(s_eYL_));
	etcFinalParam(N1);
	etdSendPackage(dstr);
}


void etcTone(uint8_t N1)
{
  strcpy(dstr,PMS(s_eYS_));
	etcFinalParam(N1);
	etdSendPackage(dstr);
}


void etcDefineColour(uint8_t No, uint8_t R5, uint8_t G6, uint8_t B5)
{
  strcpy(dstr,PMS(s_eFP_));
	etcAppendParam(No);
	etcAppendParam(R5);
	etcAppendParam(G6);
	etcFinalParam(B5);
	etdSendPackage(dstr);
}


//////////   macros //////////

void etcMacro(uint8_t no)
{
  strcpy(dstr,PMS(s_eMN_));
	etcFinalParam(no);
	etdSendPackage(dstr);
}  


/*
////////////// SEND BYTES  - PROGRAMMING ETC //////////////

void etcSendBytes(uint8_t count, uint8_t* pbuf)
{
  strcpy(dstr,PMS(s_eSB_));
	etcAppendParam(Count);
	etdSendPackage(dstr);
}  
*/

