/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taDebug.c    program file
 
Variables to PC 
 
*/

#include "taGlobal.h"
#include "taDebug.h"
#include "taDDS.h"
#include "taStarControl.h"
#include "taFT245R.h"
#include "taConfig.h"
#include "taCharLCD.h"
#include "taUsart.h"
#include "taStarDSP.h"
#include "taProgmem.h"
#include "taRTC.h"


/* ************    ADD VARIABLES /REGISTERS for display here  *************
 vartype codes:
    S	string
	B	8 bit integer
	W	16 bit integer
	L	32 bit integer
	E	floating point - to be presented as exponent/mantissa
	F	floating point - fixed point

	But all integers are transmitted as decimal

showas codes:
    S   string
	D	integer to be presented as decimal
	H	integer to be presented as hex
	B	integer to be presented as binary
    E   exponent - mantissa
    0   floating point to 0 decimal places
    1   floating point to 1 decimal place
    2   floating point to 2 decimal places
    3   floating point to 3 decimal places
    4   floating point to 4 decimal places
    5   floating point to 5 decimal places
    6   floating point to 6 decimal places

*/


uint8_t dbSendVariables();
uint8_t dbSendPorts();
uint8_t dbSendPins();
uint8_t dbSendDdrs();
uint8_t dbSendVar(char* pname, uint8_t* pdata, char vartype, char showas);


void dbDebugInit()
{
}


void dbUsbRequest(char cmd)
{
	CounterA = 0;
	switch (cmd) {
		case 'V': 
			dbSendVariables();
			break;
		case 'P': 
			dbSendPorts();
		  	dbSendDdrs();
	  		dbSendPins(); 
			break;
	}
	strcpy(StrUsbA, "END,");
	ltoa(CounterA,StrUsbB,10);
	strcat(StrUsbA,StrUsbB);
	usbSendString(StrUsbA,500,13);
}


uint8_t dbSendVariables()
{
	uint8_t reg; // use for register display - see dbSendPorts ... port
	uint8_t result = 1;

	reg = ADMUX;
	result &= dbSendVar("ADMUX",&reg,'B','B');
	reg = EIMSK;
	result &= dbSendVar("EIMSK",&reg,'B','B');
	reg = EICRA;
	result &= dbSendVar("EICRA",&reg,'B','B');
	reg = EICRB;
	result &= dbSendVar("EICRB",&reg,'B','B');

	result &= dbSendVar(PMS(s_MonitorA),(uint8_t*)&MonitorA,'L','D');
	result &= dbSendVar(PMS(s_MonitorB),(uint8_t*)&MonitorB,'L','D');


/*
	result &= dbSendVar(PMS(s_Debug_Mode),&Mode,'B','D');
	result &= dbSendVar(PMS(s_Debug_Colour),&ParamColour,'B','D');
	result &= dbSendVar(PMS(s_Debug_DeNoise),&SWdenoise,'B','D');
	result &= dbSendVar(PMS(s_Debug_NoiseBlank),&SWnoiseblank,'B','D');
	if (Mode < 2) result &= dbSendVar(PMS(s_Debug_AutoNotch),&SWautonotch,'B','D');
	else result &= dbSendVar(PMS(s_Debug_QRO),&SWqro,'B','D');
	result &= dbSendVar(PMS(s_Debug_ManualNotch),&SWmanualnotch,'B','D');
	result &= dbSendVar(PMS(s_Debug_Filter),&SWfilter,'B','D');
	if (Mode < 2) result &= dbSendVar(PMS(s_Debug_Vox),&SWvox,'B','D');
	else result &= dbSendVar(PMS(s_Debug_QSK),&SWqsk,'B','D');
	if (Mode < 2) result &= dbSendVar(PMS(s_Debug_Comp),&SWspeechcomp,'B','D');
	else result &= dbSendVar(PMS(s_Debug_Spot),&SWspot,'B','D');
	for (uint8_t i = 10; i < 100; i++) {
		char str_name[10], str_starno[3];
		reg = dspGetParamValue(i);
		itoa(i, str_starno, 10);
		strcpy(str_name, PMS(s_Debug_Starno));
		strcat(str_name, str_starno);
		result &= dbSendVar(str_name,&reg,'B','D');
	}
*/
	
/*
	result &= dbSendVar("ShiftTimer",&ShiftTimer,'B','D');
	result &= dbSendVar("zc",&zc,'B','B');
	result &= dbSendVar("zg",&zg,'B','B');
	result &= dbSendVar("zt",&zt,'B','B');
	result &= dbSendVar("EA320_6800",&EA320_6800,'B','B');
	result &= dbSendVar("TwentyByFour",&TwentyByFour,'B','B');
	result &= dbSendVar("DualDisplay",&DualDisplay,'B','B');
	result &= dbSendVar("hsDisplay",&HardwareSettings.hsDisplay,'B','B');
	result &= dbSendVar("hsDualDisplay",&HardwareSettings.hsDualDisplay,'B','B');
	result &= dbSendVar("Spare",&HardwareSettings.spare[14],'L','H');

	result &= dbSendVar("fDDSclock",(uint8_t*)&fDDSclock,'L','D');
	result &= dbSendVar("fdw",(uint8_t*)&fdw,'L','H');
	result &= dbSendVar("Freq",(uint8_t*)&Freq,'L','D');
	result &= dbSendVar("ReqString",(uint8_t*)ReqString,'S','S');
	result &= dbSendVar("StringRx3",(uint8_t*)StringRx3,'S','S');
	result &= dbSendVar("timer3test",(uint8_t*)&timer3test,'B','D');
	result &= dbSendVar("timer4test",(uint8_t*)&timer4test,'B','D');
	result &= dbSendVar("SmeterdB",(uint8_t*)&SmeterdB,'B','D');

	result &= dbSendVar(PMS(s_MonitorB),(uint8_t*)&MonitorB,'L','D');
	result &= dbSendVar(PMS(s_MonitorC),(uint8_t*)&MonitorC,'L','D');
	result &= dbSendVar(PMS(s_MonitorH),(uint8_t*)&MonitorH,'L','H');
	result &= dbSendVar("StrD",(uint8_t*)StrD,'S','S');

	reg = uaGetNext();
	result &= dbSendVar("NextRx0",&reg,'B','D');
*/
  return result;
}


/*
void dbSendDebugInfo()
{
  CounterA = 0;  
  if (strcmp(ReqString,"Vars")==0)
  {dbSendVariables();};
  if (strcmp(ReqString,"Ports")==0)
  {
   	dbSendPorts();
	  dbSendDdrs();
	  dbSendPins();
  };				
  strcpy(StrUsbA, "END,");
  ltoa(CounterA,StrUsbB,10);
  strcat(StrUsbA,StrUsbB);
  usbSendString(StrUsbA,500,13);
}	 
*/


uint8_t dbSendPorts()
{
  uint8_t port;	
	uint8_t result = 1;
	port = PORTA;;
  result &= dbSendVar(PMS(s_PORTA),&port,'B','B');
	port = PORTB;
  result &= dbSendVar(PMS(s_PORTB),&port,'B','B');
	port = PORTC;
  result &= dbSendVar(PMS(s_PORTC),&port,'B','B');
	port = PORTD;
  result &= dbSendVar(PMS(s_PORTD),&port,'B','B');
	port = PORTE;
  result &= dbSendVar(PMS(s_PORTE),&port,'B','B');
	port = PORTF;
  result &= dbSendVar(PMS(s_PORTF),&port,'B','B');
	port = PORTG;
  result &= dbSendVar(PMS(s_PORTG),&port,'B','B');
	port = PORTH;
  result &= dbSendVar(PMS(s_PORTH),&port,'B','B');
	port = PORTJ;
  result &= dbSendVar(PMS(s_PORTJ),&port,'B','B');
	port = PORTK;
  result &= dbSendVar(PMS(s_PORTK),&port,'B','B');
	port = PORTL;
  result &= dbSendVar(PMS(s_PORTL),&port,'B','B');
  return result;
}


uint8_t dbSendDdrs()
{
  uint8_t ddr;	
	uint8_t result = 1;
	ddr = DDRA;;
  result &= dbSendVar(PMS(s_DDRA),&ddr,'B','B');
	ddr = DDRB;
  result &= dbSendVar(PMS(s_DDRB),&ddr,'B','B');
	ddr = DDRC;
  result &= dbSendVar(PMS(s_DDRC),&ddr,'B','B');
	ddr = DDRD;
  result &= dbSendVar(PMS(s_DDRD),&ddr,'B','B');
	ddr = DDRE;
  result &= dbSendVar(PMS(s_DDRE),&ddr,'B','B');
	ddr = DDRF;
  result &= dbSendVar(PMS(s_DDRF),&ddr,'B','B');
	ddr = DDRG;
  result &= dbSendVar(PMS(s_DDRG),&ddr,'B','B');
	ddr = DDRH;
  result &= dbSendVar(PMS(s_DDRH),&ddr,'B','B');
	ddr = DDRJ;
  result &= dbSendVar(PMS(s_DDRJ),&ddr,'B','B');
	ddr = DDRK;
  result &= dbSendVar(PMS(s_DDRK),&ddr,'B','B');
	ddr = DDRL;
  result &= dbSendVar(PMS(s_DDRL),&ddr,'B','B');
  return result;
}


uint8_t dbSendPins()
{
  uint8_t pin;	
	uint8_t result = 1;
	pin = PINA;;
  result &= dbSendVar(PMS(s_PINA),&pin,'B','B');
	pin = PINB;
  result &= dbSendVar(PMS(s_PINB),&pin,'B','B');
	pin = PINC;
  result &= dbSendVar(PMS(s_PINC),&pin,'B','B');
	pin = PIND;
  result &= dbSendVar(PMS(s_PIND),&pin,'B','B');
	pin = PINE;
  result &= dbSendVar(PMS(s_PINE),&pin,'B','B');
	pin = PINF;
  result &= dbSendVar(PMS(s_PINF),&pin,'B','B');
	pin = PING;
  result &= dbSendVar(PMS(s_PING),&pin,'B','B');
	pin = PINH;
  result &= dbSendVar(PMS(s_PINH),&pin,'B','B');
	pin = PINJ;
  result &= dbSendVar(PMS(s_PINJ),&pin,'B','B');
	pin = PINK;
  result &= dbSendVar(PMS(s_PINK),&pin,'B','B');
	pin = PINL;
  result &= dbSendVar(PMS(s_PINL),&pin,'B','B');
  return result;
}


/*
 pvar points to the variable which can be of several types.
 The default is uint8_t. A type cast is needed for other types.
 Data is converted to string for transmission.
 vartype is used to control string conversion and to facilitate
 interpretation in the PC
*/

uint8_t dbSendVar(char* pname, uint8_t* pdata, char vartype, char showas)
{
	CounterA += 1;
	strcpy(StrUsbA, pname);
	switch (vartype)
	{
	  case 'S': strcpy(StrUsbB, (char*)pdata); break;		
		case 'B': ltoa(*(uint8_t*)pdata,StrUsbB,10); break;
		case 'W': ltoa(*(uint16_t*)pdata,StrUsbB,10); break;
		case 'L': ltoa(*(uint32_t*)pdata,StrUsbB,10); break;
		case 'E': break;
		case 'F': break;
  }
	strcat(StrUsbA,",");
	strcat(StrUsbA,StrUsbB);
	strcat(StrUsbA,",");
  StrUsbC[0] = vartype;
	StrUsbC[1] = 0;
	strcat(StrUsbA,StrUsbC);
	strcat(StrUsbA,",");
  StrUsbC[0] = showas;
	StrUsbC[1] = 0;
	strcat(StrUsbA,StrUsbC);
	return usbSendString(StrUsbA,500,13);
}
