/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taTWI.h    header file
 
 TWI (I2C) bus driver header file

*/

#ifndef _ta_TWI_H_
#define _ta_TWI_H_ 1

uint8_t rtcbuf[8]; 


uint8_t TFTA_I2C_ADDRESS;

uint8_t RTC_I2C_ADDRESS;


int xeeprom_read_byte(uint16_t eeaddr, char *buf);
int xeeprom_write_byte(uint16_t eeaddr, char buf);
int xeeprom_blockread(uint16_t startaddr, uint16_t noofbytes);
int xeeprom_blockwrite(uint16_t startaddr, uint16_t noofbytes);
int etdReadByte(char *pch);
int etdBlockRead(uint16_t noofbytes);
int etdBlockWrite(uint16_t noofbytes);
int icReadByte(char * pch, uint8_t IC2Address);
int icBlockRead(uint16_t noofbytes, uint8_t IC2Address);
int icBlockWrite(uint16_t noofbytes, uint8_t IC2Address);

int rtcReadByte(uint8_t addr, uint8_t *buf);
int rtcWriteByte(uint8_t addr, uint8_t buf);
//int rtcBlockRead(uint8_t startaddr, uint8_t noofbytes);
int rtcBlockWrite(uint8_t startaddr, uint8_t noofbytes);

#endif	/* _ta_TWI_H_ */
