/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taProgmem.h    header file
 

Handles constant date stored in program (flash) memory
This include literal strings which are here rather than in-line

Reason: ATmega2560 code cannot directly access flash memory

Example: 
         void DisplayString("Have a nice day");
This results in the string being copied to RAM before the
Main() routine begins.   This potentially wastes valuable RAM

Note also that pointers are 16 bit so problems accessing beyond 64k in flash.   

Solution:  use PROGMEM to place strings in flash and return a pointer to 
the string's flash location (and not its pre-run-time RAM location).
Either use FAR calls to flash or make sure all PROGMEM data is 
located below 64k

*/

#ifndef _ta_PROGMEM_H_
#define _ta_PROGMEM_H_ 1


// String 'literal' definitions

// ***NOTE*** 
// PMS(PGM_P pfs);  uses:   char pmStrBuf[80];   defined in taProgmem.c
// DO NOT MAKE A SECOND CALL TO PMS UNTIL YOU HAVE OFF-LOADED THE THE FIRST STRING
// (otherwise the second will overwrite the first in pmStrBuf[80] )

// string is inserted into code as:   PMS(s_2_1_AF_gain)
// s_ is a suffix to avoid accidental duplication with other non-string labels
// all punctuation replaced with underscore


// This general purpose string facility has the PROGMEM strings defined
// in the header file because the labels must be visible to the calling
// routine in order to pass them as parameters


extern char pmStrBuf[80];	// buffer used to return strings

// copy specified PROGMEM string to RAM and return pointer
char* PMS(PGM_P pfs);
char* pmdSpaces(uint8_t n);
uint8_t pmUsernoToSeq(uint8_t n);
uint8_t pmSeqToUserNo(uint8_t n);
int pmUserNoListShift(uint8_t olduserno, int shift, uint8_t AllowUnassigned);
uint8_t pmXUsernoToSeq(uint8_t n);
uint8_t pmSeqToXUserNo(uint8_t n);
int pmXUserNoListShift(uint8_t olduserno, int shift, uint8_t AllowUnassigned);
uint8_t pmParamNameIndexNL(uint8_t p);
char* pmParamNameFromListIndex(uint8_t i);
char* pmUnitsFromListIndex(uint8_t i);
uint8_t pmListIndexFromParamNo(uint8_t p);
char* pmParamNameShortLN(uint8_t n);
char* pmParamNameNL(uint8_t p);
char* pmParamNameShortNL(uint8_t p);
char* pmModeName(uint8_t n);
char* pmButtonCap(uint8_t n);
char* pmBandName(uint8_t n);
uint8_t pmGetBandPort(uint8_t b);
uint8_t pmGetDSPband(uint8_t b);
uint32_t pmGetBandLowLimit(uint8_t b);
uint32_t pmGetBandHighLimit(uint8_t b);

#endif	/* !_ta_PROGMEM_H_ */
