/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taKS0108Driver.h    128x64 mono graphics driver header file

*/

#ifndef _ta_KS0108DRIVER_H_
#define _ta_KS0108DRIVER_H_ 1

extern uint8_t ksColour;

void ksdInit();
void ksdClearScreen();
void ksdGoTo(uint8_t x, uint8_t y, uint8_t reading);
void ksdWriteString(char *);
void ksdBitmap(char* bmp, uint8_t x, uint8_t y, uint8_t dx, uint8_t dy);
void ksdSetPixel(uint8_t x, uint8_t y, uint8_t color);
void ksdWriteCommand(uint8_t commandToWrite, uint8_t controller);
uint8_t ksdReadData();
void ksdWriteData(uint8_t dataToWrite);
uint8_t ksdReadPROGMEMbyte(char * ptr);
void ksdInitalizePorts();
void ksdRectangle(uint8_t x, uint8_t y, uint8_t b, uint8_t a);
void ksdCircle(uint8_t cx, uint8_t cy ,uint8_t radius);
void ksdLine(uint16_t X1,uint16_t Y1,uint16_t X2,uint16_t Y2);
void ksdFillRect(uint8_t X1, uint8_t Y1, uint8_t X2, uint8_t Y2);
void ksdClearRect(uint8_t X1, uint8_t Y1, uint8_t X2, uint8_t Y2);
void ksdF8WriteChar(uint8_t ch, uint16_t* ppX, uint16_t* ppY, uint8_t inverted);
void ksdF8WriteString(char* s, uint16_t X, uint16_t Y, uint8_t inverted);
void ksdF8CentreWriteString(char* s, uint16_t X, uint16_t Y, uint8_t inverted);
void ksdF16WriteChar(uint8_t ch, uint16_t* ppX, uint16_t* ppY);
void ksdF16WriteString(char* s, uint16_t X, uint16_t Y);
uint8_t ksdF8StringWidth(char* s);
void ksdWriteFreqAString(char* s, uint16_t X, uint16_t Y);
void ksdWriteFreqBString(char* s, uint16_t X, uint16_t Y);
void ksdWrite5x3String(char* s, uint16_t X, uint16_t Y);

#endif	/* !_ta_KS0108DRIVER_H_ */
