/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taGraphicsEA320.h    header file
 
Graphics display routines   320x240   
Epson S1D13700 driver chip
 
*/

#ifndef _ta_GRAPHICSEA320_H_
#define _ta_GRAPHICSEA320_H_ 1


#define LayerTR 1   // all layer graphic , all text uses graphics
#define LayerRx 2
#define LayerTx 3

#define FilterTopX 57
#define FilterTopY 151

// Message/menu frame dimensions
#define RxTxMsgX 109
#define RxTxMsgWidth 167
#define RxMsgY 99
#define RxMsgHeight 109
#define TxMsgY 150
#define TxMsgHeight 58
 

#define RxMsgY1 107				// Three-line F16 message line positions 
#define RxMsgY2 128
#define RxMsgY3 149
#define TxMsgY1 152
#define TxMsgY2 168
#define TxMsgY3 184

#define WinX 1
#define WinY 69
#define WinHeight 170
#define WinWidth 279

#define geStateX 35
#define geStateY 166


extern uint16_t MsgX;
extern uint16_t MsgWidth;
extern uint8_t MsgY;
extern uint8_t MsgHeight;
extern uint8_t MsgY1;
extern uint8_t MsgY2;
extern uint8_t MsgY3;
extern uint8_t BarsY;

void geDrawTime();
void geDrawDateTime();
void geClearParamBoxLower();
void geClearParamBox();
void geClearWin();
void geSetMsgFrameDimensions(uint8_t transmit);
void geDrawFrames();
void geDrawButtonFramesLtoR();
void geClearButtonFramesLtoR();
void geButtonLabelsZtoSRx(uint8_t task, uint8_t highlight);
void geButtonLabelsZtoSTx(uint8_t task, uint8_t highlight);
void geButtonLabelsLtoRRx(uint8_t task, uint8_t highlight);
void geButtonLabelsLtoRTx(uint8_t task, uint8_t highlight);
void geFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw);
void geFilterCW(char * swid, uint8_t widthparam, uint8_t centreparam, uint8_t depthparam, uint8_t sw);
void geCheckBox(uint16_t X,uint8_t Y,uint8_t chkd);
void geDrawMsgFrame();
void geClearMsgFrame();
void geClearRxMsgFrame();
void geDeleteMsgFrame();
void geDoDisplayKey();
void geShowState(char c);
void geBlankState();
void geClearState();
void geStartDSPdisplay();

#endif	/* !_ta_GRAPHICSEA320_H_ */
