/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEATFTcommands.h    header file
 
 EA eDIPTFT43-ATP  intelligent 480 x 272 intelligent TFT colour display
 
 Control module
   
*/

#ifndef _ta_EATFTCOMMANDS_H_
#define _ta_EATFTCOMMANDS_H_ 1


void etcAppendParam(uint16_t p);
void etcFinalParam(uint16_t p);
void etcTerminalColour(uint8_t Fgnd, uint8_t Bgnd);
void etcWindow(uint8_t n1, uint8_t C, uint8_t L, uint8_t W, uint8_t H);
void etcTerminalOff();
void etcTerminalOn();
void etcCursorOnOff(uint8_t N1);
void etcPositionCursor(uint8_t C, uint8_t L);
void etcDisplayColour(uint8_t Fgnd, uint8_t Bgnd);
uint8_t etcDeleteDisplay();  // return error so can test display access
void etcFillDisplay();
void etcFillDisplayColour(uint8_t C);
void etcTextColour(uint8_t Fgnd, uint8_t Bgnd);
void etcFont(uint8_t F);
void etcZoom(uint8_t Xz,uint8_t Yz);
void etcAdditionalWH(uint8_t AW,uint8_t AH);
void etcSpaceWidth(uint8_t W);
void etcTextAngle(uint8_t A);
void etcString(uint16_t X, uint16_t Y, char just, char* ptext);
void etcTerminalString(char* ptext);
void etcRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcLine(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcContinueLine(uint16_t X1, uint16_t Y1);
void etcDrawPoint(uint16_t X1, uint16_t Y1);
void etcLineThickness(uint8_t N1, uint8_t N2);
void etcPattern(uint8_t N1);
void etcLineColour(uint8_t Fgnd, uint8_t Bgnd);
void etcDeleteRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcFillRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcColourRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t C);
void etcInvertRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcCopyRect(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint16_t X3, uint16_t Y3);
void etcPatternColour(uint8_t Fgnd, uint8_t Bgnd);
void etcPatternFill(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t N1);
void etcDrawBox(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t N1);
void etcBorderColour(uint8_t C1, uint8_t C2 , uint8_t C3);
void etcBorderType(uint8_t N1, uint8_t N2);
void etcBorderBox(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcDeleteTouch(uint8_t C, uint8_t N1);
void etcTouchBorderColours(uint8_t N1, uint8_t N2, uint8_t N3, uint8_t S1, uint8_t S2, uint8_t S3);
void etcTouchBorderForm(uint8_t N1, uint8_t N2);
void etcTouchQueryActive(uint8_t N1);
void etcTouchKeyInvert(uint8_t N1);
void etcInvertTouchKey(uint8_t N1);
void etcTouchKeySound(uint8_t N1);
void etcFreeTouch(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2);
void etcTouchKey(uint16_t X1, uint16_t Y1, uint16_t X2, uint16_t Y2, uint8_t DC, uint8_t UC, char* ptext);
void etcTouchInit();
void etcTouchCal();
void etcLEDBrightness(uint8_t N1);
void etcLEDonoff(uint8_t N1);
void etcTone(uint8_t N1);
void etcDefineColour(uint8_t No, uint8_t R5, uint8_t G6, uint8_t B5);
void etcMacro(uint8_t no);

void etcSetUserSigByte(uint16_t address, uint8_t data);
uint8_t etcGetUserSigByte(uint16_t address, uint8_t* pData);


void etcSetTftaI2Caddress(uint8_t I2Caddress);



#endif	/* !_ta_EATFTCOMMANDS_H_ */
