/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEATFT.h    header file
 
 EA eDIPTFT43-ATP  intelligent 480 x 272 intelligent TFT colour display
 
 TrxAVR control of display
   
*/

#ifndef _ta_EATFT_H_
#define _ta_EATFT_H_ 1

// Colours
#define TRANSPARENT   0
#define BLACK         1
#define BLUE          2
#define RED           3
#define GREEN         4
#define MAGENTA       5
#define CYAN          6
#define YELLOW        7
#define WHITE         8
#define DIM_GREY      9
#define DARK_ORANGE  10
#define PURPLE       11
#define DEEP_PINK    12
#define SPRING_GREEN 13
#define CHARTREUSE   14
#define LIGHT_BLUE   15
#define GREY         16
#define DARK_BLUE    17  // define colour dark blue for buttons
#define DARK_GREEN   18  // define colour dark green for buttons
#define DARK_YELLOW  19  // define colour dark yellow for buttons
#define DARK_RED     20  // define colour dark red for buttons
#define DARK_GREY    21  // define colour dark grey for buttons
#define DARK_PURPLE  22  // define colour dark purple for buttons
#define NO_CHANGE    255

// Fonts
#define FONT4x6         1
#define FONT6x8         2
#define FONT7x12        3
#define GENEVA10        4
#define CHICAGO14       5
#define SWISS30B        6
#define BIGZIF50        7
#define BIGZIF100       8
#define ArialBold18     9
#define ArialBold16     10
#define Arial20         11
#define Arial18         12
#define Arial16         13
#define OldSansBlack22  14
#define OldSansBlack28  15
#define OldSansBlack42  16
#define GenevaBold16    17
#define Geneva14        18
#define Arial12         19
#define Arial14         20
#define Arial12_9       21

#define MenuX 57
#define MenuY 110  // was 113
#define MenuWstandard 164  // was 162
#define MenuH 162  // was 159

// TFT Touchpad circular buffer size: 16 bytes
// Calculations will need to be masked with TFT_TP_BUFFER_MASK unless size = 256
#define TFT_TP_BUFFER_SIZE 16
#define TFT_TP_BUFFER_MASK ( TFT_TP_BUFFER_SIZE - 1 )

#if ( TFT_TP_BUFFER_SIZE & TFT_TP_BUFFER_MASK )
#error TFT_TP buffer size is not a power of 2
#endif

// TFT Encoders8 circular buffer size: 32 bytes
// Calculations will need to be masked with TFT_ENC8_BUFFER_MASK unless size = 256
#define TFT_ENC8_BUFFER_SIZE 32
#define TFT_ENC8_BUFFER_MASK ( TFT_ENC8_BUFFER_SIZE - 1 )

#if ( TFT_ENC8_BUFFER_SIZE & TFT_ENC8_BUFFER_MASK )
#error TFT_ENC8 buffer size is not a power of 2
#endif

// TFT Touchpad circular buffer
extern uint8_t TFT_TP[TFT_TP_BUFFER_SIZE];
extern volatile uint8_t TFT_TP_Head;
extern volatile uint8_t TFT_TP_Tail;

// TFT Encoders8 circular buffer
extern uint8_t TFT_ENC8[TFT_ENC8_BUFFER_SIZE];
extern volatile uint8_t TFT_ENC8_Head;
extern volatile uint8_t TFT_ENC8_Tail;

extern uint16_t MenuW;
extern uint8_t etShowSWR;
extern uint8_t etSmeterBarWidth;

//// Macro routines /////////
void etDrawTouchpad();
void etSmeterFramework();
void etClearSmeter();
void etSWRmeterFramework();
void etCopySWRbar();
void etClearSWRmeter();
void etSWRmeterBarSet(uint16_t w, char bar);
void etDSPmonRx();
void etDSPmonRx2();
void etDSPmonTx();
void etDeleteDSPmonRx();
void etDeleteDSPmonTx();
void etDebug(char *str);
void etInitTouchPanel();
uint8_t etTFT_TPBufferDataAvailable();
uint8_t etTFT_TPBufferSpace();
uint8_t etTFT_ENC8BufferDataAvailable();
uint8_t etTFT_ENC8BufferSpace();
uint8_t etReadBuf();
char etReadTouch();
void etSmeterInit();
void etSmeterBarSet(uint8_t w);
void etSwrInit();
void etSwrDrawFramework();
void etTouchpadCaptions();
void etRedrawTouchpadCaption(uint8_t task, uint8_t Highlighted);
void etStartUp();
void etDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo);
void etDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo);
void etClearFrequencyDisplay(uint8_t Vfo);
void etDisplayFrequencyNoDP(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo);
void etWriteVfoTag(char tag, uint8_t Vfo, uint8_t ActiveVfo);
void etShowSwitches();
void etShowIP3();
void etShowRITXIT();
void etClearRITXIT();
void etShowMode();
void etShowQRPQRO(uint8_t val);
void etShowFilter();
void etShowParamColour(uint8_t pc);
void etShowState(char pc);
void etBlankState();
void etClearState();
void etFilterInit();
void etFilterSSB(char* swid, uint8_t widthparam, uint8_t centreparam, uint8_t sw);
void etFilterCW(char * swid, uint8_t widthparam, 
                  uint8_t centreparam, uint8_t depthparam, uint8_t sw);
void etMemBox();
void etStackSlot(uint8_t stack, uint8_t slot);
void etTuneBox();
void etDeleteTuneBox();
void etClearTuneBoxLower();
void etTuneText(char* ttx);
void etTuneText(char* ttx);
void etTuneTextLower(char* ttx);
void etShowVfoStackMode();
void etShowSlickyVolatile(char sv, uint8_t slotno);
void etShowWobbulatorMode();
void etShowRateTuningMode();
void etShowABscan();
void etShowMemStackScan();
void etShowGuarding();
void etShowSigGenMode();
uint8_t etProgramFlash();
uint16_t etDoProgramFlash();
void etRThighlight(uint8_t task, uint8_t Highlighted);

#endif	/* !_ta_EATFT_H_ */
