/*
 *****    homebrew-radios.net   *****

 *****     Project TrxAVR       *****


 taDDS.h    header file
 
Support for AD9951 DDS sythesiser chip 
 

*/

#ifndef _ta_DDS_H_
#define _ta_DDS_H_ 1


struct DDSparams_type {
	uint8_t dp44CWmode;
	uint8_t dpSoftwareFlywheel;
	uint8_t dpAutoDim;
	uint8_t dpParamResetMode;  // if 0  restore all backup params at startup
	uint8_t dpDisplayBright;
	uint8_t dpDisplayDimmed;
	uint8_t dpAutoDimSeconds;
	uint8_t dpDisplayKeyValue;
	uint8_t dpDSPDDSKeysDisplay;
	uint8_t dpMenuTimeout;
	uint16_t dpMoxTimeout;
};

struct Slot_type {
	uint32_t stFreq;
	uint8_t  stMode;
	uint8_t  stFilterNarrow;
	uint8_t  stIP3;
	uint8_t  stParamColour;
};

extern struct DDSparams_type DDSparams;
extern struct Slot_type VfoSlot[2]; 
extern struct Slot_type RamSlot;

extern uint32_t fDDSclock;  //   DDS clock in Hz
extern uint32_t USBoffset;
extern uint32_t LSBoffset;
extern uint32_t CWoffset;
extern uint8_t CWoffsetEnable;
extern uint8_t DDSmultiplier;
extern uint32_t LOfreq;
extern uint32_t LOoffset;
extern uint8_t Split;
extern uint8_t PreviousSplit;
extern uint8_t VFO;
extern uint8_t IP3;
extern uint8_t PreviousVFO;
extern uint32_t Freq;
extern uint32_t TxFreq;  //used for XIT T tuning
extern uint32_t PriorTxFreq;
extern uint32_t StartRITTxFreq;
extern uint32_t RITfreq;
extern uint32_t PreviousFreq;
extern uint8_t Band;
extern uint8_t PreviousBand;
extern uint32_t VFOfreq[2];
extern uint8_t  VFOband[2];
extern uint8_t FreqChangeFlag;
extern uint8_t NeedShowFreq;
extern uint8_t UpdateDDS;
extern uint8_t LockDDS;
extern uint8_t HowToShowFreq;  // 'V' = vfo   'S' = stack
extern uint8_t VolatileSP;
extern uint8_t VolatileCount;
extern uint8_t VfoSlotNo;
extern uint8_t MemStackNo;
extern uint8_t MemSlotNo;
extern uint8_t SigGenMode;
extern uint8_t ClockCalMode;
extern uint8_t LowSideInjection;


void ddsLoadVolatileVfoSlotToRamSlot(uint8_t slot);
void ddsLoadStickyVfoSlotToRamSlot(uint8_t slot);
void ddsLoadMemSlotToRamSlot(uint8_t stack, uint8_t slot);
void ddsLoadBandSlotToRamSlot(char LSC, uint8_t band);
uint32_t ddsGetVfoFreq(uint8_t v);
void ddsSetVfoFreq(uint8_t v, uint32_t f);
void ddsSaveModeToLast();
void ddsSaveFilterToLast();
void ddsSaveIP3ToLast();
void ddsSaveFreqToLast();
void ddsSaveParamColourToLast();
void ddsCheckRITshift();
void ddsCopyVfo();
void ddsClearClocks();
void ddsSaveBandFreq();
void ddsLoadPowerOnSlot(uint8_t vfo);
void ddsApplyVfo(uint8_t v);
void ddsApplyFreq(uint8_t v);
void ddsLoadBandSlot(uint8_t vfo, char LSC, uint8_t band);
void ddsSaveBandSlot(uint8_t vfo, char LSC, uint8_t band);
void ddsInit();
//void ddsResetParams();
void ddsSendFreq(uint32_t *hz, char clk);
void ddsFreqChange();
void ddsCheckFreq();
uint8_t ddsSetFreq();
void ddsSetOffset();
void ddsUpdateDDSclock(uint8_t save);
void ddsUpdateLSBoffset(uint8_t save);
void ddsUpdateUSBoffset(uint8_t save);
void ddsUpdateCWoffset(uint8_t save);
void ddsStackLoadRequest(char stk);
void ddsStackSaveRequest(char stk);
void ddsLoadMemSlotToRamSlot(uint8_t stack, uint8_t slot);
void ddsLoadMemSlot(uint8_t vfo, uint8_t stack, uint8_t slot);
void ddsLoadStickyVfoSlot(uint8_t vfo, uint8_t slot);
void ddsLoadVolatileVfoSlot(uint8_t vfo, uint8_t slot);
void ddsSavePowerOnSlot(uint8_t vfo);
void ddsSaveMemSlot(uint8_t vfo, uint8_t stack, uint8_t slot);
void ddsSaveStickyVfoSlot(uint8_t vfo, uint8_t slot);
void ddsSaveVolatileVfoSlot(uint8_t vfo, uint8_t slot);
void ddsWriteOldestStickyVfoSlotNo(uint8_t n);
uint8_t ddsReadOldestStickyVfoSlotNo();
uint8_t ddsFreqToBand(uint32_t freq);
void ddsUsbRequest(char cmd);
void ddsExtSetFreq(uint8_t v, uint32_t Fext);
void ddsHobcatAtoB();
void ddsHobcatBtoA();
void ddsHobcatVfoA();
void ddsHobcatVfoB();

#endif	/* !_ta_DDS_H_ */
