/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taButtons.h  Soft defined buttons module header file


*/

#ifndef _ta_BUTTONS_H_
#define _ta_BUTTONS_H_ 1


// noofButtons defined in taGlobal.h

extern uint8_t RxButtonAssignments[noofButtons];  //  Rx soft-labelled button tasks
extern uint8_t TxButtonAssignments[noofButtons];   // Tx soft-labelled button tasks

// noofTPButtons defined in taGlobal.h

extern uint8_t RxTouchpadAssignments[noofTPButtons];  //  Rx touch pad button tasks
extern uint8_t TxTouchpadAssignments[noofTPButtons];   // Tx touch pad button tasks

extern uint8_t ButtonMode;

uint8_t buGetNoofTasks();
char* buTaskName(uint8_t n);
void buDoButtonTask(uint8_t ch);
uint8_t buGetTaskLabel(uint8_t n, char* sa, char* sb);
uint8_t buGetCaptionColour(uint8_t taskno);
uint8_t buGetButtonColour(uint8_t taskno);
uint8_t buGetTaskAllowed(uint8_t taskno, uint8_t mode);
void buRedrawLabel(uint8_t taskno, uint8_t Highlighted);

#endif	/* !_ta_BUTTONS_H_ */
