
/*
 *****    homebrew-radios.net   *****

 *****     Project TestPortsCD       *****
 
Application to cycle ATmega2560 ports C adn D as outputs 

TestPortsCD.c.c  

Main module program file

AVR Studio must have:
 -  device set to atmega2560
 - frequency set to 16Mhz in configuration and debug
*/

#include <avr/io.h>
#include <string.h>
#include <stdlib.h>
#include <util/delay.h>
#include <avr/interrupt.h>

#define Xtal 16000000L  // 16Mhz clock Xtal



int main(void)
{
  uint8_t c = 0;
	cli(); // disable interrupts
  DDRC = 0xFF;
	DDRD = 0xFF;
	while(1)
	{
    _delay_ms(500);
		c += 1;
		if(c >15){c=0;};
		PORTC = c + 0x10*c;
		PORTD = c + 0x10*c;
		 
	}
}
