unit UfrmUsrow;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, StdCtrls, Mask, RzEdit, RzSpnEdt, RzLabel,syncobjs,
  D2XXUnit, UGlobals, ExtCtrls, RzPanel, IdGlobal;

type

  TRzSpinEditPtr = ^TRzSpinEdit;

  TfrmUsrow = class(TForm)
    RzPanel1: TRzPanel;
    RzPanel2: TRzPanel;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    Sped0: TRzSpinEdit;
    Char0: TRzLabel;
    RzPanel3: TRzPanel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    Hex1: TRzLabel;
    Char1: TRzLabel;
    Sped1: TRzSpinEdit;
    Save1: TRzBitBtn;
    RzPanel4: TRzPanel;
    RzLabel8: TRzLabel;
    RzLabel9: TRzLabel;
    Hex2: TRzLabel;
    Char2: TRzLabel;
    Sped2: TRzSpinEdit;
    Save2: TRzBitBtn;
    Rzpanel30: TRzPanel;
    RzLabel12: TRzLabel;
    RzLabel13: TRzLabel;
    Hex3: TRzLabel;
    Char3: TRzLabel;
    Sped3: TRzSpinEdit;
    Save3: TRzBitBtn;
    RzPanel6: TRzPanel;
    RzLabel16: TRzLabel;
    RzLabel17: TRzLabel;
    Hex4: TRzLabel;
    Char4: TRzLabel;
    Sped4: TRzSpinEdit;
    Save4: TRzBitBtn;
    RzPanel7: TRzPanel;
    RzLabel20: TRzLabel;
    RzLabel21: TRzLabel;
    Hex5: TRzLabel;
    Char5: TRzLabel;
    Sped5: TRzSpinEdit;
    Save5: TRzBitBtn;
    RzPanel8: TRzPanel;
    RzLabel24: TRzLabel;
    RzLabel25: TRzLabel;
    Hex6: TRzLabel;
    Char6: TRzLabel;
    Sped6: TRzSpinEdit;
    Save6: TRzBitBtn;
    RzPanel9: TRzPanel;
    RzLabel28: TRzLabel;
    RzLabel29: TRzLabel;
    Hex7: TRzLabel;
    Char7: TRzLabel;
    Sped7: TRzSpinEdit;
    Save7: TRzBitBtn;
    RzPanel10: TRzPanel;
    RzPanel11: TRzPanel;
    RzLabel32: TRzLabel;
    RzLabel33: TRzLabel;
    Hex8: TRzLabel;
    Char8: TRzLabel;
    Sped8: TRzSpinEdit;
    Save8: TRzBitBtn;
    RzPanel12: TRzPanel;
    RzLabel36: TRzLabel;
    RzLabel37: TRzLabel;
    Hex9: TRzLabel;
    Char9: TRzLabel;
    Sped9: TRzSpinEdit;
    Save9: TRzBitBtn;
    RzPanel13: TRzPanel;
    RzLabel40: TRzLabel;
    RzLabel41: TRzLabel;
    Hex10: TRzLabel;
    Char10: TRzLabel;
    Sped10: TRzSpinEdit;
    Save10: TRzBitBtn;
    RzPanel14: TRzPanel;
    RzLabel44: TRzLabel;
    RzLabel45: TRzLabel;
    Hex11: TRzLabel;
    Char11: TRzLabel;
    Sped11: TRzSpinEdit;
    Save11: TRzBitBtn;
    RzPanel15: TRzPanel;
    RzLabel48: TRzLabel;
    RzLabel49: TRzLabel;
    Hex12: TRzLabel;
    Char12: TRzLabel;
    Sped12: TRzSpinEdit;
    Save12: TRzBitBtn;
    RzPanel16: TRzPanel;
    RzLabel52: TRzLabel;
    RzLabel53: TRzLabel;
    Hex13: TRzLabel;
    Char13: TRzLabel;
    Sped13: TRzSpinEdit;
    Save13: TRzBitBtn;
    RzPanel17: TRzPanel;
    RzLabel56: TRzLabel;
    RzLabel57: TRzLabel;
    Hex14: TRzLabel;
    Char14: TRzLabel;
    Sped14: TRzSpinEdit;
    Save14: TRzBitBtn;
    RzPanel18: TRzPanel;
    RzLabel60: TRzLabel;
    RzLabel61: TRzLabel;
    Hex15: TRzLabel;
    Char15: TRzLabel;
    Sped15: TRzSpinEdit;
    Save15: TRzBitBtn;
    Hex0: TRzLabel;
    RzBitBtn_Exit: TRzBitBtn;
    RzLabel3: TRzLabel;
    Bin1: TRzLabel;
    Bin2: TRzLabel;
    Bin3: TRzLabel;
    Bin4: TRzLabel;
    Bin5: TRzLabel;
    Bin6: TRzLabel;
    Bin7: TRzLabel;
    Bin8: TRzLabel;
    Bin9: TRzLabel;
    Bin10: TRzLabel;
    Bin11: TRzLabel;
    Bin12: TRzLabel;
    Bin13: TRzLabel;
    Bin14: TRzLabel;
    Bin15: TRzLabel;
    Bin0: TRzLabel;
    procedure Save1Click(Sender: TObject);
    procedure Save2Click(Sender: TObject);
    procedure Save3Click(Sender: TObject);
    procedure Save4Click(Sender: TObject);
    procedure Save5Click(Sender: TObject);
    procedure Save6Click(Sender: TObject);
    procedure Save7Click(Sender: TObject);
    procedure Save8Click(Sender: TObject);
    procedure Save9Click(Sender: TObject);
    procedure Save10Click(Sender: TObject);
    procedure Save11Click(Sender: TObject);
    procedure Save12Click(Sender: TObject);
    procedure Save13Click(Sender: TObject);
    procedure Save14Click(Sender: TObject);
    procedure Save15Click(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure Sped8Change(Sender: TObject);
    procedure Sped1Change(Sender: TObject);
    procedure Sped2Change(Sender: TObject);
    procedure Sped4Change(Sender: TObject);
    procedure Sped5Change(Sender: TObject);
    procedure Sped6Change(Sender: TObject);
    procedure Sped7Change(Sender: TObject);
    procedure Sped9Change(Sender: TObject);
    procedure Sped10Change(Sender: TObject);
    procedure Sped11Change(Sender: TObject);
    procedure Sped12Change(Sender: TObject);
    procedure Sped13Change(Sender: TObject);
    procedure Sped14Change(Sender: TObject);
    procedure Sped15Change(Sender: TObject);
    procedure Sped0Change(Sender: TObject);
    procedure Sped3Change(Sender: TObject);
  private
    byt: byte;
    UsrowAddress: word;
    UsrowData: byte;
    pRzSpinEdit: array[0..15] of TRzSpinEditPtr;
    UsrowDelayEvent: TEvent;
    block: array[0..15] of byte;
    function Ascii(b: byte): string;
    function Binary(b: byte): string;
  public
    procedure Initialise;
    procedure DoWriteUsrowByte;
    procedure DoReadUsrowBytes0to15;
  end;





var
  frmUsrow: TfrmUsrow;

implementation

uses UfrmMain, UUsb;

{$R *.dfm}

procedure TfrmUsrow.Initialise;
var
  i: byte;
begin
  pRzSpinEdit[0] := @Sped0;
  pRzSpinEdit[1] := @Sped1;
  pRzSpinEdit[2] := @Sped2;
  pRzSpinEdit[3] := @Sped3;
  pRzSpinEdit[4] := @Sped4;
  pRzSpinEdit[5] := @Sped5;
  pRzSpinEdit[6] := @Sped6;
  pRzSpinEdit[7] := @Sped7;
  pRzSpinEdit[8] := @Sped8;
  pRzSpinEdit[9] := @Sped9;
  pRzSpinEdit[10] := @Sped10;
  pRzSpinEdit[11] := @Sped11;
  pRzSpinEdit[12] := @Sped12;
  pRzSpinEdit[13] := @Sped13;
  pRzSpinEdit[14] := @Sped14;
  pRzSpinEdit[15] := @Sped15;
  for i := 0 to 15 do pRzSpinEdit[i].Text := '';
  UsrowDelayEvent := TEvent.Create(0, true, false, 'Hobcat User Sig Row delay event');
  UsrowDelayEvent.ResetEvent;
  UsrowDelayEvent.WaitFor(200);
  frmMain.USBstate[readusrow0to15] := 'W';

end;

function TfrmUsrow.Ascii(b: byte): string;
begin
  if (b>=32) and (b <= 127)
  then result := '''' + char(b) + ''''
  else result := '';
end;

function TfrmUsrow.Binary(b: byte): string;
var
  s: string;
  i: byte;
begin
  s := '';
  for i := 1 to 8 do
  begin
    if (b AND $80) > 0 then s := s + '1' else s := s + '0';
    b := b shl 1;
  end;
  result := s;
end;


procedure TfrmUsrow.DoWriteUsrowByte;
var
  error: boolean;
  s: string;
begin
  block[0] := UsrowAddress MOD 256;
  block[1] := UsrowAddress DIV 256;
  block[2] := UsrowData;
  error := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_N')
  then error := true
  else begin
    if not Usb.usSendBlock(@block,3) then error := true;
  end;
  if error then
  begin
    s := 'Failed to send User Sig Row byte to TrxAVR > TftA';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end;
  s := 'User Sig Row byte ' + IntToStr(UsrowAddress) + ' sent TrxAVR > TftA';
  MessageDlg(s,mtInformation,[mbOk],0);
  UsrowDelayEvent.ResetEvent;
  UsrowDelayEvent.WaitFor(1000);
end;


procedure TfrmUsrow.DoReadUsrowBytes0to15;
var
  error: boolean;
  i: byte;
  s: string;
begin
  error := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_M')
  then error := true
  else begin
    UsrowDelayEvent.ResetEvent;
    UsrowDelayEvent.WaitFor(100);
    if not Usb.usReceiveBlock(@block,16) then error := true;
  end;
  if error then
  begin
    s := 'Failed to read TftA Xmega User Sig Row bytes from TrxAVR';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end;
  for i := 0 to 15 do pRzSpinEdit[i]^.Text := IntToStr(block[i]);
end;





procedure TfrmUsrow.Save1Click(Sender: TObject);
begin
  UsrowAddress := 1;
  UsrowData := trunc(Sped1.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save2Click(Sender: TObject);
begin
  UsrowAddress := 2;
  UsrowData := trunc(Sped2.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save3Click(Sender: TObject);
begin
  UsrowAddress := 3;
  UsrowData := trunc(Sped3.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save4Click(Sender: TObject);
begin
  UsrowAddress := 4;
  UsrowData := trunc(Sped4.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save5Click(Sender: TObject);
begin
  UsrowAddress := 5;
  UsrowData := trunc(Sped5.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save6Click(Sender: TObject);
begin
  UsrowAddress := 6;
  UsrowData := trunc(Sped6.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save7Click(Sender: TObject);
begin
  UsrowAddress := 7;
  UsrowData := trunc(Sped7.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save8Click(Sender: TObject);
begin
  UsrowAddress := 8;
  UsrowData := trunc(Sped8.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save9Click(Sender: TObject);
begin
  UsrowAddress := 9;
  UsrowData := trunc(Sped9.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save10Click(Sender: TObject);
begin
  UsrowAddress := 10;
  UsrowData := trunc(Sped10.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save11Click(Sender: TObject);
begin
  UsrowAddress := 11;
  UsrowData := trunc(Sped11.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save12Click(Sender: TObject);
begin
  UsrowAddress := 12;
  UsrowData := trunc(Sped12.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save13Click(Sender: TObject);
begin
  UsrowAddress := 13;
  UsrowData := trunc(Sped13.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save14Click(Sender: TObject);
begin
  UsrowAddress := 14;
  UsrowData := trunc(Sped14.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.Save15Click(Sender: TObject);
begin
  UsrowAddress := 15;
  UsrowData := trunc(Sped15.Value);
  frmMain.USBstate[writeusrow] := 'W';
end;

procedure TfrmUsrow.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmUsrow.Sped8Change(Sender: TObject);
begin
  byt := trunc(Sped8.Value);
  Hex8.Caption := IntToHex(byt,2);
  Char8.Caption := Ascii(byt);
  Bin8.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped1Change(Sender: TObject);
begin
  byt := trunc(Sped1.Value);
  Hex1.Caption := IntToHex(byt,2);
  Char1.Caption := Ascii(byt);
  Bin1.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped2Change(Sender: TObject);
begin
  byt := trunc(Sped2.Value);
  Hex2.Caption := IntToHex(byt,2);
  Char2.Caption := Ascii(byt);
  Bin2.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped4Change(Sender: TObject);
begin
  byt := trunc(Sped4.Value);
  Hex4.Caption := IntToHex(byt,2);
  Char4.Caption := Ascii(byt);
  Bin4.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped5Change(Sender: TObject);
begin
  byt := trunc(Sped5.Value);
  Hex5.Caption := IntToHex(byt,2);
  Char5.Caption := Ascii(byt);
  Bin5.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped6Change(Sender: TObject);
begin
  byt := trunc(Sped6.Value);
  Hex6.Caption := IntToHex(byt,2);
  Char6.Caption := Ascii(byt);
  Bin6.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped7Change(Sender: TObject);
begin
  byt := trunc(Sped7.Value);
  Hex7.Caption := IntToHex(byt,2);
  Char7.Caption := Ascii(byt);
  Bin7.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped9Change(Sender: TObject);
begin
  byt := trunc(Sped9.Value);
  Hex9.Caption := IntToHex(byt,2);
  Char9.Caption := Ascii(byt);
  Bin9.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped10Change(Sender: TObject);
begin
  byt := trunc(Sped10.Value);
  Hex10.Caption := IntToHex(byt,2);
  Char10.Caption := Ascii(byt);
  Bin10.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped11Change(Sender: TObject);
begin
  byt := trunc(Sped11.Value);
  Hex11.Caption := IntToHex(byt,2);
  Char11.Caption := Ascii(byt);
  Bin11.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped12Change(Sender: TObject);
begin
  byt := trunc(Sped12.Value);
  Hex12.Caption := IntToHex(byt,2);
  Char12.Caption := Ascii(byt);
  Bin12.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped13Change(Sender: TObject);
begin
  byt := trunc(Sped13.Value);
  Hex13.Caption := IntToHex(byt,2);
  Char13.Caption := Ascii(byt);
  Bin13.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped14Change(Sender: TObject);
begin
  byt := trunc(Sped14.Value);
  Hex14.Caption := IntToHex(byt,2);
  Char14.Caption := Ascii(byt);
  Bin14.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped15Change(Sender: TObject);
begin
  byt := trunc(Sped15.Value);
  Hex15.Caption := IntToHex(byt,2);
  Char15.Caption := Ascii(byt);
  Bin15.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped0Change(Sender: TObject);
begin
  byt := trunc(Sped0.Value);
  Hex0.Caption := IntToHex(byt,2);
  Char0.Caption := Ascii(byt);
  Bin0.Caption := Binary(byt);
end;

procedure TfrmUsrow.Sped3Change(Sender: TObject);
begin
  byt := trunc(Sped3.Value);
  Hex3.Caption := IntToHex(byt,2);
  Char3.Caption := Ascii(byt);
  Bin3.Caption := Binary(byt);
end;

end.
