unit UfrmSummaryExport;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, RzLabel, StdCtrls, Mask, RzEdit, ComCtrls, RzTreeVw,
  RzFilSys, FileCtrl, HHComp;

type
  TfrmSummaryExport = class(TForm)
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_Execute: TRzBitBtn;
    RzBitBtn_Help: TRzBitBtn;
    RzDirectoryTree_Export: TRzDirectoryTree;
    RzEdit_ExportFile: TRzEdit;
    RzEdit_Before: TRzEdit;
    RzEdit_AFter: TRzEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RzLabel1: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel_Command: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzBitBtn_Save: TRzBitBtn;
    RzLabel2: TRzLabel;
    HtmlHelp: TEmbeddedHtmlHelp;
    procedure RzBitBtn_ExecuteClick(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzEdit_ExportFileChange(Sender: TObject);
    procedure RzDirectoryTree_ExportChange(Sender: TObject;
      Node: TTreeNode);
    procedure RzEdit_BeforeChange(Sender: TObject);
    procedure RzEdit_AFterChange(Sender: TObject);
    procedure RzBitBtn_SaveClick(Sender: TObject);
    procedure RzBitBtn_HelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    procedure SetCommand;
  public
    LaunchFileName: string;
    LaunchParameters: string;
    SaveFileName: string;
    procedure Initialise;
    function AddBackslash(s: string): string;

  end;

var
  frmSummaryExport: TfrmSummaryExport;

implementation

{$R *.dfm}

uses UIniData;


function TfrmSummaryExport.AddBackslash(s: string): string;
var
  nc: integer;
begin
  nc := Length(s);
  if s[nc] <> '\' then s := s + '\';
  result := s;
end;


procedure TfrmSummaryExport.SetCommand;
begin
  RzLabel_Command.Caption
   := RzEdit_Before.Text + ' '
   +  AddBackslash(RzDirectoryTree_Export.Directory)
   +  RzEdit_ExportFile.Text
   +  ' ' + RzEdit_After.Text;
end;


procedure TfrmSummaryExport.Initialise;
begin
  LaunchFilename := '';
  LaunchParameters := '';
  with g_RegIniData do
  begin
    RzDirectoryTree_Export.Directory := IniSummaryExportFolder;
    RzEdit_ExportFile.Text := IniSummaryExportFile;
    RzEdit_Before.Text := IniSummaryExportBefore;
    RzEdit_After.Text := IniSummaryExportAfter;
  end;   
  SetCommand;
end;




procedure TfrmSummaryExport.RzBitBtn_ExecuteClick(Sender: TObject);
var
  Filepath: string;
  s: string;
begin
  Filepath := AddBackslash(RzDirectoryTree_Export.Directory) + RzEdit_ExportFile.Text;
  if FileExists(FilePath)
  then begin
    s := MinimizeName(Filepath, Canvas, 500);
    s := 'File ' + s + ' exists.' + #13#10 +  'Do you want to overwrite it ?';
    if MessageDlg(s,mtConfirmation,[mbYes,mbNo],0) <> mrYes then exit;
  end;
  SaveFileName := Filepath;
  if RzEdit_Before.Text = '' then
  begin
    LaunchFileName := Filepath;
    LaunchParameters := RzEdit_After.Text;
  end
  else begin
    LaunchFileName := RzEdit_Before.Text;
    LaunchParameters := '"' + Filepath + '"';
    if RzEdit_After.Text <> '' then LaunchParameters := LaunchParameters + ' ' + RzEdit_After.Text;
  end;
  Close;
end;

procedure TfrmSummaryExport.RzBitBtn_ExitClick(Sender: TObject);
begin
  with g_RegIniData do
  begin
    IniSummFormLeft := left;
    IniSummFormTop := Top;
  end;
  SaveSwrCoordinates;
  Close;
end;

procedure TfrmSummaryExport.RzEdit_ExportFileChange(Sender: TObject);
var
  p: integer;
  s: string[40];
begin
  with RzEdit_ExportFile do
  begin
    s := Text;
    p := Pos('.',s);
    if p > 0
    then s := copy(s,1,p-1) + '.rtf'
    else s := s + '.rtf';
    Text := s;
    SelStart := p-1;
    SelLength := 0;
  end;
  SetCommand;
end;

procedure TfrmSummaryExport.RzDirectoryTree_ExportChange(Sender: TObject;
  Node: TTreeNode);
begin
  SetCommand;
end;

procedure TfrmSummaryExport.RzEdit_BeforeChange(Sender: TObject);
begin
  SetCommand;
end;

procedure TfrmSummaryExport.RzEdit_AFterChange(Sender: TObject);
begin
  SetCommand;
end;

procedure TfrmSummaryExport.RzBitBtn_SaveClick(Sender: TObject);
begin
  with g_RegIniData do
  begin
    IniSummaryExportFolder := RzDirectoryTree_Export.Directory;
    IniSummaryExportFile :=  RzEdit_ExportFile.Text;
    IniSummaryExportBefore := RzEdit_Before.Text;
    IniSummaryExportAfter := RzEdit_After.Text;
  end;
  SaveRegIniFile;
end;

procedure TfrmSummaryExport.RzBitBtn_HelpClick(Sender: TObject);
begin
  HtmlHelp.ChmFile := ExtractFilePath(Application.EXEName) + 'Sumbuild.chm';
  HtmlHelp.DisplayContext(2730);
end;

procedure TfrmSummaryExport.FormCreate(Sender: TObject);
begin
  with g_RegIniData do
  begin
    left := IniSummformLeft;
    top := IniSummformTop;
  end;
end;

end.
