unit UfrmRTC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, dxExEdtr, dxTL, dxDBCtrl, dxDBGrid, dxCntner, ExtCtrls, RzPanel,
  DB, dxmdaset, dxDBTLCl, dxGrClms, StdCtrls, RzLabel, RzButton, RzLstBox,
  RzCmboBx, RzRadChk, Mask, RzEdit, RzSpnEdt, D2XXUnit, syncobjs, DBCtrls,
  RzDBEdit, RzDBSpin, UGlobals, IdBaseComponent, IdComponent, IdUDPBase,
  IdUDPClient, DateUtils;

type

  Tditem = (year,month,day,hour,minute,second);

  Trtc = (USBfail,NoRtc,ISL1220,PCF8563,DS3231);

  TfrmRTC = class(TForm)
    RzPanel_Fout_ISL1220: TRzPanel;
    RzBitBtn_Send_Fout_ISL1220: TRzBitBtn;
    RzComboBox_Fout_ISL1220: TRzComboBox;
    RzLabel1: TRzLabel;
    RzBitBtn_Exit: TRzBitBtn;
    RzPanel_RTC: TRzPanel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzLabel7: TRzLabel;
    RzLabel8: TRzLabel;
    RzLabel9: TRzLabel;
    RzSpinButtons_Year: TRzSpinButtons;
    RzNumericEdit_Year: TRzNumericEdit;
    RzNumericEdit_Month: TRzNumericEdit;
    RzSpinButtons_Month: TRzSpinButtons;
    RzNumericEdit_Day: TRzNumericEdit;
    RzNumericEdit_Hour: TRzNumericEdit;
    RzNumericEdit_Minute: TRzNumericEdit;
    RzNumericEdit_Second: TRzNumericEdit;
    RzSpinButtons_Day: TRzSpinButtons;
    RzSpinButtons_Hour: TRzSpinButtons;
    RzSpinButtons_Minute: TRzSpinButtons;
    RzSpinButtons_Second: TRzSpinButtons;
    RzLabel10: TRzLabel;
    RzBitBtn_SendDateTime: TRzBitBtn;
    RzPanel4: TRzPanel;
    RzLabel11: TRzLabel;
    RzBitBtn_SendOffs: TRzBitBtn;
    RzSpinEdit_Offset: TRzSpinEdit;
    RzLabel12: TRzLabel;
    RzLabel3: TRzLabel;
    RzPanel_ATR: TRzPanel;
    RzBitBtn_Send_ATR: TRzBitBtn;
    RzSpinEdit_ATR: TRzSpinEdit;
    RzLabel13: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel_RtcKind: TRzLabel;
    RzPanel_Fout_PCF8563: TRzPanel;
    RzLabel14: TRzLabel;
    RzBitBtn_Send_Fout_PCF8563: TRzBitBtn;
    RzComboBox_Fout_PCF8563: TRzComboBox;
    RzLabel15: TRzLabel;
    RzBitBtn_PCUTC: TRzBitBtn;
    RzLabel16: TRzLabel;
    RzPanel_Fout_DS3231: TRzPanel;
    RzLabel17: TRzLabel;
    RzBitBtn_Send_Fout_DS3231: TRzBitBtn;
    RzComboBox_Fout_DS3231: TRzComboBox;
    RzPanel_Aging: TRzPanel;
    RzLabel18: TRzLabel;
    RzLabel19: TRzLabel;
    RzBitBtn_Aging: TRzBitBtn;
    RzSpinEdit_Aging: TRzSpinEdit;
    RzLabel20: TRzLabel;
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzBitBtn_Send_Fout_ISL1220Click(Sender: TObject);
    procedure RzSpinButtons_YearDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_YearUpRightClick(Sender: TObject);
    procedure RzSpinButtons_MonthDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_MonthUpRightClick(Sender: TObject);
    procedure RzSpinButtons_DayDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_DayUpRightClick(Sender: TObject);
    procedure RzSpinButtons_HourDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_HourUpRightClick(Sender: TObject);
    procedure RzSpinButtons_MinuteDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_MinuteUpRightClick(Sender: TObject);
    procedure RzSpinButtons_SecondDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_SecondUpRightClick(Sender: TObject);
    procedure RzSpinButtons_YearContextPopup(Sender: TObject;
      MousePos: TPoint; var Handled: Boolean);
    procedure RzBitBtn_SendDateTimeClick(Sender: TObject);
    procedure RzBitBtn_Send_ATRClick(Sender: TObject);
    procedure RzBitBtn_SendOffsClick(Sender: TObject);
    procedure RzBitBtn_Send_Fout_PCF8563Click(Sender: TObject);
    procedure RzBitBtn_PCUTCClick(Sender: TObject);
    procedure RzNumericEdit_SecondChange(Sender: TObject);
    procedure RzNumericEdit_MonthChange(Sender: TObject);
    procedure RzNumericEdit_DayChange(Sender: TObject);
    procedure RzBitBtn_Send_Fout_DS3231Click(Sender: TObject);
    procedure RzBitBtn_AgingClick(Sender: TObject);
  private
    RtcKind: Trtc;
    RTCbufS: array[0..6] of byte;
    RTCbufR: array[0..6] of byte;
    RtcDelayEvent: TEvent;
    block: array[0..99] of byte;
    HardwareSettings: THardwareSettings;
    procedure DateTimeToBuf(Tim: TDateTime);
    function EditorToBuf: boolean;
    procedure BufToEditor;
    procedure DtChange(ditem: Tditem; delta: integer);
    function CapToAtr(cap: real): byte;
    function AtrToCap(avr: byte): real;
    function SystemTimeToUTC(SysTime: TDateTime) : TDateTime;

  public
    procedure Initialise;
    procedure  DoReadHardware;
    procedure SetTrxAvr_RTC;
    procedure ReadTrxAvr_RTC;
    procedure ReadTrxAVR_Fout;
    procedure DoSetRTC;
    procedure DoReadRTC;
    procedure DoSetFout;
    procedure DoReadFout;
    procedure SetTrxAVR_ATR;
    procedure ReadTrxAVR_ATR;
    procedure SetDS32nnAging;
    procedure ReadDS32nnAging;
    procedure SetTrxAVR_Offset;
    procedure ReadTrxAVR_Offset;
    procedure DoSetATR;
    procedure DoReadATR;
    procedure DoSetAging;
    procedure DoReadAging;
    procedure DoSetOffset;
    procedure DoReadOffset;
  end;

var
  frmRTC: TfrmRTC;

implementation

{$R *.dfm}

uses UIniData, UfrmMain, UUsb;


function TfrmRTC.SystemTimeToUTC(SysTime: TDateTime) : TDateTime;
var
  TimeZoneInf : _TIME_ZONE_INFORMATION;
begin
   if GetTimeZoneInformation(TimeZoneInf) < $FFFFFFFF then
   begin
     result := IncMinute(SysTime, TimeZoneInf.Bias);
   end
   else
     result := SysTime;
end;


procedure TfrmRTC.DateTimeToBuf(Tim: TDateTime);
var
  YR,MO,DY,HR,MN,SC,mS: word;
begin
  DecodeDateTime(Tim,YR,MO,DY,HR,MN,SC,mS);
  RTCbufS[0] := SC;
  RTCbufS[1] := MN;
  RTCbufS[2] := HR;
  RTCbufS[3] := DY;
  RTCbufS[4] := MO;
  RTCbufS[5] := YR - 2000;
  RTCbufS[6] := DayOfWeek(Tim) - 1; //     1 = Monday   7 = Sunday but RTC uses 0 - 6
end;



procedure TfrmRTC.Initialise;
begin
  RtcDelayEvent := TEvent.Create(0, true, false, 'Hobcat frmRTC delay event');
  frmMain.USBstate[hwreadrtc] := 'W';  // read hardware vai USB
end;


procedure TfrmRTC.DoReadHardware;
var
  b: byte;
begin
  RtcKind := USBfail;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_R')
  then exit
  else begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(200);
    if not Usb.usReceiveBlock(@block,96) then exit;
    move(block,HardwareSettings,96);
  end;
  b := HardwareSettings.hsRtcStatus AND $0F;
  case b of
    0: RtcKind := NoRtc;
    1: RtcKind := ISL1220;
    2: RtcKind := PCF8563;
    3: RtcKind := DS3231;
  end;

  case RtcKind of
    USBfail:    RzLabel_RtcKind.Caption := 'RTC: Hardware read failed';
    NoRtc:      RzLabel_RtcKind.Caption := 'RTC: No RTC selected';
    ISL1220:    RzLabel_RtcKind.Caption := 'RTC: ISL1220';
    PCF8563:    RzLabel_RtcKind.Caption := 'RTC: PCF8563 / RTC-8564';
    DS3231:     RzLabel_RtcKind.Caption := 'RTC: DS3231 / DS3232';
  end;
  RzPanel_RTC.Enabled := ((RtcKind <> NoRtc) AND (RtcKind <> USBfail));
  RzBitBtn_PCUTC.Enabled := ((RtcKind <> NoRtc) AND (RtcKind <> USBfail));
  RzPanel_ATR.Visible := (RtcKind = ISL1220);
  RzPanel_Aging.Visible := (RtcKind = DS3231);
  RzPanel_Fout_ISL1220.Visible := (RtcKind = ISL1220);
  RzPanel_Fout_PCF8563.Visible := (RtcKind = PCF8563);
  RzPanel_Fout_DS3231.Visible := (RtcKind = DS3231);
  if RtcKind = ISL1220 then ReadTrxAVR_ATR;
  if RtcKind = DS3231 then ReadDS32nnAging;
  ReadTrxAVR_Rtc;
  ReadTrxAVR_Fout;
  ReadTrxAVR_Offset;
end;



procedure TfrmRTC.DoSetRTC;
begin
  Purge_USB_Device_In;
  if Usb.usSendString('$$$RTC_S') then
  begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(40);
    if Usb.usSendBlock(@RTCbufS,7) then exit;
  end;
  MessageDlg('USB send time for RTC failed',mtError,[mbOk],0);
end;



function TfrmRTC.AtrToCap(avr: byte): real;
begin
  avr := avr AND $3F;
  if (avr AND $20) = 0 then
  begin
    result := 12.5 + (0.25 * avr);
  end
  else begin
    avr := 1 + ((avr XOR $FF) AND $1F);
    result := 12.5 - (0.25 * avr)
  end;
end;


function TfrmRTC.CapToAtr(cap: real): byte;
var
  dC: real;
  b: byte;
begin
  if (cap >= 12.5) then
  begin
    dC := cap - 12.5;
    result := trunc(dC*4);
  end
  else begin
    dC := 12.5 - cap;
    b := trunc(dC*4) - 1;
    result := ((b XOR $FF) AND $1F) OR $20;
  end;
end;


// Day of week in ISL1220 is arbitrary - so uses Delphi (ISO8601) standard where Monday = 1

procedure TfrmRTC.BufToEditor;
var
  YR,MO,DY,HR,MN,SC: word;
begin
  SC := RTCbufR[0];
  MN := RTCbufR[1];
  HR := RTCbufR[2];
  DY := RTCbufR[3];
  MO := RTCbufR[4];
  YR := RTCbufR[5] + 2000;
  RzNumericEdit_Second.Text := IntToStr(SC);
  RzNumericEdit_Minute.Text := IntToStr(MN);
  RzNumericEdit_Hour.Text   := IntToStr(HR);
  RzNumericEdit_Day.Text    := IntToStr(DY);
  RzNumericEdit_Month.Text  := IntToStr(MO);
  RzNumericEdit_Year.Text   := IntToStr(YR);
end;



function TfrmRTC.EditorToBuf: boolean;
var
  DateTime: TDateTime;
  YR,MO,DY,HR,MN,SC,mS: word;
begin
  mS := 0;
  SC := trunc(RzNumericEdit_Second.Value);
  MN := trunc(RzNumericEdit_Minute.Value);
  HR := trunc(RzNumericEdit_Hour.Value);
  DY := trunc(RzNumericEdit_Day.Value);
  MO := trunc(RzNumericEdit_Month.Value);
  YR := trunc(RzNumericEdit_Year.Value);
  if (YR < 2000) OR (YR > 2099) then
  begin
    MessageDlg('Year must be between 2000 and 2099',mtError,[mbOk],0);
    result := false;
    exit;
  end;
  RTCbufS[0] := SC;
  RTCbufS[1] := MN;
  RTCbufS[2] := HR;
  RTCbufS[3] := DY;
  RTCbufS[4] := MO;
  RTCbufS[5] := YR - 2000;
  if not TryEncodeDateTime(YR,MO,DY,HR,MN,SC,mS,DateTime) then
  begin
    MessageDlg('Invalid date',mtError,[mbOk],0);
    result := false;
    exit;
  end;
  RTCbufS[6] := DayOfWeek(DateTime) - 1; //     1 = Monday   7 = Sunday but RTC uses 0 - 6
  result := true;
end;


procedure TfrmRTC.DtChange(ditem: Tditem; delta: integer);
var
  DateTime: TDateTime;
  YR,MO,DY,HR,MN,SC,mS: word;
begin
  mS := 0;
  SC := trunc(RzNumericEdit_Second.Value);
  MN := trunc(RzNumericEdit_Minute.Value);
  HR := trunc(RzNumericEdit_Hour.Value);
  DY := trunc(RzNumericEdit_Day.Value);
  MO := trunc(RzNumericEdit_Month.Value);
  YR := trunc(RzNumericEdit_Year.Value);
  if not TryEncodeDateTime(YR,MO,DY,HR,MN,SC,mS,DateTime) then
  begin
    DY := 1;
    MN := 1;
    YR := 2011;
    DateTime := EncodeDateTime(YR,MN,DY,HR,MN,SC,mS);
  end;
  case ditem of
    year:   DateTime := IncYear(DateTime,delta);
    month:  DateTime := IncMonth(DateTime,delta);
    day:    DateTime := IncDay(DateTime,delta);
    hour:   DateTime := IncHour(DateTime,delta);
    minute: DateTime := IncMinute(DateTime,delta);
    second: DateTime := IncSecond(DateTime,delta);
  end; {case}
  DecodeDateTime(DateTime,YR,MO,DY,HR,MN,SC,mS);
  if (YR <2000) OR (YR >2099) then exit;
  RzNumericEdit_Second.Text := IntToStr(SC);
  RzNumericEdit_Minute.Text := IntToStr(MN);
  RzNumericEdit_Hour.Text   := IntToStr(HR);
  RzNumericEdit_Day.Text    := IntToStr(DY);
  RzNumericEdit_Month.Text  := IntToStr(MO);
  RzNumericEdit_Year.Text   := IntToStr(YR);
end;


procedure TfrmRTC.SetTrxAvr_RTC;
begin
end;


procedure TfrmRTC.DoReadRTC;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$RTC_R')
  then exit
  else begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(50);
    if not Usb.usReceiveBlock(@RTCbufR,7) then exit;
    BufToEditor;
  end;
end;

procedure TfrmRTC.ReadTrxAvr_RTC;
begin
  frmMain.USBstate[readrtc] := 'W';  //into RTCbufR
end;


procedure TfrmRTC.DoSetFout;
begin
  Purge_USB_Device_In;
  if Usb.usSendString('$$$RTC_X') then
  begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(40);
    if not Usb.usSendBlock(@RTCbufS,1) then
    begin
      MessageDlg('USB send Fout for RTC failed',mtError,[mbOk],0);
      exit;
    end;
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(400);
    DoReadFout;
  end;
end;


procedure TfrmRTC.ReadTrxAVR_Fout;
begin
  case RtcKind of
    ISL1220: ;
    PCF8563: ;
    DS3231:  ;
  else exit;
  end; {case}
  frmMain.USBstate[readfout] := 'W';  //into RTCbufR
end;


procedure TfrmRTC.DoReadFout;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$RTC_Y')
  then exit
  else begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(50);
    if Usb.usReceiveBlock(@RTCbufR,1) then
    begin
      case RtcKind of
        ISL1220: RzComboBox_Fout_ISL1220.ItemIndex := RTCbufR[0];
        PCF8563: RzComboBox_Fout_PCF8563.ItemIndex := RTCbufR[0];
        DS3231:  RzComboBox_Fout_DS3231.ItemIndex :=  RTCbufR[0];
      end; {case}
      exit;
    end;
    MessageDlg('USB read Fout for RTC failed',mtError,[mbOk],0);
  end;
end;

/////////////////// /////////////////////////////

procedure TfrmRTC.SetTrxAVR_ATR;
begin
  frmMain.USBstate[setatr] := 'W';  //into RTCbufR
end;


procedure TfrmRTC.DoSetATR;
begin
  Purge_USB_Device_In;
  if Usb.usSendString('$$$RTC_C') then
  begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(40);
    if not Usb.usSendBlock(@RTCbufS,1) then
    begin
      MessageDlg('USB send to RTC ATR failed',mtError,[mbOk],0);
      exit;
    end;
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(40);
    DoReadATR;
  end;
end;



procedure TfrmRTC.ReadTrxAVR_ATR;
begin
  frmMain.USBstate[readatr] := 'W';  //into RTCbufR
end;




procedure TfrmRTC.DoReadATR;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$RTC_D')
  then exit
  else begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(50);
    if Usb.usReceiveBlock(@RTCbufR,1) then
    begin
      RzSpinEdit_ATR.Value := AtrToCap(RTCbufR[0]);
      exit;
    end;
    MessageDlg('USB read of RTC ATR failed',mtError,[mbOk],0);
  end;
end;

///////////////////////////////////////////////////////

procedure TfrmRTC.SetDS32nnAging;
begin
  frmMain.USBstate[setaging] := 'W';  //into RTCbufR
end;

procedure TfrmRTC.ReadDS32nnAging;
begin
  frmMain.USBstate[readaging] := 'W';  //into RTCbufR
end;




procedure TfrmRTC.DoSetAging;
begin
  Purge_USB_Device_In;
  if Usb.usSendString('$$$RTC_E') then
  begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(40);
    if not Usb.usSendBlock(@RTCbufS,1) then
    begin
      MessageDlg('USB send to RTC Aging register failed',mtError,[mbOk],0);
      exit;
    end;
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(400);
    DoReadAging;
  end;

end;


procedure TfrmRTC.DoReadAging;
var
  si: shortint;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$RTC_F')
  then exit
  else begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(50);
    if Usb.usReceiveBlock(@RTCbufR,1) then
    begin
      si := shortint(RTCbufR[0]);
      RzSpinEdit_Aging.Value := si / 10;
      exit;
    end;
    MessageDlg('USB read of RTC ATR failed',mtError,[mbOk],0);
  end;
end;




///////////////////////
procedure TfrmRTC.SetTrxAVR_Offset;
var
  Offs: shortint;
  OffsReal: real;
begin
  OffsReal := 2*RzSpinEdit_Offset.Value;
  Offs := trunc(OffsReal);
  RTCbufS[0] := byte(Offs);
  frmMain.USBstate[setoffs] := 'W';  //into RTCbufR
end;

procedure TfrmRTC.DoSetOffset;
begin
  Purge_USB_Device_In;
  if Usb.usSendString('$$$RTC_A') then
  begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(40);
    if not Usb.usSendBlock(@RTCbufS,1) then
    begin
      MessageDlg('USB send of RTC Offset failed',mtError,[mbOk],0);
      exit;
    end;
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(400);
    DoReadOffset;
  end;
end;



procedure TfrmRTC.ReadTrxAVR_Offset;
begin
  frmMain.USBstate[readoffs] := 'W';  //into RTCbufR
end;



procedure TfrmRTC.DoReadOffset;
var
  Offs: shortint;  // use to force 2s compliment interpretation of data byte (ie -128 to +127)
  OffsReal: real;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$RTC_B')
  then exit
  else begin
    RtcDelayEvent.ResetEvent;
    RtcDelayEvent.WaitFor(50);
    if Usb.usReceiveBlock(@RTCbufR,1) then
    begin
      Offs := shortint(RTCbufR[0]);
      OffsReal := Offs;
      RzSpinEdit_Offset.Value := OffsReal/2;
      exit;
    end;
    MessageDlg('USB read of RTC offset failed',mtError,[mbOk],0);
  end;
end;



/////////////////////



procedure TfrmRTC.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmRTC.RzBitBtn_Send_Fout_ISL1220Click(Sender: TObject);
begin
  RTCbufS[0] := RzComboBox_Fout_ISL1220.ItemIndex;
  frmMain.USBstate[setfout] := 'W';
end;

procedure TfrmRTC.RzSpinButtons_YearDownLeftClick(Sender: TObject);
begin
  DtChange(year,-1);
end;

procedure TfrmRTC.RzSpinButtons_YearUpRightClick(Sender: TObject);
begin
  DtChange(year,+1);
end;

procedure TfrmRTC.RzSpinButtons_MonthDownLeftClick(Sender: TObject);
begin
  DtChange(month,-1);
end;

procedure TfrmRTC.RzSpinButtons_MonthUpRightClick(Sender: TObject);
begin
  DtChange(month,+1)
end;

procedure TfrmRTC.RzSpinButtons_DayDownLeftClick(Sender: TObject);
begin
  DtChange(day,-1);
end;

procedure TfrmRTC.RzSpinButtons_DayUpRightClick(Sender: TObject);
begin
  DtChange(day,+1);
end;


procedure TfrmRTC.RzSpinButtons_HourDownLeftClick(Sender: TObject);
begin
  DtChange(hour,-1);
end;

procedure TfrmRTC.RzSpinButtons_HourUpRightClick(Sender: TObject);
begin
  DtChange(hour,+1);
end;

procedure TfrmRTC.RzSpinButtons_MinuteDownLeftClick(Sender: TObject);
begin
  DtChange(minute,-1);
end;

procedure TfrmRTC.RzSpinButtons_MinuteUpRightClick(Sender: TObject);
begin
  DtChange(minute,+1);
end;

procedure TfrmRTC.RzSpinButtons_SecondDownLeftClick(Sender: TObject);
begin
  DtChange(second,-1);
end;

procedure TfrmRTC.RzSpinButtons_SecondUpRightClick(Sender: TObject);
begin
  DtChange(second,+1);
end;



procedure TfrmRTC.RzSpinButtons_YearContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
begin
  DtChange(year,1);
end;

procedure TfrmRTC.RzBitBtn_SendDateTimeClick(Sender: TObject);
begin
  EditorToBuf;
  frmMain.USBstate[setrtc] := 'W';
end;

procedure TfrmRTC.RzBitBtn_Send_ATRClick(Sender: TObject);
begin
  RTCbufS[0] := CapToAtr(RzSpinEdit_ATR.Value);
  frmMain.USBstate[setatr] := 'W';
end;

procedure TfrmRTC.RzBitBtn_SendOffsClick(Sender: TObject);
begin
  SetTrxAVR_Offset;
end;

procedure TfrmRTC.RzBitBtn_Send_Fout_PCF8563Click(Sender: TObject);
begin
  RTCbufS[0] := RzComboBox_Fout_PCF8563.ItemIndex;
  frmMain.USBstate[setfout] := 'W';
end;

procedure TfrmRTC.RzBitBtn_PCUTCClick(Sender: TObject);
begin
  DateTimeToBuf(SystemTimeToUTC(now));
  frmMain.USBstate[setrtc] := 'W';
  BufToEditor;
end;

procedure TfrmRTC.RzNumericEdit_SecondChange(Sender: TObject);
begin
  if trunc(RzNumericEdit_Second.Value) >59 then
  begin
    RzNumericEdit_Second.Text := '0';
  end;

end;

procedure TfrmRTC.RzNumericEdit_MonthChange(Sender: TObject);
var
 m: word;
begin
  m :=  trunc(RzNumericEdit_Month.Value);
  if (m <1 ) OR (m > 12) then
  begin
    RzNumericEdit_Month.Text := '1';
  end;
end;

procedure TfrmRTC.RzNumericEdit_DayChange(Sender: TObject);
var
 d: word;
begin
  d :=  trunc(RzNumericEdit_Month.Value);
  if (d <1 ) OR (d > 31) then
  begin
    RzNumericEdit_Day.Text := '1';
  end;
end;

procedure TfrmRTC.RzBitBtn_Send_Fout_DS3231Click(Sender: TObject);
begin
  RTCbufS[0] := RzComboBox_Fout_DS3231.ItemIndex;
  frmMain.USBstate[setfout] := 'W';
end;

procedure TfrmRTC.RzBitBtn_AgingClick(Sender: TObject);
var
  si: shortint;
begin
  si := trunc(10*RzSpinEdit_Aging.Value);
  RTCbufS[0] := byte(si);
  RTCbufS[0] := byte(si);
  frmMain.USBstate[setaging] := 'W';
end;

end.
