unit UfrmPortDiagnostic;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RzLabel, RzButton, RzRadChk, ExtCtrls, RzPanel,syncobjs, D2XXUnit;

type
  TfrmPortDiagnostic = class(TForm)
    RxGB_A: TRzGroupBox;
    A7: TRzCheckBox;
    A6: TRzCheckBox;
    A5: TRzCheckBox;
    A4: TRzCheckBox;
    A3: TRzCheckBox;
    A2: TRzCheckBox;
    A1: TRzCheckBox;
    A0: TRzCheckBox;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzLabel7: TRzLabel;
    RzLabel8: TRzLabel;
    RzGB_B: TRzGroupBox;
    RzLabel9: TRzLabel;
    RzLabel10: TRzLabel;
    RzLabel11: TRzLabel;
    RzLabel12: TRzLabel;
    RzLabel13: TRzLabel;
    RzLabel14: TRzLabel;
    RzLabel15: TRzLabel;
    RzLabel16: TRzLabel;
    B7: TRzCheckBox;
    B6: TRzCheckBox;
    B5: TRzCheckBox;
    B4: TRzCheckBox;
    B3: TRzCheckBox;
    B2: TRzCheckBox;
    B1: TRzCheckBox;
    B0: TRzCheckBox;
    RzGB_C: TRzGroupBox;
    RzLabel17: TRzLabel;
    RzLabel18: TRzLabel;
    RzLabel19: TRzLabel;
    RzLabel20: TRzLabel;
    RzLabel21: TRzLabel;
    RzLabel22: TRzLabel;
    RzLabel23: TRzLabel;
    RzLabel24: TRzLabel;
    C7: TRzCheckBox;
    C6: TRzCheckBox;
    C5: TRzCheckBox;
    C4: TRzCheckBox;
    C3: TRzCheckBox;
    C2: TRzCheckBox;
    C1: TRzCheckBox;
    C0: TRzCheckBox;
    RzGB_D: TRzGroupBox;
    RzLabel25: TRzLabel;
    RzLabel31: TRzLabel;
    RzLabel32: TRzLabel;
    D7: TRzCheckBox;
    D1: TRzCheckBox;
    D0: TRzCheckBox;
    RzGB_E: TRzGroupBox;
    RzLabel33: TRzLabel;
    RzLabel34: TRzLabel;
    RzLabel35: TRzLabel;
    RzLabel36: TRzLabel;
    RzLabel37: TRzLabel;
    RzLabel38: TRzLabel;
    RzLabel39: TRzLabel;
    RzLabel40: TRzLabel;
    E7: TRzCheckBox;
    E6: TRzCheckBox;
    E5: TRzCheckBox;
    E4: TRzCheckBox;
    E3: TRzCheckBox;
    E2: TRzCheckBox;
    E1: TRzCheckBox;
    E0: TRzCheckBox;
    RzGB_F: TRzGroupBox;
    RzLabel41: TRzLabel;
    RzLabel42: TRzLabel;
    RzLabel43: TRzLabel;
    RzLabel44: TRzLabel;
    RzLabel45: TRzLabel;
    RzLabel46: TRzLabel;
    RzLabel47: TRzLabel;
    RzLabel48: TRzLabel;
    F7: TRzCheckBox;
    F6: TRzCheckBox;
    F5: TRzCheckBox;
    F4: TRzCheckBox;
    F3: TRzCheckBox;
    F2: TRzCheckBox;
    F1: TRzCheckBox;
    F0: TRzCheckBox;
    RzGB_G: TRzGroupBox;
    RzLabel51: TRzLabel;
    RzLabel52: TRzLabel;
    RzLabel53: TRzLabel;
    RzLabel54: TRzLabel;
    RzLabel55: TRzLabel;
    RzLabel56: TRzLabel;
    G5: TRzCheckBox;
    G4: TRzCheckBox;
    G3: TRzCheckBox;
    G2: TRzCheckBox;
    G1: TRzCheckBox;
    G0: TRzCheckBox;
    RzGB_H: TRzGroupBox;
    RzLabel57: TRzLabel;
    RzLabel58: TRzLabel;
    RzLabel59: TRzLabel;
    RzLabel60: TRzLabel;
    RzLabel61: TRzLabel;
    RzLabel62: TRzLabel;
    RzLabel63: TRzLabel;
    RzLabel64: TRzLabel;
    H7: TRzCheckBox;
    H6: TRzCheckBox;
    H5: TRzCheckBox;
    H4: TRzCheckBox;
    H3: TRzCheckBox;
    H2: TRzCheckBox;
    H1: TRzCheckBox;
    H0: TRzCheckBox;
    RzGB_J: TRzGroupBox;
    RzLabel65: TRzLabel;
    RzLabel66: TRzLabel;
    RzLabel67: TRzLabel;
    RzLabel68: TRzLabel;
    RzLabel69: TRzLabel;
    RzLabel70: TRzLabel;
    RzLabel71: TRzLabel;
    RzLabel72: TRzLabel;
    J7: TRzCheckBox;
    J6: TRzCheckBox;
    J5: TRzCheckBox;
    J4: TRzCheckBox;
    J3: TRzCheckBox;
    J2: TRzCheckBox;
    J1: TRzCheckBox;
    J0: TRzCheckBox;
    RzGB_K: TRzGroupBox;
    RzLabel73: TRzLabel;
    RzLabel74: TRzLabel;
    RzLabel75: TRzLabel;
    RzLabel76: TRzLabel;
    RzLabel77: TRzLabel;
    RzLabel78: TRzLabel;
    RzLabel79: TRzLabel;
    RzLabel80: TRzLabel;
    K7: TRzCheckBox;
    K6: TRzCheckBox;
    K5: TRzCheckBox;
    K4: TRzCheckBox;
    K3: TRzCheckBox;
    K2: TRzCheckBox;
    K1: TRzCheckBox;
    K0: TRzCheckBox;
    RzGB_L: TRzGroupBox;
    RzLabel81: TRzLabel;
    RzLabel82: TRzLabel;
    RzLabel83: TRzLabel;
    RzLabel84: TRzLabel;
    RzLabel85: TRzLabel;
    RzLabel86: TRzLabel;
    RzLabel87: TRzLabel;
    RzLabel88: TRzLabel;
    L7: TRzCheckBox;
    L6: TRzCheckBox;
    L5: TRzCheckBox;
    L4: TRzCheckBox;
    L3: TRzCheckBox;
    L2: TRzCheckBox;
    L1: TRzCheckBox;
    L0: TRzCheckBox;
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_Send: TRzBitBtn;
    RzLabel49: TRzLabel;
    RzLabel89: TRzLabel;
    RzLabel26: TRzLabel;
    RzBitBtn_Read: TRzBitBtn;
    RzLabel27: TRzLabel;
    RzLabel_RW: TRzLabel;
    RzLabel28: TRzLabel;
    RzBitBtn_Clear: TRzBitBtn;
    RzBitBtn_Set: TRzBitBtn;
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzBitBtn_SendClick(Sender: TObject);
    procedure A7Click(Sender: TObject);
    procedure A6Click(Sender: TObject);
    procedure A5Click(Sender: TObject);
    procedure A4Click(Sender: TObject);
    procedure A3Click(Sender: TObject);
    procedure A2Click(Sender: TObject);
    procedure A1Click(Sender: TObject);
    procedure A0Click(Sender: TObject);
    procedure B7Click(Sender: TObject);
    procedure B6Click(Sender: TObject);
    procedure B5Click(Sender: TObject);
    procedure B4Click(Sender: TObject);
    procedure B3Click(Sender: TObject);
    procedure B2Click(Sender: TObject);
    procedure B1Click(Sender: TObject);
    procedure B0Click(Sender: TObject);
    procedure C7Click(Sender: TObject);
    procedure C6Click(Sender: TObject);
    procedure C5Click(Sender: TObject);
    procedure C4Click(Sender: TObject);
    procedure C3Click(Sender: TObject);
    procedure C2Click(Sender: TObject);
    procedure C1Click(Sender: TObject);
    procedure C0Click(Sender: TObject);
    procedure D7Click(Sender: TObject);
    procedure D1Click(Sender: TObject);
    procedure D0Click(Sender: TObject);
    procedure E7Click(Sender: TObject);
    procedure E6Click(Sender: TObject);
    procedure E5Click(Sender: TObject);
    procedure E3Click(Sender: TObject);
    procedure E1Click(Sender: TObject);
    procedure E0Click(Sender: TObject);
    procedure F7Click(Sender: TObject);
    procedure F6Click(Sender: TObject);
    procedure F4Click(Sender: TObject);
    procedure F3Click(Sender: TObject);
    procedure F2Click(Sender: TObject);
    procedure F1Click(Sender: TObject);
    procedure F0Click(Sender: TObject);
    procedure G5Click(Sender: TObject);
    procedure G4Click(Sender: TObject);
    procedure G3Click(Sender: TObject);
    procedure G2Click(Sender: TObject);
    procedure G1Click(Sender: TObject);
    procedure G0Click(Sender: TObject);
    procedure H6Click(Sender: TObject);
    procedure H5Click(Sender: TObject);
    procedure H4Click(Sender: TObject);
    procedure H3Click(Sender: TObject);
    procedure H2Click(Sender: TObject);
    procedure J7Click(Sender: TObject);
    procedure J6Click(Sender: TObject);
    procedure J5Click(Sender: TObject);
    procedure J4Click(Sender: TObject);
    procedure J3Click(Sender: TObject);
    procedure J2Click(Sender: TObject);
    procedure J1Click(Sender: TObject);
    procedure J0Click(Sender: TObject);
    procedure K7Click(Sender: TObject);
    procedure RzGB_KClick(Sender: TObject);
    procedure K6Click(Sender: TObject);
    procedure K5Click(Sender: TObject);
    procedure K4Click(Sender: TObject);
    procedure K3Click(Sender: TObject);
    procedure K2Click(Sender: TObject);
    procedure K1Click(Sender: TObject);
    procedure K0Click(Sender: TObject);
    procedure L6Click(Sender: TObject);
    procedure L5Click(Sender: TObject);
    procedure L4Click(Sender: TObject);
    procedure L3Click(Sender: TObject);
    procedure L2Click(Sender: TObject);
    procedure L1Click(Sender: TObject);
    procedure RzBitBtn_ReadClick(Sender: TObject);
    procedure RzBitBtn_ClearClick(Sender: TObject);
    procedure RzBitBtn_SetClick(Sender: TObject);
  private
    buf: array[0..12] of byte;
    EnableCBclicks: boolean;
    DiagDelayEvent: TEvent;
    function BR(cb: TRzCheckBox): byte;
    procedure BW(cb: TRzCheckBox; data,bit: byte);
    procedure BoxToBuff;
    procedure BuffToBox;
    procedure RequestWritePorts;
    procedure CBclicked;
  public
    procedure Initialise;
    procedure WritePorts;
    procedure ReadPorts;
  end;

var
  frmPortDiagnostic: TfrmPortDiagnostic;

implementation

uses UfrmMain, UUsb;

{$R *.dfm}



function TfrmPortDiagnostic.BR(cb: TRzCheckBox): byte;
begin
  if cb.checked then result := 1 else result := 0;
end;


procedure TfrmPortDiagnostic.BW(cb: TRzCheckBox; data,bit: byte);

begin
  cb.Checked := ((data AND bit) <> 0);
end;



procedure TfrmPortDiagnostic.Initialise;
begin
  DiagDelayEvent := TEvent.Create(0, true, false, 'Hobcat port diagnostic delay event');
  EnableCBclicks:= true;
end;

procedure TfrmPortDiagnostic.BuffToBox;
begin
  BW(A0,buf[0],$01);
  BW(A1,buf[0],$02);
  BW(A2,buf[0],$04);
  BW(A3,buf[0],$08);
  BW(A4,buf[0],$10);
  BW(A5,buf[0],$20);
  BW(A6,buf[0],$40);
  BW(A7,buf[0],$08);

  BW(B0,buf[1],$01);
  BW(B1,buf[1],$02);
  BW(B2,buf[1],$04);
  BW(B3,buf[1],$08);
  BW(B4,buf[1],$10);
  BW(B5,buf[1],$20);
  BW(B6,buf[1],$40);
  BW(B7,buf[1],$08);

  BW(C0,buf[2],$01);
  BW(C1,buf[2],$02);
  BW(C2,buf[2],$04);
  BW(C3,buf[2],$08);
  BW(C4,buf[2],$10);
  BW(C5,buf[2],$20);
  BW(C6,buf[2],$40);
  BW(C7,buf[2],$08);

  BW(D0,buf[3],$01);
  BW(D1,buf[3],$02);
  BW(D7,buf[3],$80);

  BW(E0,buf[4],$01);
  BW(E1,buf[4],$02);
  BW(E2,buf[4],$04);
  BW(E3,buf[4],$08);
  BW(E4,buf[4],$10);
  BW(E5,buf[4],$20);
  BW(E6,buf[4],$40);
  BW(E7,buf[4],$08);

  BW(F0,buf[5],$01);
  BW(F1,buf[5],$02);
  BW(F2,buf[5],$04);
  BW(F3,buf[5],$08);
  BW(F4,buf[5],$10);
  BW(F5,buf[5],$20);
  BW(F6,buf[5],$40);
  BW(F7,buf[5],$08);

  BW(G0,buf[6],$01);
  BW(G1,buf[6],$02);
  BW(G2,buf[6],$04);
  BW(G3,buf[6],$08);
  BW(G4,buf[6],$10);
  BW(G5,buf[6],$20);

  BW(H0,buf[7],$01);
  BW(H1,buf[7],$02);
  BW(H2,buf[7],$04);
  BW(H3,buf[7],$08);
  BW(H4,buf[7],$10);
  BW(H5,buf[7],$20);
  BW(H6,buf[7],$40);
  BW(H7,buf[7],$08);

  BW(J0,buf[8],$01);
  BW(J1,buf[8],$02);
  BW(J2,buf[8],$04);
  BW(J3,buf[8],$08);
  BW(J4,buf[8],$10);
  BW(J5,buf[8],$20);
  BW(J6,buf[8],$40);
  BW(J7,buf[8],$08);

  BW(K0,buf[9],$01);
  BW(K1,buf[9],$02);
  BW(K2,buf[9],$04);
  BW(K3,buf[9],$08);
  BW(K4,buf[9],$10);
  BW(K5,buf[9],$20);
  BW(K6,buf[9],$40);
  BW(K7,buf[9],$08);

  BW(L0,buf[10],$01);
  BW(L1,buf[10],$02);
  BW(L2,buf[10],$04);
  BW(L3,buf[10],$08);
  BW(L4,buf[10],$10);
  BW(L5,buf[10],$20);
  BW(L6,buf[10],$40);
  BW(L7,buf[10],$08);
end;


procedure TfrmPortDiagnostic.BoxToBuff;
begin
  buf[0]  := BR(A0) + 2*BR(A1) + 4*BR(A2) + 8*BR(A3) +16*BR(A4) + 32*BR(A5) + 64*BR(A6) + 128*BR(A7);
  buf[1]  := BR(B0) + 2*BR(B1) + 4*BR(B2) + 8*BR(B3) +16*BR(B4) + 32*BR(B5) + 64*BR(B6) + 128*BR(B7);
  buf[2]  := BR(C0) + 2*BR(C1) + 4*BR(C2) + 8*BR(C3) +16*BR(C4) + 32*BR(C5) + 64*BR(C6) + 128*BR(C7);
  buf[3]  := BR(D0) + 2*BR(D1) + 128*BR(D7);
  buf[4]  := BR(E0) + 2*BR(E1) + 4*BR(E2) + 8*BR(E3) +16*BR(E4) + 32*BR(E5) + 64*BR(E6) + 128*BR(E7);
  buf[5]  := BR(F0) + 2*BR(F1) + 4*BR(F2) + 8*BR(F3) +16*BR(F4) + 32*BR(F5) + 64*BR(F6) + 128*BR(F7);
  buf[6]  := BR(G0) + 2*BR(G1) + 4*BR(G2) + 8*BR(G3) +16*BR(G4) + 32*BR(G5);
  buf[7]  := BR(H0) + 2*BR(H1) + 4*BR(H2) + 8*BR(H3) +16*BR(H4) + 32*BR(H5) + 64*BR(H6) + 128*BR(H7);
  buf[8]  := BR(J0) + 2*BR(J1) + 4*BR(J2) + 8*BR(J3) +16*BR(J4) + 32*BR(J5) + 64*BR(J6) + 128*BR(J7);
  buf[9]  := BR(K0) + 2*BR(K1) + 4*BR(K2) + 8*BR(K3) +16*BR(K4) + 32*BR(K5) + 64*BR(K6) + 128*BR(K7);
  buf[10] := BR(L0) + 2*BR(L1) + 4*BR(L2) + 8*BR(L3) +16*BR(L4) + 32*BR(L5) + 64*BR(L6) + 128*BR(L7);

end;




procedure TfrmPortDiagnostic.RzBitBtn_ExitClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmPortDiagnostic.RzBitBtn_SendClick(Sender: TObject);
begin
  RequestWritePorts;
end;



procedure TfrmPortDiagnostic.RequestWritePorts;
begin
  frmMain.USBstate[diagwrite] := 'W';
end;

procedure TfrmportDiagnostic.WritePorts;
var
  s: string;
begin
  RzLabel_RW.caption := '--------';
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DIA_W') then
  begin
    s := 'Failed to send port data request';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end
  else begin
    BoxToBuff;
    if not Usb.usSendBlock(@buf,11) then
    begin
      s := 'Failed to write port data';
      MessageDlg(s,mtWarning,[mbOk],0);
    end;
  end;
  RzLabel_RW.Caption := 'Display to PORTx';
  DiagDelayEvent.ResetEvent;
  DiagDelayEvent.WaitFor(500);
end;


procedure TfrmPortDiagnostic.RzBitBtn_ReadClick(Sender: TObject);
begin
  frmMain.USBstate[diagread] := 'W';
end;


procedure TfrmPortDiagnostic.ReadPorts;
var
  s: string;
begin
  RzLabel_RW.Caption := '--------';
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DIA_R') then
  begin
    s := 'Failed to send port data request';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end
  else begin
    if not Usb.usReceiveBlock(@buf,11) then
    begin
      s := 'Failed to read port data';
      MessageDlg(s,mtWarning,[mbOk],0);
      exit;
    end;
  end;
  RzLabel_RW.Caption := 'PINx to display';
  EnableCBclicks := false;
  BuffToBox;
  Application.ProcessMessages;
  DiagDelayEvent.ResetEvent;
  DiagDelayEvent.WaitFor(500);
  EnableCBclicks := true;
end;


procedure TfrmPortDiagnostic.RzBitBtn_ClearClick(Sender: TObject);
var
  i: byte;
begin
  for i := 0 to 10 do buf[i] := 0;
  EnableCBclicks := false;
  BuffToBox;
  Application.ProcessMessages;
  EnableCBclicks := true;;
end;

procedure TfrmPortDiagnostic.RzBitBtn_SetClick(Sender: TObject);
var
  i: byte;
begin
  for i := 0 to 10 do buf[i] := $FF;
  EnableCBclicks := false;
  BuffToBox;
  Application.ProcessMessages;
  EnableCBclicks := true;
end;
//////////////////////////

procedure TfrmPortDiagnostic.CBclicked;
begin
  if EnableCBclicks then RequestWritePorts;
end;

procedure TfrmPortDiagnostic.A7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.A0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.B0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.C0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.D7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.D1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.D0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.E7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.E6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.E5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.E3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.E1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.E0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.F0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.G5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.G4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.G3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.G2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.G1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.G0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.H6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.H5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.H4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.H3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.H2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.J0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K7Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.RzGB_KClick(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K1Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.K0Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.L6Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.L5Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.L4Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.L3Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.L2Click(Sender: TObject);
begin
  CBclicked;
end;

procedure TfrmPortDiagnostic.L1Click(Sender: TObject);
begin
  CBclicked;
end;




end.
