unit UfrmDebug;

{
  USB Commands

  $$$GETVARS   -   read all debug variables from AVR


}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, dxExEdtr, ExtCtrls, RzPanel, DB, dxTL, dxDBCtrl, dxDBGrid,
  dxmdaset, dxCntner, Contnrs, RzButton, RzSplit, StdCtrls, Mask, RzEdit,
  RzSpnEdt, RzRadChk, RzLabel, Menus;

type

  Twot = Set of (vars, ports);

  TVarDataObj =
    class
      vdId: integer;
      vdVarName: string;
      vdVarValue: string;
      vdVarType: string;
      vdShowas: string;
      constructor Create(const aId: integer;
                    const aVarName, aVarValue, avarType, aShowas: string);
    end;


  TfrmDebug = class(TForm)
    dxMemData_DebugA: TdxMemData;
    DS_DebugA: TDataSource;
    MD_IDFieldA: TIntegerField;
    MD_VarNameField_A: TStringField;
    MD_VarValueField_A: TStringField;
    MD_VarTypeField_A: TStringField;
    MD_ShowasField_A: TStringField;
    MD_IdField_B: TIntegerField;
    MD_VarNameField_B: TStringField;
    MD_VarValueField_B: TStringField;
    MD_ShowasField_B: TStringField;
    RzPanel1: TRzPanel;
    RzBitBtn_All: TRzBitBtn;
    RzSplitter_Debug: TRzSplitter;
    dxDBGrid_DebugA: TdxDBGrid;
    Col_Id_A: TdxDBGridColumn;
    Col_VarName_A: TdxDBGridColumn;
    Col_VarValue_A: TdxDBGridColumn;
    RzPanel_HeaderA: TRzPanel;
    RzPanel_HeaderB: TRzPanel;
    dxDbGrid_DebugB: TdxDBGrid;
    Col_Id_B: TdxDBGridColumn;
    Col_VarName_B: TdxDBGridColumn;
    Col_VarValue_B: TdxDBGridColumn;
    DS_DebugB: TDataSource;
    dxMemData_DebugB: TdxMemData;
    Col_Showas_A: TdxDBGridColumn;
    Col_Showas_B: TdxDBGridColumn;
    Col_VarType_A: TdxDBGridColumn;
    Col_VarType_B: TdxDBGridColumn;
    MD_VarTypeField_B: TStringField;
    Timer_refresh: TTimer;
    RzSpinEdit_DebugRefresh: TRzSpinEdit;
    RzBitBtn_Var: TRzBitBtn;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzCheckBox_AutoVars: TRzCheckBox;
    RzCheckBox_AutoPorts: TRzCheckBox;
    RzBitBtn_ExitDebug: TRzBitBtn;
    MainMenu1: TMainMenu;
    View1: TMenuItem;
    Menu_ViewDebugPorts: TMenuItem;
    Menu_ViewDebugVars: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RzBitBtn_AllClick(Sender: TObject);
    procedure dxDBGrid_DebugACustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure dxDbGrid_DebugBCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure FormResize(Sender: TObject);
    procedure FormDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure RzSplitter_DebugChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure dxDBGrid_DebugAChangedColumnsWidth(Sender: TObject);
    procedure dxDbGrid_DebugBChangedColumnsWidth(Sender: TObject);
    procedure RzCheckBox_AutoVarsClick(Sender: TObject);
    procedure RzCheckBox_AutoPortsClick(Sender: TObject);
    procedure RzSpinEdit_DebugRefreshChange(Sender: TObject);
    procedure RzBitBtn_VarClick(Sender: TObject);
    procedure Timer_refreshTimer(Sender: TObject);
    procedure RzBitBtn_ExitDebugClick(Sender: TObject);
    procedure RzSplitter_DebugChanging(Sender: TObject; NewPos: Integer;
      var AllowChange: Boolean);
  private
    TimeoutErrorCount: integer;
    LessThanTenErrorCount: integer;
    CheckSumErrorCount: integer;
    Initialised: boolean;
    DataOffset:integer;
    clHex, clDec, clBin, clString, clVarName: TColor;
    Id: integer;
    NameString: string;
    ValueString: string;
    buf: array[0..5000] of char;
    btot: integer;
    sa,sb,sc,sd: string;
    sparse: string[50];
    VarList: TObjectList;
    IdFieldIndexA: integer;
    VarNameFieldIndexA: integer;
    VarValueFieldIndexA: integer;
    ShowAsFieldIndexA: integer;
    VarTypeFieldIndexA: integer;
    IdFieldIndexB: integer;
    VarNameFieldIndexB: integer;
    VarValueFieldIndexB: integer;
    ShowAsFieldIndexB: integer;
    VarTypeFieldIndexB: integer;
    Closing: boolean;
    procedure SetRefresh;
    procedure ProcessUsbInputData(grid: char);
    function ParseOneString(var p: integer; var sa,sb,sc,sd: string): boolean;
    procedure SendCommand(cs: string);
    procedure SetMemDataA;
    procedure SetMemDataB;
    procedure GetDebugData(wot: Twot);
    procedure SaveCoords;
    procedure ValueColumnsResize;
  public
    procedure Initialise;
    procedure RequestDebugData;
  end;

var
  frmDebug: TfrmDebug;

implementation

uses UUsb, D2XXUnit, UfrmMain, DateUtils, IdGlobal, UIniData, UGlobals;

{$R *.dfm}

constructor TVarDataObj.Create(const aId: integer;
                     const aVarName, aVarValue, avarType, aShowas: string);
begin
  inherited Create;
  vdId := aId;
  vdVarName := aVarName;
  vdVarValue := aVarValue;
  vdVarType := aVarType;
  vdShowas := aShowas;
end;


procedure TfrmDebug.Initialise;
begin
  with g_RegIniData do
  begin
//    left := IniDebugFormLeft;
//    top := IniDebugFormTop;
//    width := IniDebugFormWidth;
//    height := IniDebugFormHeight;
//    if IniDebugFormMaximized > 0
//    then WindowState := wsMaximized
//    else WindowState := wsNormal;
    Col_Id_A.width := IniDebugIdColWidthA;
    Col_VarName_A.width := IniDebugVarNameColWidthA;
    Col_VarName_B.width := IniDebugVarNameColWidthB;
    RzSplitter_Debug.Position := IniDebugSplitterPosition;
    RzSpinEdit_DebugRefresh.Value := IniDebugRefresh/10;
    RzCheckBox_AutoVars.Checked := IniDebugAutoVars;
    RzCheckBox_AutoPorts.Checked := IniDebugAutoPorts;
    SetRefresh;
  end;
  Closing := false;
  DataOffset := 25;
  clHex := clNavy;
  clBin := clNavy;
  clDec := clBlack;
  clString := clBlack;
  clVarName := clBlue;
  VarList := TObjectList.Create;
  IdFieldIndexA := dxDbGrid_DebugA.ColumnByFieldName('ID').Index;
  VarNameFieldIndexA := dxDbGrid_DebugA.ColumnByFieldName('VARNAME').Index;
  VarValueFieldIndexA := dxDbGrid_DebugA.ColumnByFieldName('VARVALUE').Index;
  VarTypeFieldIndexA := dxDbGrid_DebugA.ColumnByFieldName('VARTYPE').Index;
  ShowasFieldIndexA := dxDbGrid_DebugA.ColumnByFieldName('SHOWAS').Index;
  IdFieldIndexB := dxDbGrid_DebugB.ColumnByFieldName('ID').Index;
  VarNameFieldIndexB := dxDbGrid_DebugB.ColumnByFieldName('VARNAME').Index;
  VarValueFieldIndexB := dxDbGrid_DebugB.ColumnByFieldName('VARVALUE').Index;
  ShowasFieldIndexB := dxDbGrid_DebugB.ColumnByFieldName('SHOWAS').Index;
  VarTypeFieldIndexB := dxDbGrid_DebugB.ColumnByFieldName('VARTYPE').Index;
  Initialised := true;
  TimeoutErrorCount := 0;
  LessThanTenErrorCount := 0;
  CheckSumErrorCount := 0;
end;




procedure TfrmDebug.SetRefresh;
begin
  Timer_Refresh.Interval := trunc(1000*RzSpinEdit_DebugRefresh.value);
  Timer_Refresh.Enabled
       := (RzCheckBox_AutoVars.Checked OR RzCheckBox_AutoPorts.Checked);
end;

procedure TfrmDebug.SendCommand(cs: string);
begin


end;


procedure TfrmDebug.SetMemDataA;
var
  i: byte;
  VarDataObj: TVarDataObj;
begin
  with dxMemData_DebugA  do
  begin
    Close;
    Open;
    if VarList.Count = 0 then exit;
    for i := 0 to VarList.Count - 1 do
    begin
      VarDataObj := TVarDataObj(VarList.Items[i]);
      Append;
      FieldValues['ID'] := VarDataObj.vdId;
      FieldValues['VARNAME'] := VarDataObj.vdVarName;
      FieldValues['VARVALUE'] := VarDataObj.vdVarValue;
      FieldValues['VARTYPE'] := VarDataObj.vdVarType;
      FieldValues['SHOWAS'] := VarDataObj.vdShowas;
      Post;
    end;
  end;
end;

procedure TfrmDebug.SetMemDataB;
var
  i: byte;
  VarDataObj: TVarDataObj;
begin
  with dxMemData_DebugB  do
  begin
    Close;
    Open;
    if VarList.Count = 0 then exit;
    for i := 0 to VarList.Count - 1 do
    begin
      VarDataObj := TVarDataObj(VarList.Items[i]);
      Append;
      FieldValues['ID'] := VarDataObj.vdId;
      FieldValues['VARNAME'] := VarDataObj.vdVarName;
      FieldValues['VARVALUE'] := VarDataObj.vdVarValue;
      FieldValues['VARTYPE'] := VarDataObj.vdVarType;
      FieldValues['SHOWAS'] := VarDataObj.vdShowas;
      Post;
    end;
  end;
end;


procedure TfrmDebug.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer_Refresh.enabled := false;
  Closing := true;
  Reset_USB_Device;
  SaveCoords;
  VarList.Free;
  Action := caFree;
  frmDebug := nil;
end;


function TfrmDebug.ParseOneString(var p: integer; var sa,sb,sc,sd: string): boolean;
var
  s: string[40];
  i,j: integer;
  FieldNo: integer;
  delim: char;
begin
  result := false;
  sa := '';
  sb := '';
  sc := '';
  sd := '';
  FieldNo := 0;
  repeat
    i := 0;
    while ((buf[p+i] <> ',') AND (buf[p+i] <> #13) AND (p <= btot)) do i := i + 1;
    if (p+i) > btot -2 then exit;
    delim := buf[p+i];
    for j := 0 to i-1 do s[j+1] := buf[p+j];
    s[0] := char(i);
    if (delim = #13) then
    begin
      if (buf[p+i+1] <> #10) then exit;
      p := p + i + 2;
    end
    else p := p + i  + 1;
    Inc(FieldNo);
    case FieldNo of
      1: sa := s;
      2: sb := s;
      3: sc := s;
      4: sd := s;
    end;
  until (delim = #13) OR (FieldNo = 4);
  result := true;
end;


procedure TfrmDebug.ProcessUsbInputData(grid: char);
var
  i: integer;
  p: integer;
  done: boolean;
  stringok: boolean;
  s: string;
  RxBytesInQueue: boolean;
  Start_ms: longword;
  checksum: integer;
begin
  Application.ProcessMessages;
  RxBytesInQueue := false;
  Start_ms := MilliSecondOfTheWeek(Time);
  repeat
    if Closing then exit;
    if (MilliSecondOfTheWeek(Time) - Start_ms > 4000) then
    begin
      Inc(TimeoutErrorCount);
      if TimeoutErrorCount > 5 then
      begin
        TimeoutErrorCount := 0;
        MessageDlg('Debug data requested from TrxAVR.'#13#10'Input queue remains empty after 4 seconds.',
                      mtWarning,[mbOK],0);
      end;
      exit;
    end;
    TimeoutErrorCount := 0;
    if Get_USB_Device_QueueStatus = FT_Ok
    then RxBytesInQueue := (FT_Q_bytes > 0);
  until RxBytesInQueue;
  btot := Read_USB_Device_Buffer(FT_In_Buffer_Size);
  if btot < 7 then
  begin
    inc(LessThanTenErrorCount);
    if LessThanTenErrorCount > 5 then
    begin
      LessThanTenErrorCount := 0;
      MessageDlg('Debug data requested from TrxAVR.'#13#10'Less than 10 chars received.',
                      mtWarning,[mbOK],0);
    end;
    exit;
  end;
  LessThanTenErrorCount := 0;
  for i := 0 to (btot - 1) do buf[i] := char(FT_In_Buffer[i]);
  done := false;
  Id := 0;
  VarList.Clear;
  p := 0;
  repeat
    Inc(Id);
    stringok := ParseOneString(p,sa,sb,sc,sd);
    if not stringok then done := true;
    if (sa = 'END') then
    begin
      done := true;
      checksum := StrToInt(sb);
      if checksum <> VarList.Count then
      begin
        inc(CheckSumErrorCount);
        if CheckSumErrorCount > 5 then
        begin
          CheckSumErrorCount := 0;
          MessageDlg('Debug data requested from TrxAVR.'#13#10'Count of received items doesn''t match checksum.',
                    mtWarning,[mbOK],0);
        end;
        exit;
      end;
    end
    else VarList.Add(TVarDataObj.Create(Id,sa,sb,sc,sd));
    case grid of
      'A': SetMemDataA;
      'B': SetMemDataB;
    end;
  until done;
end;


procedure TfrmDebug.GetDebugData(wot: Twot);
begin
  with Usb do
  begin
//    if usBusy or (not usDeviceOpenAndOk) then exit;
//    frmMain.Timer_USBstatus.enabled := false;
//    Application.ProcessMessages;
//    usBusy := true;
    if vars in wot then
    begin
      Purge_USB_Device_In;
      usSendString('$$$DBG_V');
      ProcessUsbInputData('A');
    end;
    if ports in wot then
    begin
      Purge_USB_Device_In;
      usSendString('$$$DBG_P');
      ProcessUsbInputData('B');
    end;
    Application.ProcessMessages;
//    usBusy := false;
//    frmMain.Timer_USBstatus.enabled := true;
  end;
end;

procedure TfrmDebug.RzBitBtn_AllClick(Sender: TObject);
begin
  GetDebugData([vars,ports]);
end;

procedure TfrmDebug.RzBitBtn_VarClick(Sender: TObject);
begin
  GetDebugData([vars]);
end;


procedure TfrmDebug.dxDBGrid_DebugACustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  Rect: TRect;
  X,Y: integer;
  Id: integer;
  Varname: string;
  VarValue: string;
  s,v: string;
  ds: string;        // decimal string
  hs: string;        // hex string
  bs: string[40];    // binary string
  Showas, VarType: char;
  ColIndex: integer;
  intval: dword;
  hexdigits, bindigits:integer;
  i,j,ns: integer;
begin
  with dxDBGrid_DebugA, ACanvas do
  begin
    Brush.Color := Color;
    Rect := ARect;
    FillRect(Rect);
    X := Rect.Left + 2;
    Y := Rect.Top + 2;
    AFont.Color := Font.Color;
    ColIndex := AColumn.Index;
    if ANode.Values[VarTypeFieldIndexA] = null
    then s := ''
    else s := ANode.Values[VarTypeFieldIndexA];
    if Length(s) > 0 then VArType := s[1] else VarType := #0;;
    if ANode.Values[ShowasFieldIndexA] = null
    then s := ''
    else s := ANode.Values[ShowasFieldIndexA];
    if Length(s) > 0 then Showas := s[1] else Showas := #0;;
    if Showas = 'S'
    then AFont.Color := clGreen
    else AFont.Color := clBlack;
    if ColIndex = IdFieldIndexA then
    begin
      Afont.Color := clTeal;
      Id := ANode.Values[ColIndex];
    end;
    if ColIndex = VarNameFieldIndexA then
    begin
      AFont.Color := clVarName;
      if ANode.Values[ColIndex] = null
      then VarName := ''
      else VarName := ANode.Values[ColIndex];
      X := Rect.Right - TextWidth(VarName) - 6;
      TextOut(X,Y,VarName);
      ADone := true;
    end;
    if ColIndex = VarValueFieldIndexA then
    begin
      if ANode.Values[ColIndex] = null
      then VarValue := ''
      else VarValue := ANode.Values[ColIndex];
      if VarType = 'S' then
      begin
        s := 'str   ';
        Font.Style := [fsItalic];
        Font.Color := clTeal;
        TextOut(X,Y,s);
        X := X + DataOffset;
        Font.Style := [fsBold];
        Font.Color := clDec;
        TextOut(X,Y,VarValue);
        ADone := true;
      end;
      if Showas in ['D','H','B'] then
      begin
        intval := StrToInt(VarValue);
        case VarType of
          'B': begin
                 hexdigits := 2;
                 bindigits := 8;
               end;
          'W': begin
                 hexdigits := 4;
                 bindigits := 16;
               end;
          'L': begin
                 hexDigits := 8;
                 bindigits := 0;
               end;
        end; {case}
        case Showas of
          'D': begin
                 ds := IntToStr(intval);
                 s := 'dec  ';
                 Font.Style := [fsItalic];
                 Font.Color := clTeal;
                 TextOut(X,Y,s);
                 X := X + DataOffset;
                 Font.Style := [fsBold];
                 Font.Color := clDec;
                 TextOut(X,Y,ds);
                 ADone := true;
               end;
          'H': begin
                 hs := IntToHex(intval,hexdigits);
                 s := 'hex  ';
                 Font.Style := [fsItalic];
                 Font.Color := clTeal;
                 TextOut(X,Y,s);
                 X := X + DataOffset;
                 Font.Style := [fsBold];
                 Font.Color := clHex;
                 TextOut(X,Y,hs);
                 ADone := true;
               end;
          'B': begin
                 hs := IntToHex(intval,hexdigits);
                 if bindigits > 0 then
                 begin
                   s := IntToBin(intval);
                   s := Copy(s,33-bindigits,bindigits);
                   j := 0;
                   ns := Length(s);
                   for i := 1 to ns do
                   begin
                     inc(j);
                     bs[j] := s[i];
                     if ((i MOD 4) = 0) AND (i < ns) then
                     begin
                       inc(j);
                       bs[j] := ' ';
                     end;
                   end;
                   bs[0] := char(j);
                   s := 'hex  ';
                   Font.Style := [fsItalic];
                   Font.Color := clTeal;
                   TextOut(X,Y,s);
                   X := X + DataOffset;
                   Font.Style := [fsBold];
                   Font.Color := clHex;
                   TextOut(X,Y,hs);
                   X := Rect.Left + 65;
                   s := 'bin  ';
                   Font.Style := [fsItalic];
                   Font.Color := clTeal;
                   TextOut(X,Y,s);
                   X := X + DataOffset;
                   Font.Style := [fsBold];
                   Font.Color := clBin;
                   TextOut(X,Y,bs);
                   ADone := true;
                 end;
               end;
        end; {case}
        ADone := true;
      end;
    end;
  end;
end;



procedure TfrmDebug.dxDbGrid_DebugBCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  Rect: TRect;
  X,Y: integer;
  Id: integer;
  Varname: string;
  VarValue: string;
  s,v: string;
  ds: string;        // decimal string
  hs: string;        // hex string
  bs: string[40];    // binary string
  Showas, VarType: char;
  ColIndex: integer;
  intval: dword;
  hexdigits, bindigits:integer;
  i,j,ns: integer;
begin
  with dxDBGrid_DebugB, ACanvas do
  begin
    Brush.Color := Color;
    Rect := ARect;
    FillRect(Rect);
    X := Rect.Left + 2;
    Y := Rect.Top + 2;
    AFont.Color := Font.Color;
    ColIndex := AColumn.Index;
    if ANode.Values[VarTypeFieldIndexB] = null
    then s := ''
    else s := ANode.Values[VarTypeFieldIndexB];
    if Length(s) > 0 then VarType := s[1] else VarType := #0;;
    if ANode.Values[ShowasFieldIndexB] = null
    then s := ''
    else s := ANode.Values[ShowasFieldIndexB];
    if Length(s) > 0 then Showas := s[1] else Showas := #0;;
    if Showas = 'S'
    then AFont.Color := clGreen
    else AFont.Color := clBlack;
    if ColIndex = IdFieldIndexB then
    begin
      Afont.Color := clTeal;
      Id := ANode.Values[ColIndex];
    end;
    if ColIndex = VarNameFieldIndexB then
    begin
      AFont.Color := clVarName;
      if ANode.Values[ColIndex] = null
      then VarName := ''
      else VarName := ANode.Values[ColIndex];
      X := Rect.Right - TextWidth(VarName) - 6;
      TextOut(X,Y,VarName);
      ADone := true;
    end;
    if ColIndex = VarValueFieldIndexB then
    begin
      if ANode.Values[ColIndex] = null
      then VarValue := ''
      else VarValue := ANode.Values[ColIndex];
      if VarType = 'S' then
      begin
        s := 'str   ';
        Font.Style := [fsItalic];
        Font.Color := clTeal;
        TextOut(X,Y,s);
        X := X + DataOffset;
        Font.Style := [fsBold];
        Font.Color := clDec;
        TextOut(X,Y,VarValue);
        ADone := true;
      end;
      if Showas in ['D','H','B'] then
      begin
        intval := StrToInt(VarValue);
        case VarType of
          'B': begin
                 hexdigits := 2;
                 bindigits := 8;
               end;
          'W': begin
                 hexdigits := 4;
                 bindigits := 16;
               end;
          'L': begin
                 hexDigits := 8;
                 bindigits := 0;
               end;
        end; //case
        case Showas of
          'D': begin
                 ds := IntToStr(intval);
                 s := 'dec  ';
                 Font.Style := [fsItalic];
                 Font.Color := clTeal;
                 TextOut(X,Y,s);
                 X := X + DataOffset;
                 Font.Style := [fsBold];
                 Font.Color := clDec;
                 TextOut(X,Y,ds);
                 ADone := true;
               end;
          'H': begin
                 hs := IntToHex(intval,hexdigits);
                 s := 'hex  ';
                 Font.Style := [fsItalic];
                 Font.Color := clTeal;
                 TextOut(X,Y,s);
                 X := X + DataOffset;
                 Font.Style := [fsBold];
                 Font.Color := clHex;
                 TextOut(X,Y,hs);
                 ADone := true;
               end;
          'B': begin
                 hs := IntToHex(intval,hexdigits);
                 if bindigits > 0 then
                 begin
                   s := IntToBin(intval);
                   s := Copy(s,33-bindigits,bindigits);
                   j := 0;
                   ns := Length(s);
                   for i := 1 to ns do
                   begin
                     inc(j);
                     bs[j] := s[i];
                     if ((i MOD 4) = 0) AND (i < ns) then
                     begin
                       inc(j);
                       bs[j] := ' ';
                     end;
                   end;
                   bs[0] := char(j);
                   s := 'hex  ';
                   Font.Style := [fsItalic];
                   Font.Color := clTeal;
                   TextOut(X,Y,s);
                   X := X + DataOffset;
                   Font.Style := [fsBold];
                   Font.Color := clHex;
                   TextOut(X,Y,hs);
                   X := Rect.Left + 65;
                   s := 'bin  ';
                   Font.Style := [fsItalic];
                   Font.Color := clTeal;
                   TextOut(X,Y,s);
                   X := X + DataOffset;
                   Font.Style := [fsBold];
                   Font.Color := clBin;
                   TextOut(X,Y,bs);
                   ADone := true;
                 end;
               end;
        end; //case
        ADone := true;
      end;
    end;
  end;
end;
            


procedure TfrmDebug.ValueColumnsResize;
begin
  Col_VarValue_A.Width := dxDbGrid_DebugA.Width - Col_Id_A.Width - Col_VarName_A.Width - 21;
  Col_VarValue_B.Width := dxDbGrid_DebugB.Width - Col_VarName_B.Width - 21;
end;

procedure TfrmDebug.SaveCoords;
begin
  if not Initialised then exit;
  with g_RegIniData do
  begin
//    IniDebugFormLeft := left;
//    IniDebugFormTop := top;
//    IniDebugFormWidth := width;
//    IniDebugFormHeight := height;
//    if WindowState = wsMaximized
//    then IniDebugFormMaximized := 1
//    else IniDebugFormMaximized := 0;
    IniDebugIdColWidthA := Col_Id_A.width;
    IniDebugVarNameColWidthA := Col_VarName_A.width;
    IniDebugVarNameColWidthB := Col_VarName_B.width;
    IniDebugSplitterPosition := RzSplitter_Debug.Position;
  end;
  SaveDebugCoordinates;
end;



procedure TfrmDebug.FormResize(Sender: TObject);
begin
  ValueColumnsResize;
  SaveCoords;
end;

procedure TfrmDebug.FormDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  SaveCoords;
end;

procedure TfrmDebug.RzSplitter_DebugChange(Sender: TObject);
begin
  ValueColumnsResize;
  SaveCoords;
end;

procedure TfrmDebug.FormCreate(Sender: TObject);
begin
  Initialised := false;
end;

procedure TfrmDebug.dxDBGrid_DebugAChangedColumnsWidth(Sender: TObject);
begin
  ValueColumnsResize;
  SaveCoords;
end;

procedure TfrmDebug.dxDbGrid_DebugBChangedColumnsWidth(Sender: TObject);
begin
  ValueColumnsResize;
  SaveCoords;
end;

procedure TfrmDebug.RzCheckBox_AutoVarsClick(Sender: TObject);
begin
  g_RegIniData.IniDebugAutoVars := rzCheckBox_AutoVars.checked;
  SaveDebugIniData;
  SetRefresh;
end;

procedure TfrmDebug.RzCheckBox_AutoPortsClick(Sender: TObject);
begin
  g_RegIniData.IniDebugAutoPorts := rzCheckBox_AutoPorts.checked;
  SaveDebugIniData;
  SetRefresh;
end;

procedure TfrmDebug.RzSpinEdit_DebugRefreshChange(Sender: TObject);
begin
  g_RegIniData.IniDebugRefresh := trunc(10*RzSpinEdit_DebugRefresh.value);
  SaveDebugIniData;
  SetRefresh;
end;


procedure TfrmDebug.Timer_refreshTimer(Sender: TObject);
begin
  if not g_UsbReady then exit;
  frmMain.USBstate[debug] := 'W';
end;

procedure TfrmDebug.RequestDebugData;
var
  wot: Twot;
begin
  wot := [];
  if RzCheckBox_AutoVars.Checked then wot := wot + [vars];
  if RzCheckBox_AutoPorts.Checked then wot := wot + [ports];
  GetDebugData(wot);
end;

procedure TfrmDebug.RzBitBtn_ExitDebugClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDebug.RzSplitter_DebugChanging(Sender: TObject;
  NewPos: Integer; var AllowChange: Boolean);
begin
  if NewPos < 360 then AllowChange := false;
end;

end.



showas codes:
    D		integer to be presented as decimal
    H		integer to be presented as hex
    B		integer to be presented as binary
    E   exponent - mantissa
    0   floating point to 0 decimal places
    1   floating point to 1 decimal place
    2   floating point to 2 decimal places
    3   floating point to 3 decimal places
    4   floating point to 4 decimal places
    5   floating point to 5 decimal places
    6   floating point to 6 decimal places

