unit UfrmDSPtelem;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, RzRadChk, StdCtrls, RzLabel;

type
  TfrmDSPtelem = class(TForm)
    RzRB_USB: TRzRadioButton;
    RzRB_COM: TRzRadioButton;
    RzBitBtn_Accept: TRzBitBtn;
    RzBitBtn_Reject: TRzBitBtn;
    RzBitBtn_Help: TRzBitBtn;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    procedure RzBitBtn_AcceptClick(Sender: TObject);
    procedure RzBitBtn_RejectClick(Sender: TObject);
  private
    procedure SetDSP;
  public
    procedure Initialise;
  end;

var
  frmDSPtelem: TfrmDSPtelem;

implementation

{$R *.dfm}

uses UIniData, UfrmDSP;

procedure TfrmDSPtelem.Initialise;
begin
  RzRB_USB.Checked := (g_RegIniData.IniDspTelemetry = 0);
  RzRB_COM.Checked := (g_RegIniData.IniDspTelemetry = 1);
end;


procedure TfrmDSPtelem.SetDSP;
begin
  with frmDSP do
  begin
    if RzRB_USB.Checked
    then SetUsbCom('U')
    else SetUsbCom('S');
  end;
end;



procedure TfrmDSPtelem.RzBitBtn_AcceptClick(Sender: TObject);
begin
  if RzRB_USB.Checked
  then g_RegIniData.IniDSPtelemetry := 0
  else g_RegIniData.IniDSPtelemetry := 1;
  if frmDSP <> nil then SetDSP;
  ModalResult := mrOk;
end;

procedure TfrmDSPtelem.RzBitBtn_RejectClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
