unit UfrmDSP;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RzLabel, ExtCtrls, RzPanel, dxExEdtr, dxCntner, dxTL,
  dxDBCtrl, dxDBGrid, DB, dxmdaset, SyncObjs, RzRadChk, RzButton, dxDBTLCl,
  dxGrClms, dxGrClEx, Mask, RzEdit, RzSpnEdt, RzBorder, RzLstBox, ComCtrls,
  RzListVw, Menus, RzBHints;

type

  Tssbcw = (user,ssb,cw,xpar);

  TfrmDSP = class(TForm)
    DSleft: TDataSource;
    DSright: TDataSource;
    dxMemDataLeft: TdxMemData;
    dxMemDataRight: TdxMemData;
    dxMemDataLeftID: TIntegerField;
    dxMemDataLeftVALUE: TIntegerField;
    dxMemDataLeftMULTIPLIER: TIntegerField;
    dxMemDataLeftMAX: TIntegerField;
    dxMemDataLeftMIN: TIntegerField;
    dxMemDataLeftPARAMNAME: TStringField;
    dxMemDataRightID: TIntegerField;
    dxMemDataRightPARAMNAME: TStringField;
    dxMemDataRightVALUE: TIntegerField;
    dxMemDataRightMAX: TIntegerField;
    dxMemDataRightMIN: TIntegerField;
    dxMemDataRightMULTIPLIER: TIntegerField;
    Timer_DSP: TTimer;
    Panel3: TPanel;
    dxMemDataRightUSERNO: TIntegerField;
    dxMemDataLeftUSERNO: TIntegerField;
    dxMemDataLeftENCODER: TIntegerField;
    dxMemDataRightENCODER: TIntegerField;
    dxMemDataLeftDISPLAYVALUE: TStringField;
    dxMemDataRightDISPLAYVALUE: TStringField;
    dxMemDataLeftPARAMNO: TIntegerField;
    dxMemDataRightPARAMNO: TIntegerField;
    Timer_Telem: TTimer;
    dxMemData_Meter: TdxMemData;
    DS_Meters: TDataSource;
    dxMemData_MeterID: TIntegerField;
    dxMemData_MeterNAME: TStringField;
    dxMemData_MeterDB: TIntegerField;
    dxMemData_MeterMETER: TIntegerField;
    dxMemData_MeterMIN: TIntegerField;
    dxMemData_MeterMAX: TIntegerField;
    dxMemData_MeterDIFF: TIntegerField;
    dxMemData_MeterHEX: TStringField;
    dxMemData_MeterPERCENT: TStringField;
    dxMemData_MeterDBPEAK: TIntegerField;
    dxMemData_Gain: TdxMemData;
    DS_Gain: TDataSource;
    dxMemData_GainID: TIntegerField;
    dxMemData_GainMETER: TIntegerField;
    dxMemData_GainGAIN: TIntegerField;
    dxMemData_GainADCDB: TIntegerField;
    dxMemData_GainAGCDB: TIntegerField;
    Timer_Close: TTimer;
    dxMemDataLeftXPARAM: TSmallintField;
    dxMemDataRightXPARAM: TSmallintField;
    DSmid: TDataSource;
    dxMemDataMid: TdxMemData;
    IntegerField1: TIntegerField;
    IntegerField2: TIntegerField;
    StringField1: TStringField;
    SmallintField1: TSmallintField;
    StringField2: TStringField;
    IntegerField3: TIntegerField;
    IntegerField4: TIntegerField;
    IntegerField5: TIntegerField;
    IntegerField6: TIntegerField;
    IntegerField7: TIntegerField;
    IntegerField8: TIntegerField;
    RzPanel_RT: TRzPanel;
    RzPanel6: TRzPanel;
    RzPanel4: TRzPanel;
    RzPanel2: TRzPanel;
    RzLabel_ss: TRzLabel;
    RzMeter_Smeter: TRzMeter;
    RzLabel_S1: TRzLabel;
    RzLabel_S930: TRzLabel;
    RzLabel_S9: TRzLabel;
    RzLabel_S5: TRzLabel;
    RzLabel_Hang: TRzLabel;
    RzLabel_Spike: TRzLabel;
    RzPanel5: TRzPanel;
    Panel1: TPanel;
    RzLabel_GainLeft: TRzLabel;
    RzLabel_GainRight: TRzLabel;
    RzLabel_AD603: TRzLabel;
    RzLabel_DAC: TRzLabel;
    RzLabel_AD603gain: TRzLabel;
    RzLabel_ADC: TRzLabel;
    RzLabel_AGC: TRzLabel;
    dxDBGrid_Gain: TdxDBGrid;
    GainCol_Meter: TdxDBGridColumn;
    GainCol_Id: TdxDBGridColumn;
    GainCol_gain: TdxDBGridColumn;
    GainCol_ADCdb: TdxDBGridColumn;
    GainCol_agcdb: TdxDBGridColumn;
    RzChBox_Lock: TRzCheckBox;
    RzBitBtn_ZeroMaxMin: TRzBitBtn;
    dxDBGrid_Meter: TdxDBGrid;
    Mcol_Id: TdxDBGridColumn;
    Mcol_Name: TdxDBGridColumn;
    Mcol_Hex: TdxDBGridColumn;
    Mcol_Percent: TdxDBGridColumn;
    Mcol_dB: TdxDBGridColumn;
    MCol_Meter: TdxDBGridColumn;
    Mcol_MIn: TdxDBGridColumn;
    Mcol_Max: TdxDBGridColumn;
    Mcol_Diff: TdxDBGridColumn;
    Mcol_DbPeak: TdxDBGridColumn;
    RzPanel3: TRzPanel;
    dxDBGrid_DSPleft: TdxDBGrid;
    Leftcol_Id: TdxDBGridColumn;
    Leftcol_UserNo: TdxDBGridColumn;
    Leftcol_ParamName: TdxDBGridColumn;
    LeftCol_Xparam: TdxDBGridColumn;
    Leftcol_DisplayValue: TdxDBGridPopupColumn;
    Leftcol_Mult: TdxDBGridColumn;
    Leftcol_Max: TdxDBGridColumn;
    Leftcol_Min: TdxDBGridColumn;
    Leftcol_Encoder: TdxDBGridColumn;
    LeftCol_Value: TdxDBGridColumn;
    LeftCol_ParamNo: TdxDBGridColumn;
    RzSpinEdit_ValueLeft: TRzSpinEdit;
    dxDBGrid_DSPmid: TdxDBGrid;
    Midcol_Id: TdxDBGridColumn;
    Midcol_UserNo: TdxDBGridColumn;
    Midcol_ParamName: TdxDBGridColumn;
    Midcol_Xparam: TdxDBGridColumn;
    Midcol_DisplayValue: TdxDBGridPopupColumn;
    Midcol_Mult: TdxDBGridColumn;
    Midcol_Max: TdxDBGridColumn;
    Midcol_Min: TdxDBGridColumn;
    Midcol_Encoder: TdxDBGridColumn;
    Midcol_Value: TdxDBGridColumn;
    Midcol_ParamNo: TdxDBGridColumn;
    RzSpinEdit_ValueMid: TRzSpinEdit;
    dxDBGrid_DSPright: TdxDBGrid;
    Rightcol_Id: TdxDBGridColumn;
    Rightcol_UserNo: TdxDBGridColumn;
    Rightcol_ParamName: TdxDBGridColumn;
    RightCol_Xparam: TdxDBGridColumn;
    Rightcol_DisplayValue: TdxDBGridPopupColumn;
    Rightcol_Mult: TdxDBGridColumn;
    Rightcol_Max: TdxDBGridColumn;
    Rightcol_Min: TdxDBGridColumn;
    Rightcol_Encoder: TdxDBGridColumn;
    RightCol_Value: TdxDBGridColumn;
    RightCol_ParamNo: TdxDBGridColumn;
    RzSpinEdit_ValueRight: TRzSpinEdit;
    Panel5: TPanel;
    Panel4: TPanel;
    RzLabel_Telem: TRzLabel;
    RzPanel1: TRzPanel;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzChBx_Denoiser: TRzCheckBox;
    RzChBx_AutoNotch: TRzCheckBox;
    RzChBx_NoiseBlank: TRzCheckBox;
    RzChBx_ManualNotch: TRzCheckBox;
    RzChBx_VoxQsk: TRzCheckBox;
    RzChBx_SpeechComp: TRzCheckBox;
    RzBitBtn_Width: TRzBitBtn;
    RzBitBtn_Mode: TRzBitBtn;
    RzBitBtn_Red: TRzBitBtn;
    RzBitBtn_Green: TRzBitBtn;
    RzBitBtn_Yellow: TRzBitBtn;
    PopupMenu_Left: TPopupMenu;
    MI_Set254_Left: TMenuItem;
    MI_SetBackup_Left: TMenuItem;
    PopupMenu_Mid: TPopupMenu;
    MI_Set254_Mid: TMenuItem;
    MI_SetBackup_Mid: TMenuItem;
    PopupMenu_Right: TPopupMenu;
    MI_Set254_Right: TMenuItem;
    MI_SetBackup_Right: TMenuItem;
    PopupMenu_Nul: TPopupMenu;
    dddd1: TMenuItem;
    RzChBox_LockXparams: TRzCheckBox;
    RzPanel7: TRzPanel;
    RzMeter_Fwd: TRzMeter;
    RzMeter_Ref: TRzMeter;
    RzMeter_SWR: TRzMeter;
    RzLabel92: TRzLabel;
    RzLabel94: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel_Fwd3: TRzLabel;
    RzLabel_Fwd2: TRzLabel;
    RzLabel_Fwd1: TRzLabel;
    RzLabel7: TRzLabel;
    RzLabel_Ref3: TRzLabel;
    RzLabel9: TRzLabel;
    RzLabel_Ref2: TRzLabel;
    RzLabel11: TRzLabel;
    RzLabel_Ref1: TRzLabel;
    RzLabel13: TRzLabel;
    RzLabel14: TRzLabel;
    RzLabel15: TRzLabel;
    RzBitBtn_Help: TRzBitBtn;
    RzBitBtn_Bkp: TRzBitBtn;
    RzBitBtn_Close: TRzBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer_DSPTimer(Sender: TObject);
    procedure dxDBGrid_DSPrightCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure dxDBGrid_DSPleftCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure dxMemDataLeftCalcFields(DataSet: TDataSet);
    procedure dxMemDataRightCalcFields(DataSet: TDataSet);
    procedure Leftcol_DisplayValueInitPopup(Sender: TObject);
    procedure RzSpinEdit_ValueRightChange(Sender: TObject);
    procedure RzSpinEdit_ValueLeftChange(Sender: TObject);
    procedure dxDBGrid_DSPrightMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure dxDBGrid_DSPleftMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure RzChBx_DenoiserClick(Sender: TObject);
    procedure RzChBx_NoiseBlankClick(Sender: TObject);
    procedure RzChBx_AutoNotchClick(Sender: TObject);
    procedure RzChBx_ManualNotchClick(Sender: TObject);
    procedure RzChBx_VoxQskClick(Sender: TObject);
    procedure RzChBx_SpeechCompClick(Sender: TObject);
    procedure RzBitBtn_WidthClick(Sender: TObject);
    procedure RzBitBtn_ModeClick(Sender: TObject);
    procedure RzBitBtn_GreenClick(Sender: TObject);
    procedure RzBitBtn_RedClick(Sender: TObject);
    procedure RzBitBtn_YellowClick(Sender: TObject);
    procedure Timer_TelemTimer(Sender: TObject);
    procedure dxDBGrid_MeterCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure dxDBGrid_GainCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure RzBitBtn_ZeroMaxMinClick(Sender: TObject);
    procedure RzBitBtn1Click(Sender: TObject);
    procedure Timer_CloseTimer(Sender: TObject);
    procedure dxDBGrid_DSPmidCustomDrawCell(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
      AColumn: TdxTreeListColumn; ASelected, AFocused,
      ANewItemRow: Boolean; var AText: String; var AColor: TColor;
      AFont: TFont; var AAlignment: TAlignment; var ADone: Boolean);
    procedure dxDBGrid_DSPmidMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure dxMemDataMidCalcFields(DataSet: TDataSet);
    procedure Midcol_DisplayValueInitPopup(Sender: TObject);
    procedure RzSpinEdit_ValueMidChange(Sender: TObject);
    procedure Rightcol_DisplayValueInitPopup(Sender: TObject);
    procedure MI_SetBackup_LeftClick(Sender: TObject);
    procedure MI_SetBackup_MidClick(Sender: TObject);
    procedure MI_SetBackup_RightClick(Sender: TObject);
    procedure MI_Set254_LeftClick(Sender: TObject);
    procedure MI_Set254_MidClick(Sender: TObject);
    procedure MI_Set254_RightClick(Sender: TObject);
    procedure RzBitBtn_BkpClick(Sender: TObject);
    procedure RzBitBtn_CloseClick(Sender: TObject);
    procedure RzBitBtn_HelpClick(Sender: TObject);
  private
    ////   telemetry varaibles - correspond to XLP loader
    Adc: word;
    HangStuff: byte;
    DAC: word;
    Dev1: word;
    Dev2: word;
    Dev3: word;
    Dev4: word;
    Dev5: word;
    Dev6: word;
    SmeterdB: byte;
    SPK: byte;
    GN: byte;
    SLed: word;
    Need254: boolean;
    uartADCgain: byte;
    FwdDeciwattsDSP: word;
    RefDeciwattsDSP: word;
    SWRx100DSP: word;
    FwdFsDeciWatts: word;
    RefFsDeciWatts: word;
    FieldsReset: boolean;
    dbpeakr: array[1..8] of single;
    dbmax: array[1..8] of byte;
    dbmin: array[1..8] of byte;
    PrevE: array[1..60] of integer;
    PrevV: array[1..60] of integer;
    ////////////////////////////////
    TelemTransmit: boolean;
    telembuf: array[0..29] of byte;
    OneParamNo: byte;
    OneParamValue: byte;
    ValueColumnClicked: boolean;
    DspDelayEvent: TEvent;
    Testbool: boolean;
    valbuf: array[0..114] of byte;
    buf254: array[11..100] of byte;
    SSBCWmode: byte;
    FilterSwitch: byte;
    ParamColourCode: byte;
    PrevSSBCWmode: byte;
    PrevParamColourCode: byte;
    EncoderPotsParams: array[1..10] of byte;
    PrevEncoderPotsParams: array[1..10] of byte;
    ssbcw: Tssbcw;
    Transmit: boolean;
    EditingNodeMultiplier: real;
    EditingNodeValue: real;
    EditingNodeParamno: byte;
    EditCount: integer;
    LeftIdFieldIndex: integer;
    LeftUsernoFieldIndex: integer;
    LeftParamnoFieldIndex: integer;
    LeftParamNameFieldIndex: integer;
    LeftXparamFieldIndex: integer;
    LeftDisplayValueFieldIndex: integer;
    LeftValueFieldIndex: integer;
    LeftMultiplierFieldIndex: integer;
    LeftMaxFieldIndex: integer;
    LeftMinFieldINdex: integer;
    LeftEncoderFieldIndex: integer;
    MidIdFieldIndex: integer;
    MidUsernoFieldIndex: integer;
    MidParamnoFieldIndex: integer;
    MidParamNameFieldIndex: integer;
    MidXparamFieldIndex: integer;
    MidDisplayValueFieldIndex: integer;
    MidValueFieldIndex: integer;
    MidMultiplierFieldIndex: integer;
    MidMaxFieldIndex: integer;
    MidMinFieldIndex: integer;
    MidEncoderFieldIndex: integer;
    RightIdFieldIndex: integer;
    RightUsernoFieldIndex: integer;
    RightParamnoFieldIndex: integer;
    RightParamNameFieldIndex: integer;
    RightXparamFieldIndex: integer;
    RightDisplayValueFieldIndex: integer;
    RightValueFieldIndex: integer;
    RightMultiplierFieldIndex: integer;
    RightMaxFieldIndex: integer;
    RightMinFieldIndex: integer;
    RightEncoderFieldIndex: integer;
    MeterIdFieldIndex: integer;
    MeterNameFieldIndex: integer;
    MeterHexFieldIndex: integer;
    MeterPercentFieldIndex: integer;
    MeterDbFieldIndex: integer;
    MeterMeterFieldIndex: integer;
    MeterMinFieldIndex: integer;
    MeterMaxFieldIndex: integer;
    MeterDiffFieldIndex: integer;
    MeterDbPeakFieldIndex: integer;
    GainBarGainFieldIndex: integer;
    GainBarADCDBFieldIndex: integer;
    GainBarAGCDBFieldIndex: integer;
    ParamColourSendCode: byte;
    DenoiserClicked: boolean;
    NoiseBlankClicked: boolean;
    AutoNotchClicked: boolean;
    ManualNotchClicked: boolean;
    VoxQskClicked: boolean;
    SpeechCompClicked: boolean;
   function MatchEncodersPots(userno: byte): byte;
    function Encoders8Change: boolean;
    procedure SetPopupMenus;
    procedure SetFields;
    procedure SetSwitches;
    procedure UpdateValues;
    procedure SetButtonColours;
    procedure SetUpColourSend(colour: byte);
    function SmeterText(db: byte): string;
    procedure UpdateMeter;
    procedure ZeroMaxMin;
    procedure SetupMeter;
    procedure DoSmeter;
    procedure DoGain;
    procedure SetupGainBar;
    procedure SendDSPcommandRS232(p,v: byte);
    procedure SendEditedParam;
    procedure SetSwrMeters(transmit: boolean);
    procedure RequestSwrCalFromUSB;
  public
    function SendOneTrxAvrParam: boolean;
    function SendParamColour: boolean;
    procedure Initialise;
    procedure ReadTrxavrParams;
    procedure Read254;
    procedure SetParamToBackup;
    procedure ReceiveTelemetry;
    procedure SetUsbCom(mode: char);
    procedure Send254;
    procedure GetSwrCalFromUSB;
    procedure CopyParamsToBackup;
  end;

  {
const
  ParamList: array[1..47,user..cw] of byte
  =  ((11,11,11),(12,12,12),(13,13,13),(14,14,14),
      (21,21,21),(22,22,22),(23,23,23),(24,24,24),(25,25,25),
      (31,31,31),(32,32,32),(33,33,33),
      (41,41,41),(42,42,42),(43,43,43),(44,44,44),(45,45,45),(46,46,46),(47,47,47),
      (51,51,51),(52,52,52),(53,53,53),(54,54,54),(55,55,55),(56,56,56),(57,57,57),(58,58,58),
      (61,62,61),(62,63,64),(63,65,66),(64,67,67),(65,68,68),(66,69,69),
      (71,71,71),(72,72,73),(73,74,74),(74,75,75),(75,76,76),(76,77,77),//(77,77,77),
      (81,81,81),(82,82,82),(83,83,83),(84,84,84),(85,85,85),
      (91,91,93),(92,92,94),(93,95,95));
    }

const
  ParamList: array[1..59,user..xpar] of byte
  =  ((11,11,11,0),(12,12,12,0),(13,13,13,0),(14,14,14,0),
      (15,15,15,1),(16,16,16,1),(17,17,17,1),(18,18,18,1),(19,19,19,1),   // xparams
      (21,21,21,0),(22,22,22,0),(23,23,23,0),(24,24,24,0),(25,25,25,0),
      (26,26,26,1),(27,27,27,1),(28,28,28,1),(29,29,29,1),                // xparams
      (31,31,31,0),(32,32,32,0),(33,33,33,0),
      (41,41,41,0),(42,42,42,0),(43,43,43,0),(44,44,44,0),(45,45,45,0),(46,46,46,0),(47,47,47,0),
      (51,51,51,0),(52,52,52,0),(53,53,53,0),(54,54,54,0),(55,55,55,0),(56,56,56,0),(57,57,57,0),(58,58,58,0),
      (61,62,61,0),(62,63,64,0),(63,65,66,0),(64,67,67,0),(65,68,68,0),(66,69,69,0),
      (71,71,71,0),(72,72,73,0),(73,74,74,0),(74,75,75,0),(75,76,76,0),(76,77,77,0),
      (77,78,78,1),(78,79,79,1),     // xparams
      (81,81,81,0),(82,82,82,0),(83,83,83,0),(84,84,84,0),(85,85,85,0),
      (86,86,86,1),        // xparam
      (91,91,93,0),(92,92,94,0),(93,95,95,0));

  MeterNameList: array[1..8,0..1] of string[18]
  = (('Rx input',         'Mic input'),
     ('Noise blank',      'After decimation'),
     ('After filter',     'After noise gate'),
     ('After AGC',        'After filter'),
     ('Auto notch output','After VOGAD'),
     ('Denoiser output',  'After compression'),
     ('Before AF gain',   'Tx monitor out'),
     ('Rx AF out',        'Tx IF out'));

  BarColours: array[0..9] of TColor
  = (clGray,clOlive,clTeal,clMaroon,clNavy,clPurple,clGreen,clBlue,clRed,clRed);


var
  frmDSP: TfrmDSP;

implementation

uses UParams, UfrmMain, UUsb, D2XXUnit,UGlobals,UfrmDspValuePopup,
     UIniData, About;

{$R *.dfm}


procedure TfrmDSP.Initialise;
var
  i: byte;
begin
  for i := 1 to 48 do PrevE[i] := 49999;
  for i := 1 to 48 do PrevV[i] := 49999;
  for i := 1 to 99 do buf254[i] := 0;
  RzChBox_LockXparams.Checked := true;
  Need254 := true;
  Timer_Close.Enabled := false;
  if g_RegIniData.IniDspTelemetry = 0
  then SetUsbCom('U')
  else SetUsbCom('S');
  RequestSwrCalFromUSB;
  Params.paInputCalCurve;
  ValueColumnClicked := false;
  EditCount := 0;
  RzChBox_Lock.checked := false;
  with dxDBGrid_DSPLeft do
  begin
    LeftIdFieldIndex := ColumnByFieldName('ID').index;
    LeftUsernoFieldIndex := ColumnByFieldName('USERNO').index;
    LeftParamnoFieldIndex := ColumnByFieldName('PARAMNO').index;
    LeftParamNameFieldIndex := ColumnByFieldName('PARAMNAME').index;
    LeftXparamFieldIndex := ColumnByFieldName('XPARAM').index;
    LeftDisplayValueFieldIndex := ColumnByFieldName('DISPLAYVALUE').index;
    LeftValueFieldIndex := ColumnByFieldName('VALUE').index;
    LeftMultiplierFieldIndex := ColumnByFieldName('MULTIPLIER').index;
    LeftMaxFieldIndex := ColumnByFieldName('MAX').index;
    LeftMinFieldIndex := ColumnByFieldName('MIN').index;
    LeftEncoderFieldIndex := ColumnByFieldName('ENCODER').index;
  end;
  with dxDBGrid_DSPMid do
  begin
    MidIdFieldIndex := ColumnByFieldName('ID').index;
    MidUsernoFieldIndex := ColumnByFieldName('USERNO').index;
    MidParamnoFieldIndex := ColumnByFieldName('PARAMNO').index;
    MidParamNameFieldIndex := ColumnByFieldName('PARAMNAME').index;
    MidXparamFieldIndex := ColumnByFieldName('XPARAM').index;
    MidDisplayValueFieldIndex := ColumnByFieldName('DISPLAYVALUE').index;
    MidValueFieldIndex := ColumnByFieldName('VALUE').index;
    MidMultiplierFieldIndex := ColumnByFieldName('MULTIPLIER').index;
    MidMaxFieldIndex := ColumnByFieldName('MAX').index;
    MidMinFieldIndex := ColumnByFieldName('MIN').index;
    MidEncoderFieldIndex := ColumnByFieldName('ENCODER').index;
  end;
  with dxDBGrid_DSPRight do
  begin
    RightIdFieldIndex := ColumnByFieldName('ID').index;
    RightUsernoFieldIndex := ColumnByFieldName('USERNO').index;
    RightParamnoFieldIndex := ColumnByFieldName('PARAMNO').index;
    RightParamNameFieldIndex := ColumnByFieldName('PARAMNAME').index;
    RightXparamFieldIndex := ColumnByFieldName('XPARAM').index;
    RightDisplayValueFieldIndex := ColumnByFieldName('DISPLAYVALUE').index;
    RightValueFieldIndex := ColumnByFieldName('VALUE').index;
    RightMultiplierFieldIndex := ColumnByFieldName('MULTIPLIER').index;
    RightMaxFieldIndex := ColumnByFieldName('MAX').index;
    RightMinFieldIndex := ColumnByFieldName('MIN').index;
    RightEncoderFieldIndex := ColumnByFieldName('ENCODER').index;
  end;
  with dxDBGrid_Meter do
  begin
    MeterIdFieldIndex := ColumnByFieldName('ID').index;
    MeterNameFieldIndex := ColumnByFieldName('NAME').index;
    MeterHexFieldIndex := ColumnByFieldName('HEX').index;
    MeterPercentFieldIndex := ColumnByFieldName('PERCENT').index;
    MeterDbFieldIndex := ColumnByFieldName('DB').index;
    MeterMeterFieldIndex := ColumnByFieldName('METER').index;
    MeterMinFieldIndex := ColumnByFieldName('MIN').index;
    MeterMaxFieldIndex := ColumnByFieldName('MAX').index;
    MeterDiffFieldIndex := ColumnByFieldName('DIFF').index;
    MeterDbPeakFieldIndex := ColumnByFieldName('DBPEAK').index;
  end;
  with dxDBGrid_Gain do
  begin
    GainBarGainFieldIndex := ColumnByFieldName('GAIN').index;
    GainBarADCDBFieldIndex := ColumnByFieldName('ADCDB').index;
    GainBarAGCDBFieldIndex := ColumnByFieldName('AGCDB').index;
  end;
  ZeroMaxMin;
  DspDelayEvent := TEvent.Create(0, true, false, 'Hobcat DSP delay event');
  dxMemDataLeft.Open;
  dxMemDataRight.Open;
  PrevSSBCWmode := 99;     //  force SetFields
  PrevParamColourCode := panone;   // force SetFields
  for i := 1 to 10 do PrevEncoderPotsParams[i] := 0;
  SetFields;
  SetupMeter;
  SetupGainBar;
  DenoiserClicked := false;
  NoiseBlankClicked := false;
  AutoNotchClicked := false;
  ManualNotchClicked := false;
  VoxQSKClicked := false;
  SpeechCompClicked := false;
  Timer_DSP.Enabled := true;
  Timer_Telem.Enabled := true;
end;




procedure TfrmDSP.RequestSwrCalFromUSB;
begin
  if TelemMode <> 'U' then exit;
  frmMain.USBstate[dspswrcal] := 'W';
end;

procedure TfrmDSP.GetSwrCalFromUSB;
var
  ReceivedOk: boolean;
  i: byte;
  calbuf: array[0..3] of byte;
begin
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$SWR_F');
    DspDelayEvent.ResetEvent;
    DspDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    ReceivedOk := Usb.usReceiveBlock(@calbuf[0],4);
    if ReceivedOk then
    begin
      FwdFsDeciWatts := calbuf[0] + 256*calbuf[1];
      RefFsDeciWatts := calbuf[2] + 256*calbuf[3];
    end
    else begin
      FwdFsDeciWatts := 140;
      RefFsDeciWatts := 20;
    end;
  end;
  i := 4;
  case FwdFsDeciWatts of
     75: i := 0;
    150: i := 1;
    300: i := 2;
    750: i := 3;
   1500: i := 4;
  end;
  RzLabel_Fwd1.Caption := g_PowerLabels[i,1];
  RzLabel_Fwd2.Caption := g_PowerLabels[i,2];
  RzLabel_Fwd3.Caption := g_PowerLabels[i,3];
  i := 4;
  case RefFsDeciWatts of
     75: i := 0;
    150: i := 1;
    300: i := 2;
    750: i := 3;
   1500: i := 4;
  end;
  RzLabel_Ref1.Caption := g_PowerLabels[i,1];
  RzLabel_Ref2.Caption := g_PowerLabels[i,2];
  RzLabel_Ref3.Caption := g_PowerLabels[i,3];

end;



procedure TfrmDSP.CopyParamsToBackup;
begin
  Purge_USB_Device_In;
  Usb.usSendString('$$$DSP_W');
end;


procedure TfrmDSP.SetUsbCom(mode: char);
begin
  TelemMode := mode;
  if TelemMode = 'U' then
  begin
    RzLabel_Telem.Caption := 'USB-TrxAVR' ;
  //  frmMain.StarComPort.Close;
  end
  else begin
    RzLabel_Telem.Caption := 'Serial-DSP';
    frmMain.StarComPort.Open;
  end;
end;


procedure TfrmDSP.SetPopupMenus;
begin
  case ParamColourCode of
    1: begin      // green parameter set
         MI_Set254_Left.visible := false;
         MI_Set254_Mid.visible := false;
         MI_Set254_Right.visible := false;
         MI_SetBackup_Left.Caption := 'Set this green param to backup value';
         MI_SetBackup_Mid.Caption := 'Set this green param to backup value';
         MI_SetBackup_Right.Caption := 'Set this green param to backup value';
         RzSpinEdit_ValueLeft.Hint := 'Right click to set backup value';
         RzSpinEdit_ValueMid.Hint := 'Right click to set backup value';
         RzSpinEdit_ValueRight.Hint := 'Right click to set backup value';
       end;
    2: begin      // yellow parameter set
         MI_Set254_Left.visible := true;
         MI_Set254_Mid.visible := true;
         MI_Set254_Right.visible := true;
         MI_SetBackup_Left.Caption := 'Set this yellow param to backup value';
         MI_SetBackup_Mid.Caption := 'Set this yellow param to backup value';
         MI_SetBackup_Right.Caption := 'Set this yellow param to backup value';
         MI_Set254_Left.Caption := 'Set this yellow param to use green value';
         MI_Set254_Mid.Caption := 'Set this yellow param to use green value';
         MI_Set254_Right.Caption := 'Set this yellow param to use green value';
         RzSpinEdit_ValueLeft.Hint := 'Right click to use green value or backup value';
         RzSpinEdit_ValueMid.Hint := 'Right click to use green value or backup value';
         RzSpinEdit_ValueRight.Hint := 'Right click to use green value or backup value';
       end;
    3: begin      // red parameter set
         MI_Set254_Left.visible := true;
         MI_Set254_Mid.visible := true;
         MI_Set254_Right.visible := true;
         MI_SetBackup_Left.Caption := 'Set this red param to backup value';
         MI_SetBackup_Mid.Caption := 'Set this red param to backup value';
         MI_SetBackup_Right.Caption := 'Set this red param to backup value';
         MI_Set254_Left.Caption := 'Set this red param to use green value';
         MI_Set254_Mid.Caption := 'Set this red param to use green value';
         MI_Set254_Right.Caption := 'Set this red param to use green value';
         RzSpinEdit_ValueLeft.Hint := 'Right click to use green value or backup value';
         RzSpinEdit_ValueMid.Hint := 'Right click to use green value or backup value';
         RzSpinEdit_ValueRight.Hint := 'Right click to use green value or backup value';
       end;
  end;



end;


procedure TfrmDSP.SetButtonColours;
begin
  case ParamColourCode of
    1: begin      // green parameter set
         RzBitBtn_Green.Font.Style := [fsBold];
         RzBitBtn_Yellow.Font.Style := [];
         RzBitBtn_Red.Font.Style := [];
         RzBitBtn_Green.Color := clLime;
         RzBitBtn_Red.Color := clPaleRed;
         RzBitBtn_Yellow.Color := clPaleYellow;
       end;
    2: begin      // yellow parameter set
         RzBitBtn_Green.Font.Style := [];
         RzBitBtn_Yellow.Font.Style := [fsBold];
         RzBitBtn_Red.Font.Style := [];
         RzBitBtn_Green.Color := clPaleGreen;
         RzBitBtn_Red.Color := clPaleRed;
         RzBitBtn_Yellow.Color := clDeepYellow;
       end;
    3: begin      // red parameter set
         RzBitBtn_Green.Font.Style := [];
         RzBitBtn_Yellow.Font.Style := [];
         RzBitBtn_Red.Font.Style := [fsBold];
         RzBitBtn_Green.Color := clPaleGreen;
         RzBitBtn_Red.Color := clRed;
         RzBitBtn_Yellow.Color := clPaleYellow;
       end;
  end;
end;



procedure TfrmDSP.Send254;
var
  IntValue: integer;
begin
  OneParamValue := 254;
  OneParamNo := EditingNodeParamNo;
  buf254[OneParamNo] := 254;
  if TelemMode = 'S'
  then SendDSPcommandRS232(OneParamNo,OneParamValue)
  else frmMain.USBstate[oneparam] := 'W';
end;




function TfrmDSP.SendOneTrxAVRParam: boolean;
var
  block: array[0..1] of byte;
begin
  result := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DSP_Q') then exit;
  block[0] := OneParamNo;
  block[1] := OneParamValue;
  if not Usb.usSendBlock(@block,2) then exit;     //  sent byte count
  result := true;
end;


procedure TfrmDSP.SendEditedParam;
var
  IntValue: integer;
begin
  IntValue := trunc(EditingNodeValue*100/EditingNodeMultiplier + 0.001);
  OneParamValue := IntValue;
  OneParamNo := EditingNodeParamNo;
  buf254[OneParamNo] := IntValue; // no effect if on green
  if TelemMode = 'S'
  then SendDSPcommandRS232(OneParamNo,OneParamValue)
  else frmMain.USBstate[oneparam] := 'W';
end;


procedure TfrmDSP.SetParamToBackup;
var
  block: array[0..2] of byte;
begin
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DSP_B') then exit;
  block[0] := EditingNodeParamNo;
  block[1] := ParamColourCode;
  block[2] := SSBCWmode;
  Usb.usSendBlock(@block,3);
end;



function TfrmDSP.SendParamColour: boolean;
var
  block: array[0..1] of byte;
begin
  result := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DSP_L') then exit;
  block[0] := ParamColourSendCode;
  block[1] := 0;
  if not Usb.usSendBlock(@block,2) then exit;     //  sent byte count
  result := true;
end;


function TfrmDSP.Encoders8Change: boolean;
var
  i: byte;
begin
  result := false;
  for i := 1 to 10 do
  begin
    if EncoderPotsParams[i] <> PrevEncoderPotsParams[i] then
    begin
      result := true;
      PrevEncoderPotsParams[i] := EncoderPotsParams[i];
    end;
  end;
end;

function TfrmDSP.MatchEncodersPots(userno: byte): byte;
var
  i: byte;
begin
  for i := 1 to 10 do
  begin
    if EncoderPotsParams[i] = userno then
    begin
      result := i;
      exit;
    end
  end;
  result := 0;
end;


procedure TfrmDSP.SetFields;
var
  i,Id,paramno,userno, xparam: integer;
  memdata: TdxMemData;
begin
  Id := 0;
  memdata := dxMemDataLeft;
  memdata.Close;
  memdata.Open;
  for i := 1 to 59 do     // 48**
  begin
    inc(Id);
    if i=21 then
    begin
      memdata := dxmemDataMid;
      memdata.Close;
      memdata.Open;
    end;
    if i=41 then
    begin
      memdata := dxmemDataRight;
      memdata.Close;
      memdata.Open;
    end;
    paramno := ParamList[i,ssbcw];  //  sscw  is ssb or cw   - gives mode parameter no
    userno := ParamList[i,user];    //user is constant - gives userno
    xparam := ParamList[i,xpar];      // 1 = xparam,  0 = ordinary param
    with Params, memdata do
    begin
      Append;
      FieldValues['Id'] := Id;
      FieldValues['USERNO'] := userno;
      FieldValues['XPARAM'] := xparam;
      FieldValues['PARAMNAME'] := paName[paramno];
      FieldValues['PARAMNO'] := paramno;
      FieldValues['VALUE'] := 0;
      FieldValues['MULTIPLIER'] := paMult[paramno];
      FieldValues['MAX'] := paPmax[paramno];
      FieldValues['MIN'] := paPmin[paramno];
      FieldValues['ENCODER'] := 0;
      Post;
    end;
  end;
end;



procedure TfrmDSP.UpdateValues;
var
  Id: integer;
  paramno, userno: integer;
  V, E: integer;
begin
  Id := 0;
  with dxMemDataLeft do
  begin
    for Id := 1 to 20  do
    begin
      paramno := ParamList[Id,ssbcw];
      userno := ParamList[Id,user];    //user is constant - gives userno
      V := valbuf[paramno];
      E := MatchEncodersPots(userno);
      if (V<>PrevV[Id]) OR (E <> PrevE[Id]) OR FieldsReset then
      begin
        Locate('ID',Id,[]);
        Edit;
        FieldValues['VALUE'] := V;
        FieldValues['ENCODER'] := IntToStr(E);
        Post;
      end;
      PrevV[Id] := V;
      PrevE[Id] := E;
    end;
  end;
  with dxMemDataMid do
  begin
    for Id := 21 to 40  do
    begin
      paramno := ParamList[Id,ssbcw];
      userno := ParamList[Id,user];    //user is constant - gives userno
      V := valbuf[paramno];
      E := MatchEncodersPots(userno);
      if(V<>PrevV[Id]) OR (E <> PrevE[Id]) OR FieldsReset then
      begin
        Locate('ID',Id,[]);
        Edit;
        FieldValues['VALUE'] := V;
        FieldValues['ENCODER'] := IntToStr(E);
        Post;
      end;
      PrevV[Id] := V;
      PrevE[Id] := E;
    end;
  end;
  with dxMemDataRight do
  begin
    for Id := 41 to 59  do
    begin
      paramno := ParamList[Id,ssbcw];
      userno := ParamList[Id,user];    //user is constant - gives userno
      V := valbuf[paramno];
      E := MatchEncodersPots(userno);
      if(V<>PrevV[Id]) OR (E <> PrevE[Id]) OR FieldsReset then
      begin
        Locate('ID',Id,[]);
        Edit;
        FieldValues['VALUE'] := V;
        FieldValues['ENCODER'] := IntToStr(E);
        Post;
      end;
      PrevV[Id] := V;
      PrevE[Id] := E;
    end;
  end;
end;





procedure TfrmDSP.Timer_DSPTimer(Sender: TObject);
begin
  Application.ProcessMessages;
  if not g_UsbReady then exit;
  if RzChBox_Lock.checked then exit;
  if ValueColumnClicked then
  begin
    inc(EditCount);
    if EditCount < 10 then exit;
    EditCount := 0;
    ValueColumnClicked := false;
  end;
  if RzSpinEdit_ValueLeft.Visible
  OR RzSpinEdit_ValueMid.Visible
  OR RzSpinEdit_ValueRight.Visible
  then exit;
  if TelemMode = 'U' then frmMain.USBstate[dspgetall] := 'W';
end;


procedure TfrmDSP.ReadTrxavrParams;
var
  ReceivedOk: boolean;
  i: byte;
begin
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$DSP_A');   // A = all
    DspDelayEvent.ResetEvent;
    DspDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    ReceivedOk := Usb.usReceiveBlock(@valbuf[0],113);
       // 108 = 99 param values,colour, 8 encoder paramnos, 4 pot paramnos
  end;
  if not ReceivedOk then exit;
  Transmit := (valbuf[0] = 1);
  SSBCWmode := valbuf[2];
  FilterSwitch := valbuf[6];
  ParamColourCode := valbuf[10];
  for i := 1 to 10 do EncoderPotsParams[i] := valbuf[100+i];
  if SSBCWmode > 1 then ssbcw := cw else ssbcw := ssb;
  if (SSBCWmode <> PrevSSBCWmode)
  OR (ParamColourCode <> PrevParamColourCode)
  OR Encoders8Change
  then begin
    Read254;
    PrevSSBCWmode := SSBCWmode;
    PrevParamColourCode := ParamColourCode;
    SetPopupMenus;
    SetButtonColours;
    SetFields;
    FieldsReset := true;
  end
  else FieldsReset := false;
  SetSwitches;
  UpdateValues;
end;


procedure TfrmDSP.Read254;
var
  ReceivedOk: boolean;
  i: byte;
begin
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$DSP_G');   // A = all
    DspDelayEvent.ResetEvent;
    DspDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    ReceivedOk := Usb.usReceiveBlock(@buf254[11],90);  // buf254: array[11..100] of byte;
  end;
end;

procedure TfrmDSp.SetSwitches;
var
  b: boolean;
begin
  b := (valbuf[1] > 0);
  if DenoiserClicked then
  begin
    if b = RzChBx_Denoiser.Checked then DenoiserClicked := false;
  end
  else RzChBx_Denoiser.Checked := b;

  b := (valbuf[3] > 0);
  if NoiseBlankClicked then
  begin
    if b = RzChBx_NoiseBlank.checked then NoiseBlankClicked := false;
  end
  else RzChBx_NoiseBlank.Checked := b;

  b := (valbuf[4] > 0);
  if AutoNotchClicked then
  begin
    if b = RzChBx_AutoNotch.checked then AutoNotchClicked := false;
  end
  else RzChBx_AutoNotch.Checked := b;

  b := (valbuf[5] > 0);
  if ManualNotchClicked then
  begin
    if b = RzChBx_ManualNotch.checked then ManualNotchClicked := false;
  end
  else RzChBx_ManualNotch.Checked := b;

  b := (valbuf[7] > 0);
  if VoxQskClicked then
  begin
    if b = RzChBx_VoxQsk.checked then VoxQskClicked := false;
  end
  else RzChBx_VoxQsk.checked := b;

  b := (valbuf[9] > 0);
  if SpeechCompClicked then
  begin
    if b = RzChBx_SpeechComp.checked then SpeechCompClicked := false;
  end
  else RzChBx_SpeechComp.Checked := b;

  if FilterSwitch = 0
  then RzBitBtn_Width.caption := 'Wide'
  else RzBitBtn_Width.caption := 'Nar.';
  case SSBCWmode of
    0: RzBitBtn_Mode.Caption := 'LSB';
    1: RzBitBtn_Mode.Caption := 'USB';
    2: RzBitBtn_Mode.Caption := 'CW_L';
    3: RzBitBtn_Mode.Caption := 'CW_U';
  end;
end;



procedure TfrmDSP.dxDBGrid_DSPrightCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  n: byte;
  paramno: byte;
  value: byte;
begin
  AFocused := false;
  ASelected := false;
//  if ANode.Values[RightEncoderFieldIndex] <> 0 then AColor := clPaleBrown;
  paramno := ANode.Values[RightParamNoFieldIndex];
  value := ANode.Values[RightValueFieldIndex];
  if value = 255 then
  begin
    AText := '';
    exit;
  end;
  if AColumn = RightCol_DisplayValue then
  begin
    if buf254[paramno] = 254 then
    begin
      AColor := clMoneyGreen;
      Afont.Color := clBlack;
    end
    else AFont.Color := clBlue;
  end;
  if (ANode.Values[RightXparamFieldIndex] = 1)
  AND ((AColumn = RightCol_ParamName) OR (AColumn = RightCol_DisplayValue))
  then AFont.Color := clRed;
  if AColumn = RightCol_UserNo then
  begin
    AFont.Color := clMaroon;
  end;
  if (AColumn = RightCol_Encoder) AND (Length(AText)>0) then
  begin
    n := StrToInt(AText);
    if n = 0
    then AText := ''
    else begin
      if n > 8 then
      begin
        AText := chr($38 + n);
        AFont.Color := clBlack;
      end
      else AFont.Color := clMaroon;
    end;
  end;
end;


procedure TfrmDSP.dxDBGrid_DSPmidCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  n, value: byte;
  paramno: byte;
begin
  AFocused := false;
  ASelected := false;
  paramno := ANode.Values[MidParamNoFieldIndex];
  value := ANode.Values[MidValueFieldIndex];
  if AFocused then Acolor := clPaleBrown;
  if value = 255 then
  begin
    AText := '';
    exit;
  end;
  if AColumn = MidCol_DisplayValue then
  begin
    if buf254[paramno] = 254 then
    begin
      AColor := clMoneyGreen;
      Afont.Color := clBlack;
    end
    else AFont.Color := clBlue;
  end;
  if (ANode.Values[MidXparamFieldIndex] = 1)
  AND ((AColumn = MidCol_ParamName) OR (AColumn = MidCol_DisplayValue))
  then AFont.Color := clRed;
  if AColumn = RightCol_UserNo then
  begin
    AFont.Color := clMaroon;
  end;
  if (AColumn = MidCol_Encoder) AND (Length(AText)>0) then
  begin
    n := StrToInt(AText);
    if n = 0
    then AText := ''
    else begin
      if n > 8 then
      begin
        AText := chr($38 + n);
        AFont.Color := clBlack;
      end
      else AFont.Color := clMaroon;
    end;
  end;
end;



procedure TfrmDSP.dxDBGrid_DSPleftCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  paramno,n, value: byte;
begin
  AFocused := false;
  ASelected := false;
  paramno := ANode.Values[LeftParamNoFieldIndex];
  value := ANode.Values[LeftValueFieldIndex];
  if value = 255 then
  begin
    AText := '';
    exit;
  end;
  if AColumn = LeftCol_DisplayValue then
  begin
    if buf254[paramno] = 254 then
    begin
      AColor := clMoneyGreen;
      Afont.Color := clBlack;
    end
    else AFont.Color := clBlue;
  end;
  if (ANode.Values[LeftXparamFieldIndex] = 1)
  AND ((AColumn = LeftCol_ParamName) OR (AColumn = LeftCol_DisplayValue))
  then AFont.Color := clRed;
  if AColumn = LeftCol_UserNo then
  begin
    AFont.Color := clMaroon;
  end;
  if (AColumn = LeftCol_Encoder) AND (Length(AText)>0) then
  begin
    n := StrToInt(AText);
    if n = 0
    then AText := ''
    else begin
      if n > 8 then
      begin
        AText := chr($38 + n);
        AFont.Color := clBlack;
      end
      else AFont.Color := clMaroon;
    end;
  end;
end;

procedure TfrmDSP.dxMemDataLeftCalcFields(DataSet: TDataSet);
var
  mult, value: integer;
  r: real;
begin
  with DataSet do
  begin
    mult := FieldByName('MULTIPLIER').AsInteger;
    value := FieldByName('VALUE').AsInteger;
    if mult = 100
    then FieldValues['DISPLAYVALUE'] := IntToStr(value)
    else begin
      r := Value;
      r := mult*value/100;
      FieldValues['DISPLAYVALUE'] := FloatToStrF(r,ffFixed,3,2);
    end;
  end;
end;

procedure TfrmDSP.dxMemDataMidCalcFields(DataSet: TDataSet);
var
  mult, value: integer;
  r: real;
begin
  with DataSet do
  begin
    mult := FieldByName('MULTIPLIER').AsInteger;
    value := FieldByName('VALUE').AsInteger;
    if mult = 100
    then FieldValues['DISPLAYVALUE'] := IntToStr(value)
    else begin
      r := Value;
      r := mult*value/100;
      FieldValues['DISPLAYVALUE'] := FloatToStrF(r,ffFixed,3,2);
    end;
  end;
end;


procedure TfrmDSP.dxMemDataRightCalcFields(DataSet: TDataSet);
var
  mult, value: integer;
  r: real;
begin
  with DataSet do
  begin
    mult := FieldByName('MULTIPLIER').AsInteger;
    value := FieldByName('VALUE').AsInteger;
    if mult = 100
    then FieldValues['DISPLAYVALUE'] := IntToStr(value)
    else begin
      r := Value;
      r := mult*value/100;
      FieldValues['DISPLAYVALUE'] := FloatToStrF(r,ffFixed,3,2);
    end;
  end;
end;



procedure TfrmDSP.Leftcol_DisplayValueInitPopup(Sender: TObject);
var
 ANode: TdxTreeListNode;
 Mult,Min,Max, Value: integer;
begin
  with dxDBGrid_DSPleft do
  begin
    ANode := FocusedNode;
    Mult := ANode.Values[LeftMultiplierFieldIndex];
    Max := ANode.Values[LeftMaxFieldIndex];
    Min := ANode.Values[LeftMinFieldIndex];
    Value := ANode.Values[LeftValueFieldIndex];
    EditingNodeMultiplier := Mult;
    EditingNodeParamno := ANode.Values[LeftParamnoFieldIndex];
    if (EditingNodeParamno in [15..19,26..29,77,78,86]) AND RzChBox_LockXparams.Checked
    then RzSpinEdit_ValueLeft.Enabled := false
    else begin
      RzSpinEdit_ValueLeft.Enabled := true;
      if Mult = 100 then
      begin
        RzSpinEdit_ValueLeft.Decimals := 0;
        RzSpinEdit_ValueLeft.Increment := 1;
        RzSpinEdit_ValueLeft.IntegersOnly := true;
      end
      else begin
        RzSpinEdit_ValueLeft.Decimals := 2;
        RzSpinEdit_ValueLeft.Increment := Mult/100;
        RzSpinEdit_ValueRight.IntegersOnly := false;
      end;
      //  must set Max andMin before value!!
      RzSpinEdit_ValueLeft.Max := Max*Mult/100;
      RzSpinEdit_ValueLeft.Min := Min*Mult/100;
      RzSpinEdit_ValueLeft.Value := Value*Mult/100;
    end;
  end;
end;

procedure TfrmDSP.Midcol_DisplayValueInitPopup(Sender: TObject);
var
 ANode: TdxTreeListNode;
 Mult,Min,Max, Value: integer;
begin
  with dxDBGrid_DSPmid do
  begin
    ANode := FocusedNode;
    Mult := ANode.Values[MidMultiplierFieldIndex];
    Max := ANode.Values[MidMaxFieldIndex];
    Min := ANode.Values[MidMinFieldIndex];
    Value := ANode.Values[MidValueFieldIndex];
    EditingNodeMultiplier := Mult;
    EditingNodeParamno := ANode.Values[MidParamnoFieldIndex];
    if (EditingNodeParamno in [15..19,26..29,77,78,86]) AND RzChBox_LockXparams.Checked
    then RzSpinEdit_ValueMid.Enabled := false
    else begin
      RzSpinEdit_ValueMid.Enabled := true;
      if Mult = 100 then
      begin
        RzSpinEdit_ValueMid.Decimals := 0;
        RzSpinEdit_ValueMid.Increment := 1;
        RzSpinEdit_ValueMid.IntegersOnly := true;
      end
      else begin
        RzSpinEdit_ValueMid.Decimals := 2;
        RzSpinEdit_ValueMid.Increment := Mult/100;
        RzSpinEdit_ValueMid.IntegersOnly := false;
      end;
      //  must set Max andMin before value!!
      RzSpinEdit_ValueMid.Max := Max*Mult/100;
      RzSpinEdit_ValueMid.Min := Min*Mult/100;
      RzSpinEdit_ValueMid.Value := Value*Mult/100;
    end;
  end;
end;



procedure TfrmDSP.RzSpinEdit_ValueRightChange(Sender: TObject);
begin
  EditingNodeValue := RzSpinEdit_ValueRight.Value;
  SendEditedParam;
end;

procedure TfrmDSP.RzSpinEdit_ValueMidChange(Sender: TObject);
begin
  EditingNodeValue := RzSpinEdit_ValueMid.Value;
  SendEditedParam;
end;

procedure TfrmDSP.RzSpinEdit_ValueLeftChange(Sender: TObject);
begin
  EditingNodeValue := RzSpinEdit_ValueLeft.Value;
  SendEditedParam;
end;

procedure TfrmDSP.Rightcol_DisplayValueInitPopup(Sender: TObject);
var
 ANode: TdxTreeListNode;
 Mult,Min,Max,Value: real;
begin
  with dxDBGrid_DSPright  do
  begin
    ANode := FocusedNode;
    Mult := ANode.Values[RightMultiplierFieldIndex];
    Max := ANode.Values[RightMaxFieldIndex];
    Min := ANode.Values[RightMinFieldIndex];
    Value := ANode.Values[RightValueFieldIndex];
    EditingNodeMultiplier := Mult;
    EditingNodeParamno := ANode.Values[RightParamnoFieldIndex];
    if (EditingNodeParamno in [15..19,26..29,77,78,86]) AND RzChBox_LockXparams.Checked
    then RzSpinEdit_ValueRight.Enabled := false
    else begin
      RzSpinEdit_ValueRight.Enabled := true;
      if Mult = 100 then
      begin
        RzSpinEdit_ValueRight.Decimals := 0;
        RzSpinEdit_ValueRight.Increment := 1;
        RzSpinEdit_ValueRight.IntegersOnly := true;
      end
      else begin
        RzSpinEdit_ValueRight.Decimals := 2;
        RzSpinEdit_ValueRight.Increment := Mult/100;
        RzSpinEdit_ValueRight.IntegersOnly := false;
      end;
      // Must set Max and Min before value - hours wasted !!
      RzSpinEdit_ValueRight.Max := Max*Mult/100;
      RzSpinEdit_ValueRight.Min := Min*Mult/100;
      RzSpinEdit_ValueRight.Value := Value*Mult/100;
    end;
  end;

end;



procedure TfrmDSP.dxDBGrid_DSPleftMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  paramno: integer;
begin
  with dxDbGrid_DSPleft do
  begin
    if GetAbsoluteColumnIndex(FocusedColumn) = ColumnByFieldName('DISPLAYVALUE').index  then
    begin
      ValueColumnClicked := true;
      EditCount := 0;
    end;
  end;
end;


procedure TfrmDSP.dxDBGrid_DSPmidMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with dxDbGrid_DSPmid do
  begin
    if GetAbsoluteColumnIndex(FocusedColumn) = ColumnByFieldName('DISPLAYVALUE').index  then
    begin
      ValueColumnClicked := true;
      EditCount := 0;
    end;
  end;
end;


procedure TfrmDSP.dxDBGrid_DSPrightMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with dxDbGrid_DSPright do
  begin
    if GetAbsoluteColumnIndex(FocusedColumn) = ColumnByFieldName('DISPLAYVALUE').index  then
    begin
      ValueColumnClicked := true;
      EditCount := 0;
    end;
  end;
end;


procedure TfrmDSP.RzChBx_DenoiserClick(Sender: TObject);
begin
  if DenoiserClicked then exit;
  DenoiserClicked := true;
  if RzChBx_Denoiser.Checked = true
  then OneParamValue := 1
  else OneParamValue := 0;
  if TelemMode = 'S'
  then SendDSPcommandRS232(1,OneParamValue)
  else begin
    if frmMain.USBstate[oneparam] = 'W' then exit;
    frmMain.USBstate[dspgetall] := 'X';
    OneParamNo := 1;
    frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzChBx_NoiseBlankClick(Sender: TObject);
var
  v: byte;
begin
  if NoiseBlankClicked then exit;
  NoiseBlankClicked := true;
  if RzChBx_NoiseBlank.Checked = true
  then OneParamValue := 1
  else OneParamValue := 0;
  if TelemMode = 'S'
  then SendDSPcommandRS232(3,OneParamValue)
  else begin
    if frmMain.USBstate[oneparam] = 'W' then exit;
    frmMain.USBstate[dspgetall] := 'X';
    OneParamNo := 3;
   frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzChBx_AutoNotchClick(Sender: TObject);
var
  v: byte;
begin
  if AutoNotchClicked then exit;
  AutoNotchClicked := true;
  if RzChBx_AutoNotch.Checked = true
  then OneParamValue := 1
  else OneParamValue := 0;
  if TelemMode = 'S'
  then SendDSPcommandRS232(4,OneParamValue)
  else begin
    if frmMain.USBstate[oneparam] = 'W' then exit;
    frmMain.USBstate[dspgetall] := 'X';
    OneParamNo := 4;
    frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzChBx_ManualNotchClick(Sender: TObject);
var
  v: byte;
begin
  if ManualNotchClicked then exit;
  ManualNotchClicked := true;
  if RzChBx_ManualNotch.Checked = true
  then OneParamValue := 1
  else OneParamValue := 0;
  if TelemMode = 'S'
  then SendDSPcommandRS232(5,OneParamValue)
  else begin
    if frmMain.USBstate[oneparam] = 'W' then exit;
    frmMain.USBstate[dspgetall] := 'X';
    OneParamNo := 5;
    frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzChBx_VoxQskClick(Sender: TObject);
var
  v: byte;
begin
  if VoxQSKClicked then exit;
  VoxQSKClicked := true;
  if RzChBx_VoxQsk.Checked = true
  then OneParamValue := 1
  else OneParamValue := 0;
  if TelemMode = 'S'
  then SendDSPcommandRS232(7,OneParamValue)
  else begin
    if frmMain.USBstate[oneparam] = 'W' then exit;
    frmMain.USBstate[dspgetall] := 'X';
    OneParamNo := 7;
    frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzChBx_SpeechCompClick(Sender: TObject);
var
  v: byte;
begin
  if SpeechCompClicked then exit;
  SpeechCompClicked := true;
  if RzChBx_SpeechComp.Checked = true
  then OneParamValue := 1
  else OneParamValue := 0;
  if TelemMode = 'S'
  then SendDSPcommandRS232(9,OneParamValue)
  else begin
    if frmMain.USBstate[oneparam] = 'W' then exit;
    frmMain.USBstate[dspgetall] := 'X';
    OneParamNo := 9;
    frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzBitBtn_WidthClick(Sender: TObject);
begin
  if FilterSwitch = 0 then FilterSwitch := 1 else FilterSwitch := 0;
  SetSwitches;
  if TelemMode = 'S'
  then SendDSPcommandRS232(6,FilterSwitch)
  else begin
    OneParamValue := FilterSwitch;
    OneParamNo := 6;
    frmMain.USBstate[oneparam] := 'W';
  end;
end;

procedure TfrmDSP.RzBitBtn_ModeClick(Sender: TObject);
begin
  inc(ssbcwmode);
  if SSBCWmode > 3 then SSBCWmode := 0;
  SetSwitches;
  OneParamValue := SSBCWmode;
  OneParamNo := 2;
  Need254 := true;
  if TelemMode = 'S'
  then SendDSPcommandRS232(2,SSBCWmode)
  else begin
    frmMain.USBstate[oneparam] := 'W';
    DspDelayEvent.ResetEvent;
    DspDelayEvent.WaitFor(1000);
  end;
end;


procedure TfrmDSP.SetUpColourSend(colour: byte);
begin
  if frmMain.USBstate[paramcol] = 'W' then exit;
  frmMain.USBstate[dspgetall] := 'X';
  ParamColourSendCode := Colour;
  Need254 := true;
  frmMain.USBstate[paramcol] := 'W';
end;


procedure TfrmDSP.RzBitBtn_GreenClick(Sender: TObject);
begin
  SetupColourSend(1);
end;

procedure TfrmDSP.RzBitBtn_RedClick(Sender: TObject);
begin
  SetupColourSend(3);
end;

procedure TfrmDSP.RzBitBtn_YellowClick(Sender: TObject);
begin
  SetupColourSend(2);
end;


/////////   TELEMETRY /////////////////

procedure TfrmDSP.ZeroMaxMin;
var
  i: byte;
begin
  for i := 1 to 8 do
  begin
    dbmax[i] := 0;
    dbmin[i] := 90;
    dbpeakr[i] := 0;
  end;
end;


procedure TfrmDSP.Timer_TelemTimer(Sender: TObject);
begin
  if not g_UsbReady then exit;
  if RzChBox_Lock.checked then exit;
  frmMain.USBstate[telem] := 'W';
end;








procedure TfrmDSP.ReceiveTelemetry;
var
  i: byte;
  ch: char;
begin
  Application.ProcessMessages;
  if TelemMode = 'U' then
  begin
    with Usb do
    begin
      Purge_USB_Device_In;
      usSendString('$$$DSP_T');   // T = telemetry
      DspDelayEvent.ResetEvent;
      DspDelayEvent.WaitFor(50);
      Application.ProcessMessages;
      Usb.usReceiveBlock(@telembuf[0],30);
    end;
  end
  else begin
    with frmMain.StarComPort do
    begin
      repeat
        ch := ReadChar;
      until ch='~';
      telembuf[0] := ord(ch);
      ch := ReadChar;
      if ch <> '~' then exit;
      telembuf[1] := ord(ch);
      for i := 2 to 23 do telembuf[i] := ord(ReadChar);
    end;
  end;
  Adc := telembuf[3] + 256*telembuf[2];
  HangStuff := telemBuf[4];
  Dac  := telembuf[6]  + 256*telembuf[5];
  Dev1 := telembuf[8]  + 256*telembuf[7];
  Dev2 := telembuf[10] + 256*telembuf[9];
  Dev3 := telembuf[12] + 256*telembuf[11];
  Dev4 := telembuf[14] + 256*telembuf[13];
  Dev5 := telembuf[16] + 256*telembuf[15];
  Dev6 := telembuf[18] + 256*telembuf[17];
  SmeterdB := telembuf[19];
  SPK := telembuf[20];
  uartADCgain := telembuf[21] DIV 16;
  SLed := (telembuf[21] AND $0F)*256 + telembuf[22];
  GN := telembuf[23];
  FwdDeciwattsDSP := telembuf[24] + 256*telembuf[25];
  RefDeciwattsDSP := telembuf[26] + 256*telembuf[27];
  SWRx100DSP := telembuf[28] + 256*telembuf[29];
  TelemTransmit := ((HangStuff AND $80)>0);
  RzPanel_RT.Visible := TelemTransmit;
  DoSmeter;
  UpdateMeter;
  DoGain;
  SetSwrMeters(TelemTransmit);
end;

procedure TfrmDSP.SetSwrMeters(transmit: boolean);
begin
  if transmit then
  begin
    RzMeter_Fwd.Value := (30*FwdDeciwattsDSP) DIV FwdFsDeciwatts;
    RzMeter_Ref.Value := (30*RefDeciwattsDSP) DIV RefFsDeciwatts;
    RzMeter_SWR.Value := (30*(SWRx100DSP-100)) DIV 300;
  end
  else begin
    RzMeter_Fwd.Value := 0;
    RzMeter_Ref.Value := 0;
    RzMeter_SWR.Value := 0;
  end;
end;

procedure TfrmDSP.DoGain;
var
  hs,xg,gain,hff: byte;
  agcdb, micgain: integer;
  r: single;
  ADCdb, Totalgain: byte;
begin
  hs := HangStuff AND $3F;
  gain := 0;
  for xg := 0 to 43 do
  begin
    if Params.paCalcurve[xg+1] >= hs then
    begin
      gain := xg;
      break;
    end;
  end;
  hff := 63 - hs;
  if TelemTransmit
  then RzLabel_DAC.Caption := ''
  else RzLabel_DAC.Caption := 'dac ' + IntToStr(hff);
  if TelemTransmit then
  begin
    micgain := GN;
    RzLabel_AD603.Caption := '';
    RzLabel_DAC.Caption := '';
    RzLabel_AD603Gain.Caption := 'VOGAD gain '
                    + IntToStr((micgain-100) + 36) + 'dB';
    RzLabel_ADC.Caption := '';
    RzLabel_AGC.Caption := '';
    RzLabel_GainLeft.Hide;
    Rzlabel_GainRight.Hide;
    dxDBGrid_Gain.Hide;
  end
  else begin
    agcdb := GN - 28;
    if agcdb < 0 then agcdb := 0;
    if agcdb > 72 then agcdb := 72;
    r := uartADCgain*1.5;
    ADCdb := round(r);
    RzLabel_AD603.Caption := 'AD603';
    RzLabel_DAC.Caption := 'dac ' + IntToStr(hff);
    RzLabel_AD603Gain.Caption := 'AD603 gain '
                    + IntToStr(gain) + 'dB';
    RzLabel_ADC.Caption := 'ADC ' + IntToStr(ADCdb) + 'dB';
    RzLabel_AGC.Caption := 'AGC ' + IntToStr(AGCdb) + 'dB';
    RzLabel_GainLeft.Show;
    Rzlabel_GainRight.Show;
    dxDBGrid_Gain.Show;
    Totalgain := gain + ADCdb + agcdb;
    RzLabel_GainLeft.Caption := 'Gain ' + IntToStr(TotalGain) + 'dB';
    Rzlabel_GainRight.Caption := IntToStr(123-TotalGain) + 'dB';
    with dxMemData_Gain do
    begin
      Locate('ID',0,[]);
      Edit;
      FieldValues['METER'] := TotalGain;
      FieldValues['GAIN'] := gain;
      FieldValues['ADCDB'] := ADCdb;
      FieldValues['AGCDB'] := agcdb;
      Post;
    end;
  end;
end;

procedure TfrmDSP.DoSmeter;
var
  i: byte;
begin
  if TelemTransmit then
  begin
   RzLabel_ss.Caption := '';
   RzLabel_S1.Visible := false;
   RzLabel_S5.Visible := false;
   RzLabel_S9.Visible := false;
   RzLabel_S930.Caption := 'Tx out';
  end
  else begin
    RzLabel_ss.Caption := SmeterText(SmeterdB);
    RzLabel_S1.Visible := true;
    RzLabel_S5.Visible := true;
    RzLabel_S9.Visible := true;
    RzLabel_S930.Caption := 'S9 + 30dB';
  end;
  RzLabel_Hang.Visible := ((HangStuff AND $40)>0) AND not TelemTransmit;
  RzLabel_Spike.Visible := (SPK=1) AND not TelemTransmit;
  for i := 0 to 11 do
  begin
    if SLed > 0 then SLed := SLed DIV 2 else break;
  end;
  RzMeter_Smeter.Value := i;
  UpdateMeter;
end;



function TfrmDSP.SmeterText(db: byte): string;
var
  x,y,s,over: byte;
begin
  x := db;
  if x > 59 then x := 59;
  s := x DIV 6;
  if db < 60
  then over := 0
  else over := ((db - 54) DIV 10)*10;
  result := IntToStr(db) + 'dB/S0  =  ' + 'S' + IntToStr(s);
  if over > 0 then result := result + '+' + IntToStr(over) + 'dB';
end;

procedure TfrmDSP.SetupGainBar;
var
  Id: byte;
begin
  with dxMemData_Gain do
  begin
    Close;
    Open;
    Append;
    FieldValues['ID'] := Id;
    FieldValues['METER'] := 0;
    FieldValues['GAIN']  := 0;
    FieldValues['ADCDB'] := 0;
    FieldValues['AGCDB'] := 0;
    Post;
  end;
end;



procedure TfrmDSP.SetupMeter;
var
  Id: byte;
begin
  with dxMemData_Meter do
  begin
    Close;
    Open;
    for Id := 1 to 8 do
    begin
      Append;
      FieldValues['ID'] := Id;
      FieldValues['NAME'] := MeterNameList[Id,ord(Transmit)];
      FieldValues['HEX'] := '0000';
      FieldValues['PERCENT'] := '0.00';
      FieldValues['DB'] := 0;
      FieldValues['METER'] := 0;
      FieldValues['MIN'] := 0;
      FieldValues['MAX'] := 0;
      FieldValues['DIFF'] := 0;
      FieldValues['DBPEAK'] := 0;
      Post;
    end;
  end;
end;



procedure TfrmDSP.UpdateMeter;
var
  Id: byte;
  dspdata: word;
  db, dbpeak: byte;
  dbr, r: real;
begin
  for Id := 1 to 8 do
  begin
    case Id of
      1: dspdata := Adc;
      2: dspdata := Dev6;
      3: dspdata := Dev1;
      4: dspdata := Dev2;
      5: dspdata := Dev4;
      6: dspdata := Dev5;
      7: dspdata := Dev3;
      8: dspdata := Dac;
    end; { case}
    if dspdata = 0
    then db := 0
    else begin
      r := dspdata;
      db := 90 - round(8.685889638*(Ln(32768/r)));
    end;
    if db > dbmax[Id] then dbmax[Id] := db;
    if db < dbmin[Id] then dbmin[Id] := db;
    //    if db > dbpeakr[Id]
//    then dbpeakr[Id] := db
//    else dbpeakr[Id] := dbpeakr[Id] - 0.18;
//    if dbpeakr[Id] < 0 then dbpeakr[Id] := 0;  // added IJS
//    dbpeak := round(dbpeakr[Id]);
    dbpeak := db;
    with dxMemData_Meter do
    begin
      Locate('ID',Id,[]);
      Edit;
      FieldValues['NAME'] := MeterNameList[Id,ord(TelemTransmit)];
      FieldValues['HEX'] := IntToHex(dspdata,4);
      FieldValues['PERCENT'] := FloatToStrF(dspdata/32768,ffFixed,4,2);
      FieldValues['DB'] := db;
      FieldValues['METER'] := dbpeak;
      FieldValues['MIN'] := dbmin[Id];
      FieldValues['MAX'] := dbmax[Id];
      FieldValues['DIFF'] := dbmax[Id] - dbmin[Id];
      FieldValues['DBPEAK'] := dbpeak;
      Post;
    end;
  end;
end;

procedure TfrmDSP.dxDBGrid_MeterCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  i,dbpeak: byte;
  x,y: word;
  BarRect: TRect;
begin
  ASelected := false;
  AFocused := False;
  AFont.Color := clNavy;
  with ACanvas, ARect do
  begin
    dbpeak :=  ANode.Values[MeterDbPeakFieldIndex];
    Pen.Style := psSolid;
    Pen.Mode := pmCopy;
    Pen.Color := dxDBGrid_Meter.GridLineColor;
    Pen.Width := 1;
    if AColumn = MCol_Meter then
    begin
      Brush.Color := clWindow;
      FillRect(ARect);
      for i := 1 to 9 do
      begin
        x := Left+40*i;
        MoveTo(x,Top);
        LineTo(x,Top+2);
        MoveTo(x,Bottom-2);
        LineTo(x,Bottom);
      end;
      BarRect.Top := Top+3;
      BarRect.Bottom := Bottom-3;
      for i := 1 to dbpeak do
      begin
        BarRect.Left := Left-2+i*4;
        BarRect.Right := Left+i*4;
        Brush.Color := BarColours[(i-1) DIV 10];
        FillRect(BarRect);
      end;
      ADone := true;
    end;
    if AColumn = Mcol_Name then
    begin
      if Transmit then AFont.Color := clBlue else AFont.Color := clGreen;
    end;
    if AColumn = Mcol_Db then AFont.Color := clMaroon;
  end;
end;

procedure TfrmDSP.dxDBGrid_GainCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
var
  i,j: byte;
  x,y: word;
  BarRect: TRect;
  gain, adcdb,agcdb: byte;
begin
  if AColumn = GainCol_Meter then
  begin
    gain := ANode.Values[GainBarGainFieldIndex];
    adcdb := ANode.Values[GainBarADCDBFieldIndex];
    agcdb := ANode.Values[GainBarAGCDBFieldIndex];
    with ACanvas, ARect do
    begin
      Pen.Style := psSolid;
      Pen.Mode := pmCopy;
      Pen.Color := dxDBGrid_Gain.GridLineColor;
      Pen.Width := 1;
      if AColumn = GainCol_Meter then
      begin
        Brush.Color := clWindow;
        FillRect(ARect);
        for i := 1 to 13 do
        begin
          x := Left+40*i;
          MoveTo(x,Top);
          LineTo(x,Top+2);
          MoveTo(x,Bottom-2);
          LineTo(x,Bottom);
        end;
        BarRect.Top := Top+5;
        BarRect.Bottom := Bottom-5;
        for i := 1 to gain do
        begin
          BarRect.Left := Left-2+i*4;
          BarRect.Right := Left+i*4;
          Brush.Color := clBlue;
          FillRect(BarRect);
        end;
        j := i;
        for i := j to adcdb + j - 1 do
        begin
          BarRect.Left := Left-2+i*4;
          BarRect.Right := Left+i*4;
          Brush.Color := clRed;
          FillRect(BarRect);
        end;
        j := i;
        for i := j to agcdb + j - 1 do
        begin
          BarRect.Left := Left-2+i*4;
          BarRect.Right := Left+i*4;
          Brush.Color := clGray;
          FillRect(BarRect);
        end;
        BarRect.Top := Top+3;
        BarRect.Bottom := Bottom-3;
        j := i;
        for i := j to 123 do
        begin
          BarRect.Left := Left-2+i*4;
          BarRect.Right := Left+i*4;
          Brush.Color := clGreen;
          FillRect(BarRect);
        end;
        ADone := true;
      end;
    end;
  end;
end;

procedure TfrmDSP.RzBitBtn_ZeroMaxMinClick(Sender: TObject);
begin
  ZeroMaxMin;
end;

procedure TfrmDSP.RzBitBtn1Click(Sender: TObject);
begin
  Close;
end;



procedure TfrmDSP.SendDSPcommandRS232(p,v: byte);
begin
  with frmMain.StarComPort do
  begin
    WriteChar('~');
    WriteChar(char(p));
    WriteChar(char(v));
    WriteChar('~');
    WriteChar('~');
    DspDelayEvent.ResetEvent;
    DspDelayEvent.WaitFor(30);
  end;
end;

procedure TfrmDSP.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer_Telem.Enabled := false;
  Timer_DSP.Enabled := false;
  RzChBox_Lock.Checked := true;
  Application.ProcessMessages;
  Action := caNone;
  Timer_Close.Enabled := true
end;





procedure TfrmDSP.Timer_CloseTimer(Sender: TObject);
begin
  DspDelayEvent.ResetEvent;
  DspDelayEvent.WaitFor(1200);
  Application.ProcessMessages;
  DspDelayEvent.Free;
  Free;
  frmDSP := nil;
end;



procedure TfrmDSP.MI_SetBackup_LeftClick(Sender: TObject);
begin
  frmMain.USBstate[parambk] := 'W';
end;

procedure TfrmDSP.MI_SetBackup_MidClick(Sender: TObject);
begin
  frmMain.USBstate[parambk] := 'W';
end;

procedure TfrmDSP.MI_SetBackup_RightClick(Sender: TObject);
begin
  frmMain.USBstate[parambk] := 'W';
end;

procedure TfrmDSP.MI_Set254_LeftClick(Sender: TObject);
begin
  Send254;
end;

procedure TfrmDSP.MI_Set254_MidClick(Sender: TObject);
begin
  Send254;
end;

procedure TfrmDSP.MI_Set254_RightClick(Sender: TObject);
begin
  Send254;
end;

procedure TfrmDSP.RzBitBtn_BkpClick(Sender: TObject);
begin
  frmMain.USBstate[paramstobk] := 'W';
end;

procedure TfrmDSP.RzBitBtn_CloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDSP.RzBitBtn_HelpClick(Sender: TObject);
begin
  Aboutbox.HtmlHelp.ChmFile := ExtractFilePath(Application.EXEName) + 'Hobcat.chm';
  AboutBox.HtmlHelp.DisplayContext(3010);
end;

end.


