unit UfrmCalCurve;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, Syncobjs, StdCtrls, RzLabel, D2XXUnit;

type
  TfrmCalCurve = class(TForm)
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_Help: TRzBitBtn;
    RzBitBtn_Load: TRzBitBtn;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    procedure RzBitBtn_LoadClick(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
  private
    block: array[0..41] of byte;
    CalCurveDelayEvent: TEvent;
    function DoSendCalCurve: boolean;
  public
    procedure Initialise;
    procedure SendCalCurve;
  end;

var
  frmCalCurve: TfrmCalCurve;

implementation

uses UfrmMain, UParams, UUsb;

{$R *.dfm}


procedure TfrmCalCurve.Initialise;
var
  i: integer;
begin
  Params.paInputCalCurve;
  for i := 0 to 41 do block[i] := Params.paCalCurve[i+1];
  CalCurveDelayEvent := TEvent.Create(0, true, false, 'Hobcat CalCurve send delay event');
end;


procedure TfrmCalCurve.SendCalCurve;
begin
  if DoSendCalCurve then
  begin
    MessageDlg('AD603 calibration sent',mtInformation,[mbOk],0);
  end
  else
  begin
    MessageDlg('Failed to send AD603 calibration',mtWarning,[mbOK],0);
  end;
end;


function TfrmCalCurve.DoSendCalCurve: boolean;
begin
  result := false;
  CalCurveDelayEvent.ResetEvent;
  CalCurveDelayEvent.WaitFor(1000);
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$DSP_V')
  then exit
  else begin
    if not Usb.usSendBlock(@block,42) then exit;
  end;
  result := true;
end;


procedure TfrmCalCurve.RzBitBtn_LoadClick(Sender: TObject);
begin
  frmMain.USBstate[ad603] := 'W';
end;

procedure TfrmCalCurve.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

end.



