 unit URichText;

interface


uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
        StdCtrls, UIniData, UGlobals, Contnrs;

type
  str11 = string[11];



    TRcItem =
      class
        rcReadCode: string;
        rcSub: integer;
        rcExclud: integer;                                                                     
        constructor Create(aReadCode: string; aSub, aExclud: integer);
      end;




  TRichText = class
                FormatString: string;
                FormatStringNotes: string;
                FormatStringBP: string;
                FormatStringQAOF: string;
                ItemIdent: string;
                ItemTitle: string;
                CrFilters: string;
                ItemMaxCount: integer;
                ItemFirstDate: TDateTime;
                ItemLastDate: TDateTime;
                ItemUseReadCodes: integer;
                ItemDrugAdmin: integer;
                ItemDrugCompliance: integer;
                ItemNonDrugs: integer;
                SummaryFontName: string;
                SummaryFontSize: integer;       {default font size = IniFontSize}
                SummaryHideHeaders: integer;
                //PersonSeenId: integer;
                ReportTitle: string;
                DummyString: string;
                ClinRecProbList: TObjectList;
                DateWidth: integer;
                function CrZap(s: string): string;
                Procedure SetFormatStrings;
                procedure WriteColourDefs;
                procedure SetRtfColours(UseColour: boolean);
                function Sz(SizeChar: char): str11;
                procedure InitialiseTextFile(FilePath: string);
                function TodayNow: TDateTime;
                procedure FinaliseTextFile;
                procedure CloseExceptTextFile;
                procedure WriteHeading(Title: string);
                procedure WriteHeaderData(ReportTitle: string);
                procedure WriteCal32;
                procedure WriteMisc;
              end;


implementation

uses UfrmCalswr;

const
  {minimum rich text header}
  RtfHeader1: string = '{\rtf1\ansi\ansicpg1252\deff0\deflang2057{\fonttbl{\f0\fnil\fcharset0 ';
  RtfHeader2: string = ';}{\f1\fnil\fcharset0 Courier New;}}';
  RtfHeader3: string = '\viewkind4\uc1\pard\f0 ';



////////////  TRcItem ///////////////////////

constructor TRcItem.Create(aReadCode: string; aSub, aExclud: integer);
begin
  inherited Create;
  rcReadCode := aReadCode;
  rcSub := aSub;
  rcExclud := aExclud;
end;


///////////  TRichText ////////////////////////////////


procedure TRichText.CloseExceptTextfile;
begin
  try
    //CloseFile(g_TextFile);
  except
  end;
end;


procedure TRichText.SetFormatStrings;
var
  f1,f2,f3,h1,h2: integer;
begin
  f1 := DateWidth*20;
  h1 := DateWidth*18;
  FormatString  := concat('\pard\tx', IntToStr(f1),' \li',IntToStr(f1),' \fi-',IntToStr(h1),' ');

  f1 := DateWidth*5;
  f2 := DateWidth*8;
  h1 := DateWidth*4;
  h2 := DateWidth*7;
  FormatStringNotes := concat('\pard \tx', IntToStr(f2),'\pard \tx', IntToStr(f1),' \li',IntToStr(f2),
                  ' \fi-',IntToStr(h2),' ');
  f1 := DateWidth*8;
  f2 := DateWidth*48;
  f3 := DateWidth*88;
  FormatStringBP := concat('\pard \tx',IntToStr(f1),' \tx',IntToStr(f2),' \tx',IntToStr(f3),' ');

  f1 := DateWidth*30;
  h1 := DateWidth*30;
  FormatStringQAOF := concat('\pard\tx', IntToStr(f1),' \li',IntToStr(f1),' \fi-',IntToStr(h1),' ');
end;



procedure TRichText.WriteColourDefs;
var
  i: byte;
  s: string[27];
  m: integer;
begin
  m := 3;
  writeln(g_TextFile,'{\colortbl ;');
  for i := 1 to 9 do begin
    s := concat('\red',IntToStr((m*g_ColourDefs[i,cr]) DIV 2));
    s := concat(s,'\green',IntToStr((m*g_ColourDefs[i,cg]) DIV 2));
    s := concat(s,'\blue',IntToStr((m*g_ColourDefs[i,cb]) DIV 2),';');
    writeln(g_TextFile,s);
  end;
  writeln(g_TextFile,'}');
end;







procedure TRichText.SetRtfColours(UseColour: boolean);
begin
  if UseColour then begin
   cHeader        := cBlack;
   cHeading1      := cNavy;
   cHeading2      := cTeal;
   cAdc           := cMagenta;
   cWatts         := cBlue;
   cLedNo         := cGreen;
  end
  else begin
   cHeader        := cBlack;
   cHeading1      := cBlack;
   cHeading2      := cBlack;
   cAdc           := cBlack;
   cWatts         := cBlack;
   cLedNo         := cBlack;
  end;
end;

function TRichText.Sz(SizeChar: char): str11;
var
  d: integer;
begin
  case SizeChar of
    'S': d := -1;
    'N': d := 0;
    'L': d := 2;
    'E': d := 4;
  else d := 0;
  end;
  result := concat('\fs',IntToStr(2*(SummaryFontSize + d)),' ');
end;


procedure TRichText.InitialiseTextFile(FilePath: string);
begin
  CloseExceptTextFile;
  assignfile(g_TextFile,FilePath);
  Rewrite(g_TextFile);
  writeln(g_TextFile,RtfHeader1,SummaryFontName, RtfHeader2);
  WriteColourDefs;
  writeln(g_TextFile,RtfHeader3);
end;




function TRichText.TodayNow: TDateTime;
var
  SystemTime: TSystemTime;
begin
  GetLocalTime(SystemTime);
  Result := SystemTimeToDateTime(SystemTime);
end;


function TRichText.CrZap(s: string): string;
begin
  result := StringReplace(s,' <-| ','\par \tab ',[rfReplaceAll]);
end;


procedure TRichText.FinaliseTextFile;
begin
  writeln(g_TextFile, '\par }');
  CloseFile(g_TextFile);
end;


procedure TRichText.WriteHeading(Title: string);
begin
  writeln(g_TextFile,cHeading1,Sz('L'),'\b ',Title,Sz('N'),'\b0 \par \par ');
end;



procedure TRichText.WriteHeaderData(ReportTitle: string);
begin
  writeln(g_TextFile,cHeader,Sz('E'),'\b ',ReportTitle,'\b0');
  writeln(g_TextFile,Sz('L'),'     ', DateToStr(TodayNow),Sz('N'),'\par \par');
end;


procedure TRichText.WriteMisc;
var
  f: single;
begin
  write(g_TextFile,cHeading1);
  writeln(g_TextFile,'\b Power meter full scale watts.\b0 \par');
  writeln(g_TextFile,' 40x2 or 20x4 character displays: Power meter scales will only be labelled if full scale range is 130w or 25w.\par ');
  writeln(g_TextFile,' 320x240 graphics display: Available full scale ranges are 150w, 75w, 30w, 15w and 7.5w.\par ');
  writeln(g_textFile,'    TrxAVR-Picastar automatically selects next closest range above specified full scale watts.\par \par');
  f := frmCalswr.CalFwd.caFsWatts;
  writeln(g_TextFile, '\tab Forward full scale watts  =  \b ', FloatToStrF(f,ffFixed,6,2),'\b0 \par ');
  f := frmCalswr.CalRef.caFsWatts;
  writeln(g_TextFile, '\tab Reflected full scale watts  =  \b ', FloatToStrF(f,ffFixed,6,2),'\b0 \par \par');
  writeln(g_TextFile,'\b PA bias shut down settings.\b0 \par ');
  f := frmCalswr.CalRef.caMismatchWatts / 10;
  writeln(g_TextFile, '\tab Reflected mismatch watts  =  \b ', FloatToStrF(f,ffFixed,6,1),'\b0 \par ');
  f := frmCalswr.CalRef.caMismatchSeconds;
  writeln(g_TextFile, '\tab Reflected mismatch seconds  =  \b ', FloatToStrF(f,ffFixed,6,1),'\b0 \par ');
  writeln(g_TextFile,'\par ');
end;


procedure TRichText.WriteCal32;
var
  n,i: integer;
  s: string;
  f: single;
begin
  write(g_TextFile, FormatString);
  writeln(g_TextFile, cHeading2,'\b Data entered: \tab \tab \tab \tab \tab \tab \tab Data normalised:\b0 ');
  writeln(g_TextFile, '\par \par');
  writeln(g_TextFile, '\b ' + cAdc + 'fwd adc\tab \tab ' + cWatts + 'fwd w\tab \tab '
                      + cAdc + 'ref adc\tab \tab ' + cWatts + 'ref w'
                      + '\tab \tab ' + cAdc + 'adc \tab \tab ' + cWatts + 'fwd w\tab \tab ref w\b0 ');
  writeln(g_TextFile,'\par \par ');
  for i := 1 to 32 do
  begin
    n := frmCalswr.CalFwd.caData[i].adc;
    write(g_TextFile,cAdc,IntToStr(n));
    f := frmCalswr.CalFwd.caData[i].watts / 100;
    write(g_TextFile,'    \tab \tab ',cWatts,FloatToStrF(f,ffFixed,6,1));
    n := frmCalswr.CalRef.caData[i].adc;
    write(g_TextFile,'    \tab \tab ',cAdc,IntToStr(n));
    f := frmCalswr.CalRef.caData[i].watts / 100;
    write(g_TextFile,'    \tab \tab ',cWatts,FloatToStrF(f,ffFixed,6,1));

    n := (i-1)*32;
    write(g_TextFile,'    \tab \tab ',cAdc,IntToStr(n));
    f := frmCalswr.CalFwd.caWatts32[i] / 100;
    write(g_TextFile,'    \tab \tab ',cWatts,FloatToStrF(f,ffFixed,6,1));
    f := frmCalswr.CalRef.caWatts32[i] / 100;
    write(g_TextFile,'    \tab \tab ',cWatts,FloatToStrF(f,ffFixed,6,1));
    writeln(g_TextFile,'\par ');
  end;
  writeln(g_TextFile,'\par  ');
end;




end.




