/*
 *****    homebrew-radios.net   *****

 *****     Project Encoders8       *****
 
 Encoders8 controller board using ATmega2560

 encoders8.c  ATmega2560  encoders8 controller program

 VERSION = 1.00  -  Initial release
 VERSION = 1.01  -  Watchdog timer code added
 VERSION = 1.02  -  abs() added to Sendcount to determine if value > 9
 VERSION = 1.03  -  Change to fully interrupt driven with software debounce

*/

#include "encoders8.h"
#include "en_RS232.h"
#include "en_Encoders.h"

static const char pmdEncoders8Version[] PROGMEM = "encoders8 v1.03";

static void e8Mega2560Init();


//Program start
int main(void)
{
	cli();
	
	e8Mega2560Init();
	rsInit();
	enEncodersInit();

	sei();


	// main program loop
	while (true) {
		SMCR = 0x01;  // Enable idle sleep mode
		__asm__ __volatile__ ( "sleep" "\n\t" :: );
	}

	return 0;
}


void e8Mega2560Init()
{
 	MCUSR = 0x00;	// Clear all bits in Reset Status register

	// Set watchdog timer off
	WDTCSR = ((1 << WDCE) | (1 << WDE));
	WDTCSR = 0x00;

	DDRA = 0x00;  // Set port A pins 0 - 7 to input
	DDRB = 0x00;  // Set port B pins 0 - 7 to input
	DDRC = 0x00;  // Set port C pins 0 - 7 to input
	DDRD = 0x00;  // Set port D pins 0 - 7 to input
	DDRE = 0x00;  // Set port E pins 0 - 7 to input
	DDRF = 0x00;  // Set port F pins 0 - 7 to input
	DDRG = 0x00;  // Set port G pins 0 - 5 to input
	DDRH = 0x00;  // Set port H pins 0 - 7 to input
	DDRJ = 0x00;  // Set port J pins 0 - 7 to input
	DDRK = 0x00;  // Set port K pins 0 - 7 to input
	DDRL = 0x00;  // Set port L pins 0 - 7 to input

	PORTA = 0xff; // Enable pullups for port A pins 0 - 7
	PORTB = 0xff; // Enable pullups for port B pins 0 - 7
	PORTC = 0xff; // Enable pullups for port C pins 0 - 7
	PORTD = 0xff; // Enable pullups for port D pins 0 - 7
	PORTE = 0xff; // Enable pullups for port E pins 0 - 7
	PORTF = 0xff; // Enable pullups for port F pins 0 - 7
	PORTG = 0xff; // Enable pullups for port G pins 0 - 5
	PORTH = 0xff; // Enable pullups for port H pins 0 - 7
	PORTJ = 0xff; // Enable pullups for port J pins 0 - 7
	PORTK = 0xff; // Enable pullups for port K pins 0 - 7
	PORTL = 0xff; // Enable pullups for port L pins 0 - 7

	// Configure power reduction registers
	PRR0 = 0xe5;
	PRR1 = 0x3f;
	
	return;
}
